/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribedWebAppCustomization
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribedWebAppCustomization> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(DescribedWebAppCustomization.getter(DescribedWebAppCustomization::arn)).setter(DescribedWebAppCustomization.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WebAppId").getter(DescribedWebAppCustomization.getter(DescribedWebAppCustomization::webAppId)).setter(DescribedWebAppCustomization.setter(Builder::webAppId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(DescribedWebAppCustomization.getter(DescribedWebAppCustomization::title)).setter(DescribedWebAppCustomization.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<SdkBytes> LOGO_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("LogoFile").getter(DescribedWebAppCustomization.getter(DescribedWebAppCustomization::logoFile)).setter(DescribedWebAppCustomization.setter(Builder::logoFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogoFile").build()}).build();
    private static final SdkField<SdkBytes> FAVICON_FILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("FaviconFile").getter(DescribedWebAppCustomization.getter(DescribedWebAppCustomization::faviconFile)).setter(DescribedWebAppCustomization.setter(Builder::faviconFile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconFile").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD, TITLE_FIELD, LOGO_FILE_FIELD, FAVICON_FILE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("WebAppId", WEB_APP_ID_FIELD);
            this.put("Title", TITLE_FIELD);
            this.put("LogoFile", LOGO_FILE_FIELD);
            this.put("FaviconFile", FAVICON_FILE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String webAppId;
    private final String title;
    private final SdkBytes logoFile;
    private final SdkBytes faviconFile;

    private DescribedWebAppCustomization(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.title = builder.title;
        this.logoFile = builder.logoFile;
        this.faviconFile = builder.faviconFile;
    }

    public final String arn() {
        return this.arn;
    }

    public final String webAppId() {
        return this.webAppId;
    }

    public final String title() {
        return this.title;
    }

    public final SdkBytes logoFile() {
        return this.logoFile;
    }

    public final SdkBytes faviconFile() {
        return this.faviconFile;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.logoFile());
        hashCode = 31 * hashCode + Objects.hashCode(this.faviconFile());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedWebAppCustomization)) {
            return false;
        }
        DescribedWebAppCustomization other = (DescribedWebAppCustomization)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.webAppId(), other.webAppId()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.logoFile(), other.logoFile()) && Objects.equals(this.faviconFile(), other.faviconFile());
    }

    public final String toString() {
        return ToString.builder((String)"DescribedWebAppCustomization").add("Arn", (Object)this.arn()).add("WebAppId", (Object)this.webAppId()).add("Title", (Object)this.title()).add("LogoFile", (Object)(this.logoFile() == null ? null : "*** Sensitive Data Redacted ***")).add("FaviconFile", (Object)(this.faviconFile() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "WebAppId": {
                return Optional.ofNullable(clazz.cast(this.webAppId()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "LogoFile": {
                return Optional.ofNullable(clazz.cast(this.logoFile()));
            }
            case "FaviconFile": {
                return Optional.ofNullable(clazz.cast(this.faviconFile()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribedWebAppCustomization, T> g) {
        return obj -> g.apply((DescribedWebAppCustomization)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String webAppId;
        private String title;
        private SdkBytes logoFile;
        private SdkBytes faviconFile;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedWebAppCustomization model) {
            this.arn(model.arn);
            this.webAppId(model.webAppId);
            this.title(model.title);
            this.logoFile(model.logoFile);
            this.faviconFile(model.faviconFile);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return this.webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final ByteBuffer getLogoFile() {
            return this.logoFile == null ? null : this.logoFile.asByteBuffer();
        }

        public final void setLogoFile(ByteBuffer logoFile) {
            this.logoFile(logoFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)logoFile));
        }

        @Override
        public final Builder logoFile(SdkBytes logoFile) {
            this.logoFile = logoFile;
            return this;
        }

        public final ByteBuffer getFaviconFile() {
            return this.faviconFile == null ? null : this.faviconFile.asByteBuffer();
        }

        public final void setFaviconFile(ByteBuffer faviconFile) {
            this.faviconFile(faviconFile == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)faviconFile));
        }

        @Override
        public final Builder faviconFile(SdkBytes faviconFile) {
            this.faviconFile = faviconFile;
            return this;
        }

        public DescribedWebAppCustomization build() {
            return new DescribedWebAppCustomization(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribedWebAppCustomization> {
        public Builder arn(String var1);

        public Builder webAppId(String var1);

        public Builder title(String var1);

        public Builder logoFile(SdkBytes var1);

        public Builder faviconFile(SdkBytes var1);
    }
}

