/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This response identifies the user, server they belong to, and the identifier of the SSH public key associated with
 * that user. A user can have more than one key on each server that they are associate with.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportSshPublicKeyResponse extends TransferResponse implements
        ToCopyableBuilder<ImportSshPublicKeyResponse.Builder, ImportSshPublicKeyResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSshPublicKeyResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSshPublicKeyResponse::sshPublicKeyId)).setter(setter(Builder::sshPublicKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ImportSshPublicKeyResponse::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SSH_PUBLIC_KEY_ID_FIELD, USER_NAME_FIELD));

    private final String serverId;

    private final String sshPublicKeyId;

    private final String userName;

    private ImportSshPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * A system-assigned unique identifier for an SFTP server.
     * </p>
     * 
     * @return A system-assigned unique identifier for an SFTP server.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * This identifier is the name given to a public key by the system that was imported.
     * </p>
     * 
     * @return This identifier is the name given to a public key by the system that was imported.
     */
    public String sshPublicKeyId() {
        return sshPublicKeyId;
    }

    /**
     * <p>
     * A user name assigned to the <code>ServerID</code> value that you specified.
     * </p>
     * 
     * @return A user name assigned to the <code>ServerID</code> value that you specified.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportSshPublicKeyResponse)) {
            return false;
        }
        ImportSshPublicKeyResponse other = (ImportSshPublicKeyResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(sshPublicKeyId(), other.sshPublicKeyId())
                && Objects.equals(userName(), other.userName());
    }

    @Override
    public String toString() {
        return ToString.builder("ImportSshPublicKeyResponse").add("ServerId", serverId()).add("SshPublicKeyId", sshPublicKeyId())
                .add("UserName", userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "SshPublicKeyId":
            return Optional.ofNullable(clazz.cast(sshPublicKeyId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportSshPublicKeyResponse, T> g) {
        return obj -> g.apply((ImportSshPublicKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ImportSshPublicKeyResponse> {
        /**
         * <p>
         * A system-assigned unique identifier for an SFTP server.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for an SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * This identifier is the name given to a public key by the system that was imported.
         * </p>
         * 
         * @param sshPublicKeyId
         *        This identifier is the name given to a public key by the system that was imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyId(String sshPublicKeyId);

        /**
         * <p>
         * A user name assigned to the <code>ServerID</code> value that you specified.
         * </p>
         * 
         * @param userName
         *        A user name assigned to the <code>ServerID</code> value that you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String serverId;

        private String sshPublicKeyId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportSshPublicKeyResponse model) {
            super(model);
            serverId(model.serverId);
            sshPublicKeyId(model.sshPublicKeyId);
            userName(model.userName);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getSshPublicKeyId() {
            return sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public ImportSshPublicKeyResponse build() {
            return new ImportSshPublicKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
