/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestIdentityProviderResponse extends TransferResponse implements
        ToCopyableBuilder<TestIdentityProviderResponse.Builder, TestIdentityProviderResponse> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Integer> STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TestIdentityProviderResponse::statusCode)).setter(setter(Builder::statusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()).build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TestIdentityProviderResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD,
            STATUS_CODE_FIELD, URL_FIELD));

    private final String message;

    private final Integer statusCode;

    private final String url;

    private TestIdentityProviderResponse(BuilderImpl builder) {
        super(builder);
        this.message = builder.message;
        this.statusCode = builder.statusCode;
        this.url = builder.url;
    }

    /**
     * <p>
     * The result of the authorization test as a message.
     * </p>
     * 
     * @return The result of the authorization test as a message.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * The HTTP status code that is the response from your API Gateway.
     * </p>
     * 
     * @return The HTTP status code that is the response from your API Gateway.
     */
    public Integer statusCode() {
        return statusCode;
    }

    /**
     * <p>
     * The endpoint of the service used to authenticate a user.
     * </p>
     * 
     * @return The endpoint of the service used to authenticate a user.
     */
    public String url() {
        return url;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(statusCode());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestIdentityProviderResponse)) {
            return false;
        }
        TestIdentityProviderResponse other = (TestIdentityProviderResponse) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(statusCode(), other.statusCode())
                && Objects.equals(url(), other.url());
    }

    @Override
    public String toString() {
        return ToString.builder("TestIdentityProviderResponse").add("Message", message()).add("StatusCode", statusCode())
                .add("Url", url()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "StatusCode":
            return Optional.ofNullable(clazz.cast(statusCode()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TestIdentityProviderResponse, T> g) {
        return obj -> g.apply((TestIdentityProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, TestIdentityProviderResponse> {
        /**
         * <p>
         * The result of the authorization test as a message.
         * </p>
         * 
         * @param message
         *        The result of the authorization test as a message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The HTTP status code that is the response from your API Gateway.
         * </p>
         * 
         * @param statusCode
         *        The HTTP status code that is the response from your API Gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusCode(Integer statusCode);

        /**
         * <p>
         * The endpoint of the service used to authenticate a user.
         * </p>
         * 
         * @param url
         *        The endpoint of the service used to authenticate a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String message;

        private Integer statusCode;

        private String url;

        private BuilderImpl() {
        }

        private BuilderImpl(TestIdentityProviderResponse model) {
            super(model);
            message(model.message);
            statusCode(model.statusCode);
            url(model.url);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final Integer getStatusCode() {
            return statusCode;
        }

        @Override
        public final Builder statusCode(Integer statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public final void setStatusCode(Integer statusCode) {
            this.statusCode = statusCode;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public TestIdentityProviderResponse build() {
            return new TestIdentityProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
