/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteSshPublicKeyRequest extends TransferRequest implements
        ToCopyableBuilder<DeleteSshPublicKeyRequest.Builder, DeleteSshPublicKeyRequest> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSshPublicKeyRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSshPublicKeyRequest::sshPublicKeyId)).setter(setter(Builder::sshPublicKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteSshPublicKeyRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            SSH_PUBLIC_KEY_ID_FIELD, USER_NAME_FIELD));

    private final String serverId;

    private final String sshPublicKeyId;

    private final String userName;

    private DeleteSshPublicKeyRequest(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.sshPublicKeyId = builder.sshPublicKeyId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP) server instance that has the user
     * assigned to it.
     * </p>
     * 
     * @return A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP) server instance that has
     *         the user assigned to it.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * A unique identifier used to reference your user’s specific SSH key.
     * </p>
     * 
     * @return A unique identifier used to reference your user’s specific SSH key.
     */
    public String sshPublicKeyId() {
        return sshPublicKeyId;
    }

    /**
     * <p>
     * A unique string that identifies a user whose public key is being deleted.
     * </p>
     * 
     * @return A unique string that identifies a user whose public key is being deleted.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSshPublicKeyRequest)) {
            return false;
        }
        DeleteSshPublicKeyRequest other = (DeleteSshPublicKeyRequest) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(sshPublicKeyId(), other.sshPublicKeyId())
                && Objects.equals(userName(), other.userName());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteSshPublicKeyRequest").add("ServerId", serverId()).add("SshPublicKeyId", sshPublicKeyId())
                .add("UserName", userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "SshPublicKeyId":
            return Optional.ofNullable(clazz.cast(sshPublicKeyId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteSshPublicKeyRequest, T> g) {
        return obj -> g.apply((DeleteSshPublicKeyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteSshPublicKeyRequest> {
        /**
         * <p>
         * A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP) server instance that has the
         * user assigned to it.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for a Secure File Transfer Protocol (SFTP) server instance that
         *        has the user assigned to it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * A unique identifier used to reference your user’s specific SSH key.
         * </p>
         * 
         * @param sshPublicKeyId
         *        A unique identifier used to reference your user’s specific SSH key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyId(String sshPublicKeyId);

        /**
         * <p>
         * A unique string that identifies a user whose public key is being deleted.
         * </p>
         * 
         * @param userName
         *        A unique string that identifies a user whose public key is being deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String serverId;

        private String sshPublicKeyId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSshPublicKeyRequest model) {
            super(model);
            serverId(model.serverId);
            sshPublicKeyId(model.sshPublicKeyId);
            userName(model.userName);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getSshPublicKeyId() {
            return sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSshPublicKeyRequest build() {
            return new DeleteSshPublicKeyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
