/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServersResponse extends TransferResponse implements
        ToCopyableBuilder<ListServersResponse.Builder, ListServersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListServersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedServer>> SERVERS_FIELD = SdkField
            .<List<ListedServer>> builder(MarshallingType.LIST)
            .getter(getter(ListServersResponse::servers))
            .setter(setter(Builder::servers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Servers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedServer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedServer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVERS_FIELD));

    private final String nextToken;

    private final List<ListedServer> servers;

    private ListServersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.servers = builder.servers;
    }

    /**
     * <p>
     * When you can get additional results from the <code>ListServers</code> operation, a <code>NextToken</code>
     * parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code> parameter
     * to continue listing additional servers.
     * </p>
     * 
     * @return When you can get additional results from the <code>ListServers</code> operation, a <code>NextToken</code>
     *         parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code>
     *         parameter to continue listing additional servers.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An array of servers that were listed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of servers that were listed.
     */
    public List<ListedServer> servers() {
        return servers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(servers());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServersResponse)) {
            return false;
        }
        ListServersResponse other = (ListServersResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(servers(), other.servers());
    }

    @Override
    public String toString() {
        return ToString.builder("ListServersResponse").add("NextToken", nextToken()).add("Servers", servers()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Servers":
            return Optional.ofNullable(clazz.cast(servers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServersResponse, T> g) {
        return obj -> g.apply((ListServersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServersResponse> {
        /**
         * <p>
         * When you can get additional results from the <code>ListServers</code> operation, a <code>NextToken</code>
         * parameter is returned in the output. In a following command, you can pass in the <code>NextToken</code>
         * parameter to continue listing additional servers.
         * </p>
         * 
         * @param nextToken
         *        When you can get additional results from the <code>ListServers</code> operation, a
         *        <code>NextToken</code> parameter is returned in the output. In a following command, you can pass in
         *        the <code>NextToken</code> parameter to continue listing additional servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of servers that were listed.
         * </p>
         * 
         * @param servers
         *        An array of servers that were listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(Collection<ListedServer> servers);

        /**
         * <p>
         * An array of servers that were listed.
         * </p>
         * 
         * @param servers
         *        An array of servers that were listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder servers(ListedServer... servers);

        /**
         * <p>
         * An array of servers that were listed.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ListedServer>.Builder} avoiding the need to
         * create one manually via {@link List<ListedServer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ListedServer>.Builder#build()} is called immediately and its
         * result is passed to {@link #servers(List<ListedServer>)}.
         * 
         * @param servers
         *        a consumer that will call methods on {@link List<ListedServer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #servers(List<ListedServer>)
         */
        Builder servers(Consumer<ListedServer.Builder>... servers);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedServer> servers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServersResponse model) {
            super(model);
            nextToken(model.nextToken);
            servers(model.servers);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ListedServer.Builder> getServers() {
            return servers != null ? servers.stream().map(ListedServer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder servers(Collection<ListedServer> servers) {
            this.servers = ListedServersCopier.copy(servers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(ListedServer... servers) {
            servers(Arrays.asList(servers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder servers(Consumer<ListedServer.Builder>... servers) {
            servers(Stream.of(servers).map(c -> ListedServer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServers(Collection<ListedServer.BuilderImpl> servers) {
            this.servers = ListedServersCopier.copyFromBuilder(servers);
        }

        @Override
        public ListServersResponse build() {
            return new ListServersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
