/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * <code>UpdateUserResponse</code> returns the user name and server identifier for the request to update a user's
 * properties.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserResponse extends TransferResponse implements
        ToCopyableBuilder<UpdateUserResponse.Builder, UpdateUserResponse> {
    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserResponse::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_ID_FIELD,
            USER_NAME_FIELD));

    private final String serverId;

    private final String userName;

    private UpdateUserResponse(BuilderImpl builder) {
        super(builder);
        this.serverId = builder.serverId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     * </p>
     * 
     * @return A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The unique identifier for a user that is assigned to the SFTP server instance that was specified in the request.
     * </p>
     * 
     * @return The unique identifier for a user that is assigned to the SFTP server instance that was specified in the
     *         request.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserResponse)) {
            return false;
        }
        UpdateUserResponse other = (UpdateUserResponse) obj;
        return Objects.equals(serverId(), other.serverId()) && Objects.equals(userName(), other.userName());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateUserResponse").add("ServerId", serverId()).add("UserName", userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserResponse, T> g) {
        return obj -> g.apply((UpdateUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserResponse> {
        /**
         * <p>
         * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The unique identifier for a user that is assigned to the SFTP server instance that was specified in the
         * request.
         * </p>
         * 
         * @param userName
         *        The unique identifier for a user that is assigned to the SFTP server instance that was specified in
         *        the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String serverId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserResponse model) {
            super(model);
            serverId(model.serverId);
            userName(model.userName);
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public UpdateUserResponse build() {
            return new UpdateUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
