/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The name of the step, used to identify the delete step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteStepDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DeleteStepDetails.Builder, DeleteStepDetails> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DeleteStepDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SOURCE_FILE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceFileLocation").getter(getter(DeleteStepDetails::sourceFileLocation))
            .setter(setter(Builder::sourceFileLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFileLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            SOURCE_FILE_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String sourceFileLocation;

    private DeleteStepDetails(BuilderImpl builder) {
        this.name = builder.name;
        this.sourceFileLocation = builder.sourceFileLocation;
    }

    /**
     * <p>
     * The name of the step, used as an identifier.
     * </p>
     * 
     * @return The name of the step, used as an identifier.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
     * originally uploaded file for the workflow.
     * </p>
     * <ul>
     * <li>
     * <p>
     * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step uses
     * the output file from the previous workflow step as input. This is the default value.
     * </p>
     * </li>
     * <li>
     * <p>
     * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies which file to use as input to the workflow step: either the output from the previous step, or
     *         the originally uploaded file for the workflow.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow
     *         step uses the output file from the previous workflow step as input. This is the default value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
     *         </p>
     *         </li>
     */
    public final String sourceFileLocation() {
        return sourceFileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteStepDetails)) {
            return false;
        }
        DeleteStepDetails other = (DeleteStepDetails) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(sourceFileLocation(), other.sourceFileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteStepDetails").add("Name", name()).add("SourceFileLocation", sourceFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SourceFileLocation":
            return Optional.ofNullable(clazz.cast(sourceFileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("SourceFileLocation", SOURCE_FILE_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteStepDetails, T> g) {
        return obj -> g.apply((DeleteStepDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeleteStepDetails> {
        /**
         * <p>
         * The name of the step, used as an identifier.
         * </p>
         * 
         * @param name
         *        The name of the step, used as an identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies which file to use as input to the workflow step: either the output from the previous step, or the
         * originally uploaded file for the workflow.
         * </p>
         * <ul>
         * <li>
         * <p>
         * To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this workflow step
         * uses the output file from the previous workflow step as input. This is the default value.
         * </p>
         * </li>
         * <li>
         * <p>
         * To use the originally uploaded file location as input for this step, enter <code>${original.file}</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param sourceFileLocation
         *        Specifies which file to use as input to the workflow step: either the output from the previous step,
         *        or the originally uploaded file for the workflow.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        To use the previous file as the input, enter <code>${previous.file}</code>. In this case, this
         *        workflow step uses the output file from the previous workflow step as input. This is the default
         *        value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        To use the originally uploaded file location as input for this step, enter
         *        <code>${original.file}</code>.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFileLocation(String sourceFileLocation);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String sourceFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteStepDetails model) {
            name(model.name);
            sourceFileLocation(model.sourceFileLocation);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSourceFileLocation() {
            return sourceFileLocation;
        }

        public final void setSourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
        }

        @Override
        public final Builder sourceFileLocation(String sourceFileLocation) {
            this.sourceFileLocation = sourceFileLocation;
            return this;
        }

        @Override
        public DeleteStepDetails build() {
            return new DeleteStepDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
