/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeConnectorResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeConnectorResponse.Builder, DescribeConnectorResponse> {
    private static final SdkField<DescribedConnector> CONNECTOR_FIELD = SdkField
            .<DescribedConnector> builder(MarshallingType.SDK_POJO).memberName("Connector")
            .getter(getter(DescribeConnectorResponse::connector)).setter(setter(Builder::connector))
            .constructor(DescribedConnector::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connector").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribedConnector connector;

    private DescribeConnectorResponse(BuilderImpl builder) {
        super(builder);
        this.connector = builder.connector;
    }

    /**
     * <p>
     * The structure that contains the details of the connector.
     * </p>
     * 
     * @return The structure that contains the details of the connector.
     */
    public final DescribedConnector connector() {
        return connector;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connector());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConnectorResponse)) {
            return false;
        }
        DescribeConnectorResponse other = (DescribeConnectorResponse) obj;
        return Objects.equals(connector(), other.connector());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeConnectorResponse").add("Connector", connector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Connector":
            return Optional.ofNullable(clazz.cast(connector()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Connector", CONNECTOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeConnectorResponse, T> g) {
        return obj -> g.apply((DescribeConnectorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeConnectorResponse> {
        /**
         * <p>
         * The structure that contains the details of the connector.
         * </p>
         * 
         * @param connector
         *        The structure that contains the details of the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connector(DescribedConnector connector);

        /**
         * <p>
         * The structure that contains the details of the connector.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedConnector.Builder} avoiding the
         * need to create one manually via {@link DescribedConnector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedConnector.Builder#build()} is called immediately and its
         * result is passed to {@link #connector(DescribedConnector)}.
         * 
         * @param connector
         *        a consumer that will call methods on {@link DescribedConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connector(DescribedConnector)
         */
        default Builder connector(Consumer<DescribedConnector.Builder> connector) {
            return connector(DescribedConnector.builder().applyMutation(connector).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedConnector connector;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConnectorResponse model) {
            super(model);
            connector(model.connector);
        }

        public final DescribedConnector.Builder getConnector() {
            return connector != null ? connector.toBuilder() : null;
        }

        public final void setConnector(DescribedConnector.BuilderImpl connector) {
            this.connector = connector != null ? connector.build() : null;
        }

        @Override
        public final Builder connector(DescribedConnector connector) {
            this.connector = connector;
            return this;
        }

        @Override
        public DescribeConnectorResponse build() {
            return new DescribeConnectorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
