/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeWebAppCustomizationResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeWebAppCustomizationResponse.Builder, DescribeWebAppCustomizationResponse> {
    private static final SdkField<DescribedWebAppCustomization> WEB_APP_CUSTOMIZATION_FIELD = SdkField
            .<DescribedWebAppCustomization> builder(MarshallingType.SDK_POJO).memberName("WebAppCustomization")
            .getter(getter(DescribeWebAppCustomizationResponse::webAppCustomization))
            .setter(setter(Builder::webAppCustomization)).constructor(DescribedWebAppCustomization::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppCustomization").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_CUSTOMIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribedWebAppCustomization webAppCustomization;

    private DescribeWebAppCustomizationResponse(BuilderImpl builder) {
        super(builder);
        this.webAppCustomization = builder.webAppCustomization;
    }

    /**
     * <p>
     * Returns a structure that contains the details of the web app customizations.
     * </p>
     * 
     * @return Returns a structure that contains the details of the web app customizations.
     */
    public final DescribedWebAppCustomization webAppCustomization() {
        return webAppCustomization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webAppCustomization());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeWebAppCustomizationResponse)) {
            return false;
        }
        DescribeWebAppCustomizationResponse other = (DescribeWebAppCustomizationResponse) obj;
        return Objects.equals(webAppCustomization(), other.webAppCustomization());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeWebAppCustomizationResponse").add("WebAppCustomization", webAppCustomization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAppCustomization":
            return Optional.ofNullable(clazz.cast(webAppCustomization()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebAppCustomization", WEB_APP_CUSTOMIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeWebAppCustomizationResponse, T> g) {
        return obj -> g.apply((DescribeWebAppCustomizationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeWebAppCustomizationResponse> {
        /**
         * <p>
         * Returns a structure that contains the details of the web app customizations.
         * </p>
         * 
         * @param webAppCustomization
         *        Returns a structure that contains the details of the web app customizations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppCustomization(DescribedWebAppCustomization webAppCustomization);

        /**
         * <p>
         * Returns a structure that contains the details of the web app customizations.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedWebAppCustomization.Builder}
         * avoiding the need to create one manually via {@link DescribedWebAppCustomization#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedWebAppCustomization.Builder#build()} is called
         * immediately and its result is passed to {@link #webAppCustomization(DescribedWebAppCustomization)}.
         * 
         * @param webAppCustomization
         *        a consumer that will call methods on {@link DescribedWebAppCustomization.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAppCustomization(DescribedWebAppCustomization)
         */
        default Builder webAppCustomization(Consumer<DescribedWebAppCustomization.Builder> webAppCustomization) {
            return webAppCustomization(DescribedWebAppCustomization.builder().applyMutation(webAppCustomization).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedWebAppCustomization webAppCustomization;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeWebAppCustomizationResponse model) {
            super(model);
            webAppCustomization(model.webAppCustomization);
        }

        public final DescribedWebAppCustomization.Builder getWebAppCustomization() {
            return webAppCustomization != null ? webAppCustomization.toBuilder() : null;
        }

        public final void setWebAppCustomization(DescribedWebAppCustomization.BuilderImpl webAppCustomization) {
            this.webAppCustomization = webAppCustomization != null ? webAppCustomization.build() : null;
        }

        @Override
        public final Builder webAppCustomization(DescribedWebAppCustomization webAppCustomization) {
            this.webAppCustomization = webAppCustomization;
            return this;
        }

        @Override
        public DescribeWebAppCustomizationResponse build() {
            return new DescribeWebAppCustomizationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
