/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an object that contains entries and targets for <code>HomeDirectoryMappings</code>.
 * </p>
 * <p>
 * The following is an <code>Entry</code> and <code>Target</code> pair example for <code>chroot</code>.
 * </p>
 * <p>
 * <code>[ { "Entry": "/", "Target": "/bucket_name/home/mydirectory" } ]</code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class HomeDirectoryMapEntry implements SdkPojo, Serializable,
        ToCopyableBuilder<HomeDirectoryMapEntry.Builder, HomeDirectoryMapEntry> {
    private static final SdkField<String> ENTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Entry")
            .getter(getter(HomeDirectoryMapEntry::entry)).setter(setter(Builder::entry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entry").build()).build();

    private static final SdkField<String> TARGET_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Target")
            .getter(getter(HomeDirectoryMapEntry::target)).setter(setter(Builder::target))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(HomeDirectoryMapEntry::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTRY_FIELD, TARGET_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String entry;

    private final String target;

    private final String type;

    private HomeDirectoryMapEntry(BuilderImpl builder) {
        this.entry = builder.entry;
        this.target = builder.target;
        this.type = builder.type;
    }

    /**
     * <p>
     * Represents an entry for <code>HomeDirectoryMappings</code>.
     * </p>
     * 
     * @return Represents an entry for <code>HomeDirectoryMappings</code>.
     */
    public final String entry() {
        return entry;
    }

    /**
     * <p>
     * Represents the map target that is used in a <code>HomeDirectoryMapEntry</code>.
     * </p>
     * 
     * @return Represents the map target that is used in a <code>HomeDirectoryMapEntry</code>.
     */
    public final String target() {
        return target;
    }

    /**
     * <p>
     * Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a file, or
     * <code>DIRECTORY</code> for the directory to point to a directory.
     * </p>
     * <note>
     * <p>
     * By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a Transfer
     * Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you want a mapping to
     * have a file target.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MapType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a
     *         file, or <code>DIRECTORY</code> for the directory to point to a directory.</p> <note>
     *         <p>
     *         By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a
     *         Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you
     *         want a mapping to have a file target.
     *         </p>
     * @see MapType
     */
    public final MapType type() {
        return MapType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a file, or
     * <code>DIRECTORY</code> for the directory to point to a directory.
     * </p>
     * <note>
     * <p>
     * By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a Transfer
     * Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you want a mapping to
     * have a file target.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MapType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a
     *         file, or <code>DIRECTORY</code> for the directory to point to a directory.</p> <note>
     *         <p>
     *         By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a
     *         Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you
     *         want a mapping to have a file target.
     *         </p>
     * @see MapType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(entry());
        hashCode = 31 * hashCode + Objects.hashCode(target());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HomeDirectoryMapEntry)) {
            return false;
        }
        HomeDirectoryMapEntry other = (HomeDirectoryMapEntry) obj;
        return Objects.equals(entry(), other.entry()) && Objects.equals(target(), other.target())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("HomeDirectoryMapEntry").add("Entry", entry()).add("Target", target())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Entry":
            return Optional.ofNullable(clazz.cast(entry()));
        case "Target":
            return Optional.ofNullable(clazz.cast(target()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Entry", ENTRY_FIELD);
        map.put("Target", TARGET_FIELD);
        map.put("Type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HomeDirectoryMapEntry, T> g) {
        return obj -> g.apply((HomeDirectoryMapEntry) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, HomeDirectoryMapEntry> {
        /**
         * <p>
         * Represents an entry for <code>HomeDirectoryMappings</code>.
         * </p>
         * 
         * @param entry
         *        Represents an entry for <code>HomeDirectoryMappings</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entry(String entry);

        /**
         * <p>
         * Represents the map target that is used in a <code>HomeDirectoryMapEntry</code>.
         * </p>
         * 
         * @param target
         *        Represents the map target that is used in a <code>HomeDirectoryMapEntry</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder target(String target);

        /**
         * <p>
         * Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a file,
         * or <code>DIRECTORY</code> for the directory to point to a directory.
         * </p>
         * <note>
         * <p>
         * By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a
         * Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you want a
         * mapping to have a file target.
         * </p>
         * </note>
         * 
         * @param type
         *        Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a
         *        file, or <code>DIRECTORY</code> for the directory to point to a directory.</p> <note>
         *        <p>
         *        By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create
         *        a Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if
         *        you want a mapping to have a file target.
         *        </p>
         * @see MapType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a file,
         * or <code>DIRECTORY</code> for the directory to point to a directory.
         * </p>
         * <note>
         * <p>
         * By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create a
         * Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if you want a
         * mapping to have a file target.
         * </p>
         * </note>
         * 
         * @param type
         *        Specifies the type of mapping. Set the type to <code>FILE</code> if you want the mapping to point to a
         *        file, or <code>DIRECTORY</code> for the directory to point to a directory.</p> <note>
         *        <p>
         *        By default, home directory mappings have a <code>Type</code> of <code>DIRECTORY</code> when you create
         *        a Transfer Family server. You would need to explicitly set <code>Type</code> to <code>FILE</code> if
         *        you want a mapping to have a file target.
         *        </p>
         * @see MapType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MapType
         */
        Builder type(MapType type);
    }

    static final class BuilderImpl implements Builder {
        private String entry;

        private String target;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(HomeDirectoryMapEntry model) {
            entry(model.entry);
            target(model.target);
            type(model.type);
        }

        public final String getEntry() {
            return entry;
        }

        public final void setEntry(String entry) {
            this.entry = entry;
        }

        @Override
        public final Builder entry(String entry) {
            this.entry = entry;
            return this;
        }

        public final String getTarget() {
            return target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MapType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public HomeDirectoryMapEntry build() {
            return new HomeDirectoryMapEntry(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
