/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWebAppsResponse extends TransferResponse implements
        ToCopyableBuilder<ListWebAppsResponse.Builder, ListWebAppsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListWebAppsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedWebApp>> WEB_APPS_FIELD = SdkField
            .<List<ListedWebApp>> builder(MarshallingType.LIST)
            .memberName("WebApps")
            .getter(getter(ListWebAppsResponse::webApps))
            .setter(setter(Builder::webApps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebApps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedWebApp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedWebApp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            WEB_APPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListedWebApp> webApps;

    private ListWebAppsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.webApps = builder.webApps;
    }

    /**
     * <p>
     * Provide this value for the <code>NextToken</code> parameter in a subsequent command to continue listing
     * additional web apps.
     * </p>
     * 
     * @return Provide this value for the <code>NextToken</code> parameter in a subsequent command to continue listing
     *         additional web apps.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the WebApps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWebApps() {
        return webApps != null && !(webApps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns, for each listed web app, a structure that contains details for the web app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWebApps} method.
     * </p>
     * 
     * @return Returns, for each listed web app, a structure that contains details for the web app.
     */
    public final List<ListedWebApp> webApps() {
        return webApps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasWebApps() ? webApps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWebAppsResponse)) {
            return false;
        }
        ListWebAppsResponse other = (ListWebAppsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasWebApps() == other.hasWebApps()
                && Objects.equals(webApps(), other.webApps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWebAppsResponse").add("NextToken", nextToken())
                .add("WebApps", hasWebApps() ? webApps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "WebApps":
            return Optional.ofNullable(clazz.cast(webApps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("WebApps", WEB_APPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWebAppsResponse, T> g) {
        return obj -> g.apply((ListWebAppsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListWebAppsResponse> {
        /**
         * <p>
         * Provide this value for the <code>NextToken</code> parameter in a subsequent command to continue listing
         * additional web apps.
         * </p>
         * 
         * @param nextToken
         *        Provide this value for the <code>NextToken</code> parameter in a subsequent command to continue
         *        listing additional web apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns, for each listed web app, a structure that contains details for the web app.
         * </p>
         * 
         * @param webApps
         *        Returns, for each listed web app, a structure that contains details for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webApps(Collection<ListedWebApp> webApps);

        /**
         * <p>
         * Returns, for each listed web app, a structure that contains details for the web app.
         * </p>
         * 
         * @param webApps
         *        Returns, for each listed web app, a structure that contains details for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webApps(ListedWebApp... webApps);

        /**
         * <p>
         * Returns, for each listed web app, a structure that contains details for the web app.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedWebApp.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.ListedWebApp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedWebApp.Builder#build()} is called immediately and
         * its result is passed to {@link #webApps(List<ListedWebApp>)}.
         * 
         * @param webApps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedWebApp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webApps(java.util.Collection<ListedWebApp>)
         */
        Builder webApps(Consumer<ListedWebApp.Builder>... webApps);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedWebApp> webApps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListWebAppsResponse model) {
            super(model);
            nextToken(model.nextToken);
            webApps(model.webApps);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedWebApp.Builder> getWebApps() {
            List<ListedWebApp.Builder> result = ListedWebAppsCopier.copyToBuilder(this.webApps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWebApps(Collection<ListedWebApp.BuilderImpl> webApps) {
            this.webApps = ListedWebAppsCopier.copyFromBuilder(webApps);
        }

        @Override
        public final Builder webApps(Collection<ListedWebApp> webApps) {
            this.webApps = ListedWebAppsCopier.copy(webApps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webApps(ListedWebApp... webApps) {
            webApps(Arrays.asList(webApps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder webApps(Consumer<ListedWebApp.Builder>... webApps) {
            webApps(Stream.of(webApps).map(c -> ListedWebApp.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListWebAppsResponse build() {
            return new ListWebAppsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
