/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Consists of the logging role and the log group name.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<LoggingConfiguration.Builder, LoggingConfiguration> {
    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingRole").getter(getter(LoggingConfiguration::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupName").getter(getter(LoggingConfiguration::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGGING_ROLE_FIELD,
            LOG_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String loggingRole;

    private final String logGroupName;

    private LoggingConfiguration(BuilderImpl builder) {
        this.loggingRole = builder.loggingRole;
        this.logGroupName = builder.logGroupName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn on
     * Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your
     * CloudWatch logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to
     *         turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity
     *         in your CloudWatch logs.
     */
    public final String loggingRole() {
        return loggingRole;
    }

    /**
     * <p>
     * The name of the CloudWatch logging group for the Transfer Family server to which this workflow belongs.
     * </p>
     * 
     * @return The name of the CloudWatch logging group for the Transfer Family server to which this workflow belongs.
     */
    public final String logGroupName() {
        return logGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfiguration)) {
            return false;
        }
        LoggingConfiguration other = (LoggingConfiguration) obj;
        return Objects.equals(loggingRole(), other.loggingRole()) && Objects.equals(logGroupName(), other.logGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfiguration").add("LoggingRole", loggingRole()).add("LogGroupName", logGroupName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LoggingRole", LOGGING_ROLE_FIELD);
        map.put("LogGroupName", LOG_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfiguration, T> g) {
        return obj -> g.apply((LoggingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server to turn
         * on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user activity in your
         * CloudWatch logs.
         * </p>
         * 
         * @param loggingRole
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a server
         *        to turn on Amazon CloudWatch logging for Amazon S3 or Amazon EFSevents. When set, you can view user
         *        activity in your CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * The name of the CloudWatch logging group for the Transfer Family server to which this workflow belongs.
         * </p>
         * 
         * @param logGroupName
         *        The name of the CloudWatch logging group for the Transfer Family server to which this workflow
         *        belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String loggingRole;

        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfiguration model) {
            loggingRole(model.loggingRole);
            logGroupName(model.logGroupName);
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        @Override
        public LoggingConfiguration build() {
            return new LoggingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
