/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the public Secure Shell (SSH) key that is associated with a Transfer Family user for the
 * specific file transfer protocol-enabled server (as identified by <code>ServerId</code>). The information returned
 * includes the date the key was imported, the public key contents, and the public key ID. A user can store more than
 * one SSH public key associated with their user name on a specific server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SshPublicKey implements SdkPojo, Serializable, ToCopyableBuilder<SshPublicKey.Builder, SshPublicKey> {
    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DateImported").getter(getter(SshPublicKey::dateImported)).setter(setter(Builder::dateImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshPublicKeyBody").getter(getter(SshPublicKey::sshPublicKeyBody))
            .setter(setter(Builder::sshPublicKeyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyBody").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshPublicKeyId").getter(getter(SshPublicKey::sshPublicKeyId)).setter(setter(Builder::sshPublicKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_IMPORTED_FIELD,
            SSH_PUBLIC_KEY_BODY_FIELD, SSH_PUBLIC_KEY_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant dateImported;

    private final String sshPublicKeyBody;

    private final String sshPublicKeyId;

    private SshPublicKey(BuilderImpl builder) {
        this.dateImported = builder.dateImported;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.sshPublicKeyId = builder.sshPublicKeyId;
    }

    /**
     * <p>
     * Specifies the date that the public key was added to the Transfer Family user.
     * </p>
     * 
     * @return Specifies the date that the public key was added to the Transfer Family user.
     */
    public final Instant dateImported() {
        return dateImported;
    }

    /**
     * <p>
     * Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.
     * </p>
     * <p>
     * Transfer Family accepts RSA, ECDSA, and ED25519 keys.
     * </p>
     * 
     * @return Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
     *         <p>
     *         Transfer Family accepts RSA, ECDSA, and ED25519 keys.
     */
    public final String sshPublicKeyBody() {
        return sshPublicKeyBody;
    }

    /**
     * <p>
     * Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
     * </p>
     * 
     * @return Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
     */
    public final String sshPublicKeyId() {
        return sshPublicKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateImported());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyBody());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SshPublicKey)) {
            return false;
        }
        SshPublicKey other = (SshPublicKey) obj;
        return Objects.equals(dateImported(), other.dateImported())
                && Objects.equals(sshPublicKeyBody(), other.sshPublicKeyBody())
                && Objects.equals(sshPublicKeyId(), other.sshPublicKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SshPublicKey").add("DateImported", dateImported()).add("SshPublicKeyBody", sshPublicKeyBody())
                .add("SshPublicKeyId", sshPublicKeyId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateImported":
            return Optional.ofNullable(clazz.cast(dateImported()));
        case "SshPublicKeyBody":
            return Optional.ofNullable(clazz.cast(sshPublicKeyBody()));
        case "SshPublicKeyId":
            return Optional.ofNullable(clazz.cast(sshPublicKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DateImported", DATE_IMPORTED_FIELD);
        map.put("SshPublicKeyBody", SSH_PUBLIC_KEY_BODY_FIELD);
        map.put("SshPublicKeyId", SSH_PUBLIC_KEY_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SshPublicKey, T> g) {
        return obj -> g.apply((SshPublicKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SshPublicKey> {
        /**
         * <p>
         * Specifies the date that the public key was added to the Transfer Family user.
         * </p>
         * 
         * @param dateImported
         *        Specifies the date that the public key was added to the Transfer Family user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateImported(Instant dateImported);

        /**
         * <p>
         * Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.
         * </p>
         * <p>
         * Transfer Family accepts RSA, ECDSA, and ED25519 keys.
         * </p>
         * 
         * @param sshPublicKeyBody
         *        Specifies the content of the SSH public key as specified by the <code>PublicKeyId</code>.</p>
         *        <p>
         *        Transfer Family accepts RSA, ECDSA, and ED25519 keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyBody(String sshPublicKeyBody);

        /**
         * <p>
         * Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
         * </p>
         * 
         * @param sshPublicKeyId
         *        Specifies the <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyId(String sshPublicKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Instant dateImported;

        private String sshPublicKeyBody;

        private String sshPublicKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SshPublicKey model) {
            dateImported(model.dateImported);
            sshPublicKeyBody(model.sshPublicKeyBody);
            sshPublicKeyId(model.sshPublicKeyId);
        }

        public final Instant getDateImported() {
            return dateImported;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        public final String getSshPublicKeyBody() {
            return sshPublicKeyBody;
        }

        public final void setSshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final String getSshPublicKeyId() {
            return sshPublicKeyId;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        @Override
        public SshPublicKey build() {
            return new SshPublicKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
