/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeExecutionResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeExecutionResponse.Builder, DescribeExecutionResponse> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(DescribeExecutionResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<DescribedExecution> EXECUTION_FIELD = SdkField
            .<DescribedExecution> builder(MarshallingType.SDK_POJO).memberName("Execution")
            .getter(getter(DescribeExecutionResponse::execution)).setter(setter(Builder::execution))
            .constructor(DescribedExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Execution").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            EXECUTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final DescribedExecution execution;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.execution = builder.execution;
    }

    /**
     * <p>
     * A unique identifier for the workflow.
     * </p>
     * 
     * @return A unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The structure that contains the details of the workflow' execution.
     * </p>
     * 
     * @return The structure that contains the details of the workflow' execution.
     */
    public final DescribedExecution execution() {
        return execution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(execution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(execution(), other.execution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeExecutionResponse").add("WorkflowId", workflowId()).add("Execution", execution())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "Execution":
            return Optional.ofNullable(clazz.cast(execution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkflowId", WORKFLOW_ID_FIELD);
        map.put("Execution", EXECUTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeExecutionResponse> {
        /**
         * <p>
         * A unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        A unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The structure that contains the details of the workflow' execution.
         * </p>
         * 
         * @param execution
         *        The structure that contains the details of the workflow' execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder execution(DescribedExecution execution);

        /**
         * <p>
         * The structure that contains the details of the workflow' execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedExecution.Builder} avoiding the
         * need to create one manually via {@link DescribedExecution#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedExecution.Builder#build()} is called immediately and its
         * result is passed to {@link #execution(DescribedExecution)}.
         * 
         * @param execution
         *        a consumer that will call methods on {@link DescribedExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #execution(DescribedExecution)
         */
        default Builder execution(Consumer<DescribedExecution.Builder> execution) {
            return execution(DescribedExecution.builder().applyMutation(execution).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String workflowId;

        private DescribedExecution execution;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            workflowId(model.workflowId);
            execution(model.execution);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final DescribedExecution.Builder getExecution() {
            return execution != null ? execution.toBuilder() : null;
        }

        public final void setExecution(DescribedExecution.BuilderImpl execution) {
            this.execution = execution != null ? execution.build() : null;
        }

        @Override
        public final Builder execution(DescribedExecution execution) {
            this.execution = execution;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
