/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHostKeysResponse extends TransferResponse implements
        ToCopyableBuilder<ListHostKeysResponse.Builder, ListHostKeysResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHostKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServerId").getter(getter(ListHostKeysResponse::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<List<ListedHostKey>> HOST_KEYS_FIELD = SdkField
            .<List<ListedHostKey>> builder(MarshallingType.LIST)
            .memberName("HostKeys")
            .getter(getter(ListHostKeysResponse::hostKeys))
            .setter(setter(Builder::hostKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedHostKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedHostKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVER_ID_FIELD, HOST_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final String serverId;

    private final List<ListedHostKey> hostKeys;

    private ListHostKeysResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.serverId = builder.serverId;
        this.hostKeys = builder.hostKeys;
    }

    /**
     * <p>
     * Returns a token that you can use to call <code>ListHostKeys</code> again and receive additional results, if there
     * are any.
     * </p>
     * 
     * @return Returns a token that you can use to call <code>ListHostKeys</code> again and receive additional results,
     *         if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Returns the server identifier that contains the listed host keys.
     * </p>
     * 
     * @return Returns the server identifier that contains the listed host keys.
     */
    public final String serverId() {
        return serverId;
    }

    /**
     * For responses, this returns true if the service returned a value for the HostKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasHostKeys() {
        return hostKeys != null && !(hostKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array, where each item contains the details of a host key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHostKeys} method.
     * </p>
     * 
     * @return Returns an array, where each item contains the details of a host key.
     */
    public final List<ListedHostKey> hostKeys() {
        return hostKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(hasHostKeys() ? hostKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHostKeysResponse)) {
            return false;
        }
        ListHostKeysResponse other = (ListHostKeysResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(serverId(), other.serverId())
                && hasHostKeys() == other.hasHostKeys() && Objects.equals(hostKeys(), other.hostKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListHostKeysResponse").add("NextToken", nextToken()).add("ServerId", serverId())
                .add("HostKeys", hasHostKeys() ? hostKeys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "HostKeys":
            return Optional.ofNullable(clazz.cast(hostKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ServerId", SERVER_ID_FIELD);
        map.put("HostKeys", HOST_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListHostKeysResponse, T> g) {
        return obj -> g.apply((ListHostKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListHostKeysResponse> {
        /**
         * <p>
         * Returns a token that you can use to call <code>ListHostKeys</code> again and receive additional results, if
         * there are any.
         * </p>
         * 
         * @param nextToken
         *        Returns a token that you can use to call <code>ListHostKeys</code> again and receive additional
         *        results, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns the server identifier that contains the listed host keys.
         * </p>
         * 
         * @param serverId
         *        Returns the server identifier that contains the listed host keys.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * Returns an array, where each item contains the details of a host key.
         * </p>
         * 
         * @param hostKeys
         *        Returns an array, where each item contains the details of a host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeys(Collection<ListedHostKey> hostKeys);

        /**
         * <p>
         * Returns an array, where each item contains the details of a host key.
         * </p>
         * 
         * @param hostKeys
         *        Returns an array, where each item contains the details of a host key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKeys(ListedHostKey... hostKeys);

        /**
         * <p>
         * Returns an array, where each item contains the details of a host key.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedHostKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.transfer.model.ListedHostKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedHostKey.Builder#build()} is called immediately
         * and its result is passed to {@link #hostKeys(List<ListedHostKey>)}.
         * 
         * @param hostKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedHostKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostKeys(java.util.Collection<ListedHostKey>)
         */
        Builder hostKeys(Consumer<ListedHostKey.Builder>... hostKeys);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private String serverId;

        private List<ListedHostKey> hostKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListHostKeysResponse model) {
            super(model);
            nextToken(model.nextToken);
            serverId(model.serverId);
            hostKeys(model.hostKeys);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getServerId() {
            return serverId;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final List<ListedHostKey.Builder> getHostKeys() {
            List<ListedHostKey.Builder> result = ListedHostKeysCopier.copyToBuilder(this.hostKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHostKeys(Collection<ListedHostKey.BuilderImpl> hostKeys) {
            this.hostKeys = ListedHostKeysCopier.copyFromBuilder(hostKeys);
        }

        @Override
        public final Builder hostKeys(Collection<ListedHostKey> hostKeys) {
            this.hostKeys = ListedHostKeysCopier.copy(hostKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(ListedHostKey... hostKeys) {
            hostKeys(Arrays.asList(hostKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hostKeys(Consumer<ListedHostKey.Builder>... hostKeys) {
            hostKeys(Stream.of(hostKeys).map(c -> ListedHostKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListHostKeysResponse build() {
            return new ListHostKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
