/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateConnectorRequest extends TransferRequest implements
        ToCopyableBuilder<CreateConnectorRequest.Builder, CreateConnectorRequest> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(CreateConnectorRequest::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<As2ConnectorConfig> AS2_CONFIG_FIELD = SdkField
            .<As2ConnectorConfig> builder(MarshallingType.SDK_POJO).memberName("As2Config")
            .getter(getter(CreateConnectorRequest::as2Config)).setter(setter(Builder::as2Config))
            .constructor(As2ConnectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("As2Config").build()).build();

    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessRole").getter(getter(CreateConnectorRequest::accessRole)).setter(setter(Builder::accessRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessRole").build()).build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LoggingRole").getter(getter(CreateConnectorRequest::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateConnectorRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SftpConnectorConfig> SFTP_CONFIG_FIELD = SdkField
            .<SftpConnectorConfig> builder(MarshallingType.SDK_POJO).memberName("SftpConfig")
            .getter(getter(CreateConnectorRequest::sftpConfig)).setter(setter(Builder::sftpConfig))
            .constructor(SftpConnectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SftpConfig").build()).build();

    private static final SdkField<String> SECURITY_POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityPolicyName").getter(getter(CreateConnectorRequest::securityPolicyName))
            .setter(setter(Builder::securityPolicyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, AS2_CONFIG_FIELD,
            ACCESS_ROLE_FIELD, LOGGING_ROLE_FIELD, TAGS_FIELD, SFTP_CONFIG_FIELD, SECURITY_POLICY_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String url;

    private final As2ConnectorConfig as2Config;

    private final String accessRole;

    private final String loggingRole;

    private final List<Tag> tags;

    private final SftpConnectorConfig sftpConfig;

    private final String securityPolicyName;

    private CreateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.as2Config = builder.as2Config;
        this.accessRole = builder.accessRole;
        this.loggingRole = builder.loggingRole;
        this.tags = builder.tags;
        this.sftpConfig = builder.sftpConfig;
        this.securityPolicyName = builder.securityPolicyName;
    }

    /**
     * <p>
     * The URL of the partner's AS2 or SFTP endpoint.
     * </p>
     * 
     * @return The URL of the partner's AS2 or SFTP endpoint.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * A structure that contains the parameters for an AS2 connector object.
     * </p>
     * 
     * @return A structure that contains the parameters for an AS2 connector object.
     */
    public final As2ConnectorConfig as2Config() {
        return as2Config;
    }

    /**
     * <p>
     * Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the Amazon
     * Resource Name (ARN) of the Identity and Access Management role to use.
     * </p>
     * <p>
     * <b>For AS2 connectors</b>
     * </p>
     * <p>
     * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
     * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and write a
     * final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code> needs to
     * provide read and write access to the parent directory of the file location used in the
     * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
     * directory of the files that you intend to send with <code>StartFileTransfer</code>.
     * </p>
     * <p>
     * If you are using Basic authentication for your AS2 connector, the access role requires the
     * <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
     * customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role also needs
     * the <code>kms:Decrypt</code> permission for that key.
     * </p>
     * <p>
     * <b>For SFTP connectors</b>
     * </p>
     * <p>
     * Make sure that the access role provides read and write access to the parent directory of the file location that's
     * used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides
     * <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
     * </p>
     * 
     * @return Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the
     *         Amazon Resource Name (ARN) of the Identity and Access Management role to use.</p>
     *         <p>
     *         <b>For AS2 connectors</b>
     *         </p>
     *         <p>
     *         With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in
     *         the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
     *         <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
     *         temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
     *         write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
     *         needs to provide read and write access to the parent directory of the file location used in the
     *         <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the
     *         parent directory of the files that you intend to send with <code>StartFileTransfer</code>.
     *         </p>
     *         <p>
     *         If you are using Basic authentication for your AS2 connector, the access role requires the
     *         <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
     *         customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role
     *         also needs the <code>kms:Decrypt</code> permission for that key.
     *         </p>
     *         <p>
     *         <b>For SFTP connectors</b>
     *         </p>
     *         <p>
     *         Make sure that the access role provides read and write access to the parent directory of the file
     *         location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role
     *         provides <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
     */
    public final String accessRole() {
        return accessRole;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to turn
     * on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch logs.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector
     *         to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your
     *         CloudWatch logs.
     */
    public final String loggingRole() {
        return loggingRole;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors for
     * any purpose.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to
     *         connectors for any purpose.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A structure that contains the parameters for an SFTP connector object.
     * </p>
     * 
     * @return A structure that contains the parameters for an SFTP connector object.
     */
    public final SftpConnectorConfig sftpConfig() {
        return sftpConfig;
    }

    /**
     * <p>
     * Specifies the name of the security policy for the connector.
     * </p>
     * 
     * @return Specifies the name of the security policy for the connector.
     */
    public final String securityPolicyName() {
        return securityPolicyName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(as2Config());
        hashCode = 31 * hashCode + Objects.hashCode(accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sftpConfig());
        hashCode = 31 * hashCode + Objects.hashCode(securityPolicyName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateConnectorRequest)) {
            return false;
        }
        CreateConnectorRequest other = (CreateConnectorRequest) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(as2Config(), other.as2Config())
                && Objects.equals(accessRole(), other.accessRole()) && Objects.equals(loggingRole(), other.loggingRole())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(sftpConfig(), other.sftpConfig())
                && Objects.equals(securityPolicyName(), other.securityPolicyName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateConnectorRequest").add("Url", url()).add("As2Config", as2Config())
                .add("AccessRole", accessRole()).add("LoggingRole", loggingRole()).add("Tags", hasTags() ? tags() : null)
                .add("SftpConfig", sftpConfig()).add("SecurityPolicyName", securityPolicyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "As2Config":
            return Optional.ofNullable(clazz.cast(as2Config()));
        case "AccessRole":
            return Optional.ofNullable(clazz.cast(accessRole()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "SftpConfig":
            return Optional.ofNullable(clazz.cast(sftpConfig()));
        case "SecurityPolicyName":
            return Optional.ofNullable(clazz.cast(securityPolicyName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Url", URL_FIELD);
        map.put("As2Config", AS2_CONFIG_FIELD);
        map.put("AccessRole", ACCESS_ROLE_FIELD);
        map.put("LoggingRole", LOGGING_ROLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SftpConfig", SFTP_CONFIG_FIELD);
        map.put("SecurityPolicyName", SECURITY_POLICY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateConnectorRequest, T> g) {
        return obj -> g.apply((CreateConnectorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateConnectorRequest> {
        /**
         * <p>
         * The URL of the partner's AS2 or SFTP endpoint.
         * </p>
         * 
         * @param url
         *        The URL of the partner's AS2 or SFTP endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * A structure that contains the parameters for an AS2 connector object.
         * </p>
         * 
         * @param as2Config
         *        A structure that contains the parameters for an AS2 connector object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder as2Config(As2ConnectorConfig as2Config);

        /**
         * <p>
         * A structure that contains the parameters for an AS2 connector object.
         * </p>
         * This is a convenience method that creates an instance of the {@link As2ConnectorConfig.Builder} avoiding the
         * need to create one manually via {@link As2ConnectorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link As2ConnectorConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #as2Config(As2ConnectorConfig)}.
         * 
         * @param as2Config
         *        a consumer that will call methods on {@link As2ConnectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #as2Config(As2ConnectorConfig)
         */
        default Builder as2Config(Consumer<As2ConnectorConfig.Builder> as2Config) {
            return as2Config(As2ConnectorConfig.builder().applyMutation(as2Config).build());
        }

        /**
         * <p>
         * Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide the
         * Amazon Resource Name (ARN) of the Identity and Access Management role to use.
         * </p>
         * <p>
         * <b>For AS2 connectors</b>
         * </p>
         * <p>
         * With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths in the
         * request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example, for
         * <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>) to
         * temporarily store a processed AS2 message file, store the MDN when we receive them from the partner, and
         * write a final JSON file containing relevant metadata of the transmission. So, the <code>AccessRole</code>
         * needs to provide read and write access to the parent directory of the file location used in the
         * <code>StartFileTransfer</code> request. Additionally, you need to provide read and write access to the parent
         * directory of the files that you intend to send with <code>StartFileTransfer</code>.
         * </p>
         * <p>
         * If you are using Basic authentication for your AS2 connector, the access role requires the
         * <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using a
         * customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the role also
         * needs the <code>kms:Decrypt</code> permission for that key.
         * </p>
         * <p>
         * <b>For SFTP connectors</b>
         * </p>
         * <p>
         * Make sure that the access role provides read and write access to the parent directory of the file location
         * that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the role provides
         * <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
         * </p>
         * 
         * @param accessRole
         *        Connectors are used to send files using either the AS2 or SFTP protocol. For the access role, provide
         *        the Amazon Resource Name (ARN) of the Identity and Access Management role to use.</p>
         *        <p>
         *        <b>For AS2 connectors</b>
         *        </p>
         *        <p>
         *        With AS2, you can send files by calling <code>StartFileTransfer</code> and specifying the file paths
         *        in the request parameter, <code>SendFilePaths</code>. We use the file’s parent directory (for example,
         *        for <code>--send-file-paths /bucket/dir/file.txt</code>, parent directory is <code>/bucket/dir/</code>
         *        ) to temporarily store a processed AS2 message file, store the MDN when we receive them from the
         *        partner, and write a final JSON file containing relevant metadata of the transmission. So, the
         *        <code>AccessRole</code> needs to provide read and write access to the parent directory of the file
         *        location used in the <code>StartFileTransfer</code> request. Additionally, you need to provide read
         *        and write access to the parent directory of the files that you intend to send with
         *        <code>StartFileTransfer</code>.
         *        </p>
         *        <p>
         *        If you are using Basic authentication for your AS2 connector, the access role requires the
         *        <code>secretsmanager:GetSecretValue</code> permission for the secret. If the secret is encrypted using
         *        a customer-managed key instead of the Amazon Web Services managed key in Secrets Manager, then the
         *        role also needs the <code>kms:Decrypt</code> permission for that key.
         *        </p>
         *        <p>
         *        <b>For SFTP connectors</b>
         *        </p>
         *        <p>
         *        Make sure that the access role provides read and write access to the parent directory of the file
         *        location that's used in the <code>StartFileTransfer</code> request. Additionally, make sure that the
         *        role provides <code>secretsmanager:GetSecretValue</code> permission to Secrets Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessRole(String accessRole);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a connector to
         * turn on CloudWatch logging for Amazon S3 events. When set, you can view connector activity in your CloudWatch
         * logs.
         * </p>
         * 
         * @param loggingRole
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that allows a
         *        connector to turn on CloudWatch logging for Amazon S3 events. When set, you can view connector
         *        activity in your CloudWatch logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors
         * for any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to
         *        connectors for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors
         * for any purpose.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to
         *        connectors for any purpose.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for connectors. Tags are metadata attached to connectors
         * for any purpose.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A structure that contains the parameters for an SFTP connector object.
         * </p>
         * 
         * @param sftpConfig
         *        A structure that contains the parameters for an SFTP connector object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sftpConfig(SftpConnectorConfig sftpConfig);

        /**
         * <p>
         * A structure that contains the parameters for an SFTP connector object.
         * </p>
         * This is a convenience method that creates an instance of the {@link SftpConnectorConfig.Builder} avoiding the
         * need to create one manually via {@link SftpConnectorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SftpConnectorConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #sftpConfig(SftpConnectorConfig)}.
         * 
         * @param sftpConfig
         *        a consumer that will call methods on {@link SftpConnectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sftpConfig(SftpConnectorConfig)
         */
        default Builder sftpConfig(Consumer<SftpConnectorConfig.Builder> sftpConfig) {
            return sftpConfig(SftpConnectorConfig.builder().applyMutation(sftpConfig).build());
        }

        /**
         * <p>
         * Specifies the name of the security policy for the connector.
         * </p>
         * 
         * @param securityPolicyName
         *        Specifies the name of the security policy for the connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityPolicyName(String securityPolicyName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String url;

        private As2ConnectorConfig as2Config;

        private String accessRole;

        private String loggingRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private SftpConnectorConfig sftpConfig;

        private String securityPolicyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateConnectorRequest model) {
            super(model);
            url(model.url);
            as2Config(model.as2Config);
            accessRole(model.accessRole);
            loggingRole(model.loggingRole);
            tags(model.tags);
            sftpConfig(model.sftpConfig);
            securityPolicyName(model.securityPolicyName);
        }

        public final String getUrl() {
            return url;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final As2ConnectorConfig.Builder getAs2Config() {
            return as2Config != null ? as2Config.toBuilder() : null;
        }

        public final void setAs2Config(As2ConnectorConfig.BuilderImpl as2Config) {
            this.as2Config = as2Config != null ? as2Config.build() : null;
        }

        @Override
        public final Builder as2Config(As2ConnectorConfig as2Config) {
            this.as2Config = as2Config;
            return this;
        }

        public final String getAccessRole() {
            return accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final SftpConnectorConfig.Builder getSftpConfig() {
            return sftpConfig != null ? sftpConfig.toBuilder() : null;
        }

        public final void setSftpConfig(SftpConnectorConfig.BuilderImpl sftpConfig) {
            this.sftpConfig = sftpConfig != null ? sftpConfig.build() : null;
        }

        @Override
        public final Builder sftpConfig(SftpConnectorConfig sftpConfig) {
            this.sftpConfig = sftpConfig;
            return this;
        }

        public final String getSecurityPolicyName() {
            return securityPolicyName;
        }

        public final void setSecurityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
        }

        @Override
        public final Builder securityPolicyName(String securityPolicyName) {
            this.securityPolicyName = securityPolicyName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateConnectorRequest build() {
            return new CreateConnectorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
