/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWebAppRequest extends TransferRequest implements
        ToCopyableBuilder<CreateWebAppRequest.Builder, CreateWebAppRequest> {
    private static final SdkField<WebAppIdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<WebAppIdentityProviderDetails> builder(MarshallingType.SDK_POJO).memberName("IdentityProviderDetails")
            .getter(getter(CreateWebAppRequest::identityProviderDetails)).setter(setter(Builder::identityProviderDetails))
            .constructor(WebAppIdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build())
            .build();

    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessEndpoint").getter(getter(CreateWebAppRequest::accessEndpoint))
            .setter(setter(Builder::accessEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()).build();

    private static final SdkField<WebAppUnits> WEB_APP_UNITS_FIELD = SdkField.<WebAppUnits> builder(MarshallingType.SDK_POJO)
            .memberName("WebAppUnits").getter(getter(CreateWebAppRequest::webAppUnits)).setter(setter(Builder::webAppUnits))
            .constructor(WebAppUnits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppUnits").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateWebAppRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WEB_APP_ENDPOINT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppEndpointPolicy").getter(getter(CreateWebAppRequest::webAppEndpointPolicyAsString))
            .setter(setter(Builder::webAppEndpointPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpointPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_PROVIDER_DETAILS_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_UNITS_FIELD, TAGS_FIELD,
            WEB_APP_ENDPOINT_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final WebAppIdentityProviderDetails identityProviderDetails;

    private final String accessEndpoint;

    private final WebAppUnits webAppUnits;

    private final List<Tag> tags;

    private final String webAppEndpointPolicy;

    private CreateWebAppRequest(BuilderImpl builder) {
        super(builder);
        this.identityProviderDetails = builder.identityProviderDetails;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppUnits = builder.webAppUnits;
        this.tags = builder.tags;
        this.webAppEndpointPolicy = builder.webAppEndpointPolicy;
    }

    /**
     * <p>
     * You can provide a structure that contains the details for the identity provider to use with your web app.
     * </p>
     * <p>
     * For more details about this parameter, see <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html">Configure your identity
     * provider for Transfer Family web apps</a>.
     * </p>
     * 
     * @return You can provide a structure that contains the details for the identity provider to use with your web
     *         app.</p>
     *         <p>
     *         For more details about this parameter, see <a
     *         href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html">Configure your
     *         identity provider for Transfer Family web apps</a>.
     */
    public final WebAppIdentityProviderDetails identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer
     * Family web app. You can specify a custom URL or use the default value.
     * </p>
     * <p>
     * Before you enter a custom URL for this parameter, follow the steps described in <a
     * href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-customize.html">Update your access endpoint
     * with a custom URL</a>.
     * </p>
     * 
     * @return The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
     *         Transfer Family web app. You can specify a custom URL or use the default value.</p>
     *         <p>
     *         Before you enter a custom URL for this parameter, follow the steps described in <a
     *         href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-customize.html">Update your access
     *         endpoint with a custom URL</a>.
     */
    public final String accessEndpoint() {
        return accessEndpoint;
    }

    /**
     * <p>
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     * </p>
     * 
     * @return A union that contains the value for number of concurrent connections or the user sessions on your web
     *         app.
     */
    public final WebAppUnits webAppUnits() {
        return webAppUnits;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for web apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for web apps.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
     * </p>
     * <p>
     * If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this parameter to
     * <code>FIPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webAppEndpointPolicy} will return {@link WebAppEndpointPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webAppEndpointPolicyAsString}.
     * </p>
     * 
     * @return Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>. </p>
     *         <p>
     *         If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this
     *         parameter to <code>FIPS</code>.
     * @see WebAppEndpointPolicy
     */
    public final WebAppEndpointPolicy webAppEndpointPolicy() {
        return WebAppEndpointPolicy.fromValue(webAppEndpointPolicy);
    }

    /**
     * <p>
     * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
     * </p>
     * <p>
     * If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this parameter to
     * <code>FIPS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #webAppEndpointPolicy} will return {@link WebAppEndpointPolicy#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #webAppEndpointPolicyAsString}.
     * </p>
     * 
     * @return Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>. </p>
     *         <p>
     *         If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this
     *         parameter to <code>FIPS</code>.
     * @see WebAppEndpointPolicy
     */
    public final String webAppEndpointPolicyAsString() {
        return webAppEndpointPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(webAppUnits());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(webAppEndpointPolicyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWebAppRequest)) {
            return false;
        }
        CreateWebAppRequest other = (CreateWebAppRequest) obj;
        return Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(accessEndpoint(), other.accessEndpoint()) && Objects.equals(webAppUnits(), other.webAppUnits())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(webAppEndpointPolicyAsString(), other.webAppEndpointPolicyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWebAppRequest").add("IdentityProviderDetails", identityProviderDetails())
                .add("AccessEndpoint", accessEndpoint()).add("WebAppUnits", webAppUnits()).add("Tags", hasTags() ? tags() : null)
                .add("WebAppEndpointPolicy", webAppEndpointPolicyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "AccessEndpoint":
            return Optional.ofNullable(clazz.cast(accessEndpoint()));
        case "WebAppUnits":
            return Optional.ofNullable(clazz.cast(webAppUnits()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "WebAppEndpointPolicy":
            return Optional.ofNullable(clazz.cast(webAppEndpointPolicyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IdentityProviderDetails", IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppUnits", WEB_APP_UNITS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("WebAppEndpointPolicy", WEB_APP_ENDPOINT_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWebAppRequest, T> g) {
        return obj -> g.apply((CreateWebAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWebAppRequest> {
        /**
         * <p>
         * You can provide a structure that contains the details for the identity provider to use with your web app.
         * </p>
         * <p>
         * For more details about this parameter, see <a
         * href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html">Configure your
         * identity provider for Transfer Family web apps</a>.
         * </p>
         * 
         * @param identityProviderDetails
         *        You can provide a structure that contains the details for the identity provider to use with your web
         *        app.</p>
         *        <p>
         *        For more details about this parameter, see <a
         *        href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html">Configure
         *        your identity provider for Transfer Family web apps</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(WebAppIdentityProviderDetails identityProviderDetails);

        /**
         * <p>
         * You can provide a structure that contains the details for the identity provider to use with your web app.
         * </p>
         * <p>
         * For more details about this parameter, see <a
         * href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html">Configure your
         * identity provider for Transfer Family web apps</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAppIdentityProviderDetails.Builder}
         * avoiding the need to create one manually via {@link WebAppIdentityProviderDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAppIdentityProviderDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderDetails(WebAppIdentityProviderDetails)}.
         * 
         * @param identityProviderDetails
         *        a consumer that will call methods on {@link WebAppIdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderDetails(WebAppIdentityProviderDetails)
         */
        default Builder identityProviderDetails(Consumer<WebAppIdentityProviderDetails.Builder> identityProviderDetails) {
            return identityProviderDetails(WebAppIdentityProviderDetails.builder().applyMutation(identityProviderDetails).build());
        }

        /**
         * <p>
         * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
         * Transfer Family web app. You can specify a custom URL or use the default value.
         * </p>
         * <p>
         * Before you enter a custom URL for this parameter, follow the steps described in <a
         * href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-customize.html">Update your access
         * endpoint with a custom URL</a>.
         * </p>
         * 
         * @param accessEndpoint
         *        The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with
         *        the Transfer Family web app. You can specify a custom URL or use the default value.</p>
         *        <p>
         *        Before you enter a custom URL for this parameter, follow the steps described in <a
         *        href="https://docs.aws.amazon.com/transfer/latest/userguide/webapp-customize.html">Update your access
         *        endpoint with a custom URL</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoint(String accessEndpoint);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * 
         * @param webAppUnits
         *        A union that contains the value for number of concurrent connections or the user sessions on your web
         *        app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppUnits(WebAppUnits webAppUnits);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAppUnits.Builder} avoiding the need to
         * create one manually via {@link WebAppUnits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAppUnits.Builder#build()} is called immediately and its result
         * is passed to {@link #webAppUnits(WebAppUnits)}.
         * 
         * @param webAppUnits
         *        a consumer that will call methods on {@link WebAppUnits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAppUnits(WebAppUnits)
         */
        default Builder webAppUnits(Consumer<WebAppUnits.Builder> webAppUnits) {
            return webAppUnits(WebAppUnits.builder().applyMutation(webAppUnits).build());
        }

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for web apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for web apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for web apps.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.transfer.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         * </p>
         * <p>
         * If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this parameter to
         * <code>FIPS</code>.
         * </p>
         * 
         * @param webAppEndpointPolicy
         *        Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         *        </p>
         *        <p>
         *        If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this
         *        parameter to <code>FIPS</code>.
         * @see WebAppEndpointPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointPolicy
         */
        Builder webAppEndpointPolicy(String webAppEndpointPolicy);

        /**
         * <p>
         * Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         * </p>
         * <p>
         * If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this parameter to
         * <code>FIPS</code>.
         * </p>
         * 
         * @param webAppEndpointPolicy
         *        Setting for the type of endpoint policy for the web app. The default value is <code>STANDARD</code>.
         *        </p>
         *        <p>
         *        If you are creating the web app in an Amazon Web Services GovCloud (US) Region, you can set this
         *        parameter to <code>FIPS</code>.
         * @see WebAppEndpointPolicy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WebAppEndpointPolicy
         */
        Builder webAppEndpointPolicy(WebAppEndpointPolicy webAppEndpointPolicy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private WebAppIdentityProviderDetails identityProviderDetails;

        private String accessEndpoint;

        private WebAppUnits webAppUnits;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String webAppEndpointPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWebAppRequest model) {
            super(model);
            identityProviderDetails(model.identityProviderDetails);
            accessEndpoint(model.accessEndpoint);
            webAppUnits(model.webAppUnits);
            tags(model.tags);
            webAppEndpointPolicy(model.webAppEndpointPolicy);
        }

        public final WebAppIdentityProviderDetails.Builder getIdentityProviderDetails() {
            return identityProviderDetails != null ? identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(WebAppIdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(WebAppIdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getAccessEndpoint() {
            return accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final WebAppUnits.Builder getWebAppUnits() {
            return webAppUnits != null ? webAppUnits.toBuilder() : null;
        }

        public final void setWebAppUnits(WebAppUnits.BuilderImpl webAppUnits) {
            this.webAppUnits = webAppUnits != null ? webAppUnits.build() : null;
        }

        @Override
        public final Builder webAppUnits(WebAppUnits webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWebAppEndpointPolicy() {
            return webAppEndpointPolicy;
        }

        public final void setWebAppEndpointPolicy(String webAppEndpointPolicy) {
            this.webAppEndpointPolicy = webAppEndpointPolicy;
        }

        @Override
        public final Builder webAppEndpointPolicy(String webAppEndpointPolicy) {
            this.webAppEndpointPolicy = webAppEndpointPolicy;
            return this;
        }

        @Override
        public final Builder webAppEndpointPolicy(WebAppEndpointPolicy webAppEndpointPolicy) {
            this.webAppEndpointPolicy(webAppEndpointPolicy == null ? null : webAppEndpointPolicy.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWebAppRequest build() {
            return new CreateWebAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
