/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains Amazon S3 locations for storing specific types of AS2 message files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomDirectoriesType implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomDirectoriesType.Builder, CustomDirectoriesType> {
    private static final SdkField<String> FAILED_FILES_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailedFilesDirectory").getter(getter(CustomDirectoriesType::failedFilesDirectory))
            .setter(setter(Builder::failedFilesDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedFilesDirectory").build())
            .build();

    private static final SdkField<String> MDN_FILES_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MdnFilesDirectory").getter(getter(CustomDirectoriesType::mdnFilesDirectory))
            .setter(setter(Builder::mdnFilesDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MdnFilesDirectory").build()).build();

    private static final SdkField<String> PAYLOAD_FILES_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PayloadFilesDirectory").getter(getter(CustomDirectoriesType::payloadFilesDirectory))
            .setter(setter(Builder::payloadFilesDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadFilesDirectory").build())
            .build();

    private static final SdkField<String> STATUS_FILES_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusFilesDirectory").getter(getter(CustomDirectoriesType::statusFilesDirectory))
            .setter(setter(Builder::statusFilesDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusFilesDirectory").build())
            .build();

    private static final SdkField<String> TEMPORARY_FILES_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemporaryFilesDirectory").getter(getter(CustomDirectoriesType::temporaryFilesDirectory))
            .setter(setter(Builder::temporaryFilesDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemporaryFilesDirectory").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FILES_DIRECTORY_FIELD,
            MDN_FILES_DIRECTORY_FIELD, PAYLOAD_FILES_DIRECTORY_FIELD, STATUS_FILES_DIRECTORY_FIELD,
            TEMPORARY_FILES_DIRECTORY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String failedFilesDirectory;

    private final String mdnFilesDirectory;

    private final String payloadFilesDirectory;

    private final String statusFilesDirectory;

    private final String temporaryFilesDirectory;

    private CustomDirectoriesType(BuilderImpl builder) {
        this.failedFilesDirectory = builder.failedFilesDirectory;
        this.mdnFilesDirectory = builder.mdnFilesDirectory;
        this.payloadFilesDirectory = builder.payloadFilesDirectory;
        this.statusFilesDirectory = builder.statusFilesDirectory;
        this.temporaryFilesDirectory = builder.temporaryFilesDirectory;
    }

    /**
     * <p>
     * Specifies a location to store failed AS2 message files.
     * </p>
     * 
     * @return Specifies a location to store failed AS2 message files.
     */
    public final String failedFilesDirectory() {
        return failedFilesDirectory;
    }

    /**
     * <p>
     * Specifies a location to store MDN files.
     * </p>
     * 
     * @return Specifies a location to store MDN files.
     */
    public final String mdnFilesDirectory() {
        return mdnFilesDirectory;
    }

    /**
     * <p>
     * Specifies a location to store the payload for AS2 message files.
     * </p>
     * 
     * @return Specifies a location to store the payload for AS2 message files.
     */
    public final String payloadFilesDirectory() {
        return payloadFilesDirectory;
    }

    /**
     * <p>
     * Specifies a location to store AS2 status messages.
     * </p>
     * 
     * @return Specifies a location to store AS2 status messages.
     */
    public final String statusFilesDirectory() {
        return statusFilesDirectory;
    }

    /**
     * <p>
     * Specifies a location to store temporary AS2 message files.
     * </p>
     * 
     * @return Specifies a location to store temporary AS2 message files.
     */
    public final String temporaryFilesDirectory() {
        return temporaryFilesDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failedFilesDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(mdnFilesDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(payloadFilesDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(statusFilesDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(temporaryFilesDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomDirectoriesType)) {
            return false;
        }
        CustomDirectoriesType other = (CustomDirectoriesType) obj;
        return Objects.equals(failedFilesDirectory(), other.failedFilesDirectory())
                && Objects.equals(mdnFilesDirectory(), other.mdnFilesDirectory())
                && Objects.equals(payloadFilesDirectory(), other.payloadFilesDirectory())
                && Objects.equals(statusFilesDirectory(), other.statusFilesDirectory())
                && Objects.equals(temporaryFilesDirectory(), other.temporaryFilesDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomDirectoriesType").add("FailedFilesDirectory", failedFilesDirectory())
                .add("MdnFilesDirectory", mdnFilesDirectory()).add("PayloadFilesDirectory", payloadFilesDirectory())
                .add("StatusFilesDirectory", statusFilesDirectory()).add("TemporaryFilesDirectory", temporaryFilesDirectory())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailedFilesDirectory":
            return Optional.ofNullable(clazz.cast(failedFilesDirectory()));
        case "MdnFilesDirectory":
            return Optional.ofNullable(clazz.cast(mdnFilesDirectory()));
        case "PayloadFilesDirectory":
            return Optional.ofNullable(clazz.cast(payloadFilesDirectory()));
        case "StatusFilesDirectory":
            return Optional.ofNullable(clazz.cast(statusFilesDirectory()));
        case "TemporaryFilesDirectory":
            return Optional.ofNullable(clazz.cast(temporaryFilesDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FailedFilesDirectory", FAILED_FILES_DIRECTORY_FIELD);
        map.put("MdnFilesDirectory", MDN_FILES_DIRECTORY_FIELD);
        map.put("PayloadFilesDirectory", PAYLOAD_FILES_DIRECTORY_FIELD);
        map.put("StatusFilesDirectory", STATUS_FILES_DIRECTORY_FIELD);
        map.put("TemporaryFilesDirectory", TEMPORARY_FILES_DIRECTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomDirectoriesType, T> g) {
        return obj -> g.apply((CustomDirectoriesType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomDirectoriesType> {
        /**
         * <p>
         * Specifies a location to store failed AS2 message files.
         * </p>
         * 
         * @param failedFilesDirectory
         *        Specifies a location to store failed AS2 message files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedFilesDirectory(String failedFilesDirectory);

        /**
         * <p>
         * Specifies a location to store MDN files.
         * </p>
         * 
         * @param mdnFilesDirectory
         *        Specifies a location to store MDN files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mdnFilesDirectory(String mdnFilesDirectory);

        /**
         * <p>
         * Specifies a location to store the payload for AS2 message files.
         * </p>
         * 
         * @param payloadFilesDirectory
         *        Specifies a location to store the payload for AS2 message files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadFilesDirectory(String payloadFilesDirectory);

        /**
         * <p>
         * Specifies a location to store AS2 status messages.
         * </p>
         * 
         * @param statusFilesDirectory
         *        Specifies a location to store AS2 status messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusFilesDirectory(String statusFilesDirectory);

        /**
         * <p>
         * Specifies a location to store temporary AS2 message files.
         * </p>
         * 
         * @param temporaryFilesDirectory
         *        Specifies a location to store temporary AS2 message files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder temporaryFilesDirectory(String temporaryFilesDirectory);
    }

    static final class BuilderImpl implements Builder {
        private String failedFilesDirectory;

        private String mdnFilesDirectory;

        private String payloadFilesDirectory;

        private String statusFilesDirectory;

        private String temporaryFilesDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomDirectoriesType model) {
            failedFilesDirectory(model.failedFilesDirectory);
            mdnFilesDirectory(model.mdnFilesDirectory);
            payloadFilesDirectory(model.payloadFilesDirectory);
            statusFilesDirectory(model.statusFilesDirectory);
            temporaryFilesDirectory(model.temporaryFilesDirectory);
        }

        public final String getFailedFilesDirectory() {
            return failedFilesDirectory;
        }

        public final void setFailedFilesDirectory(String failedFilesDirectory) {
            this.failedFilesDirectory = failedFilesDirectory;
        }

        @Override
        public final Builder failedFilesDirectory(String failedFilesDirectory) {
            this.failedFilesDirectory = failedFilesDirectory;
            return this;
        }

        public final String getMdnFilesDirectory() {
            return mdnFilesDirectory;
        }

        public final void setMdnFilesDirectory(String mdnFilesDirectory) {
            this.mdnFilesDirectory = mdnFilesDirectory;
        }

        @Override
        public final Builder mdnFilesDirectory(String mdnFilesDirectory) {
            this.mdnFilesDirectory = mdnFilesDirectory;
            return this;
        }

        public final String getPayloadFilesDirectory() {
            return payloadFilesDirectory;
        }

        public final void setPayloadFilesDirectory(String payloadFilesDirectory) {
            this.payloadFilesDirectory = payloadFilesDirectory;
        }

        @Override
        public final Builder payloadFilesDirectory(String payloadFilesDirectory) {
            this.payloadFilesDirectory = payloadFilesDirectory;
            return this;
        }

        public final String getStatusFilesDirectory() {
            return statusFilesDirectory;
        }

        public final void setStatusFilesDirectory(String statusFilesDirectory) {
            this.statusFilesDirectory = statusFilesDirectory;
        }

        @Override
        public final Builder statusFilesDirectory(String statusFilesDirectory) {
            this.statusFilesDirectory = statusFilesDirectory;
            return this;
        }

        public final String getTemporaryFilesDirectory() {
            return temporaryFilesDirectory;
        }

        public final void setTemporaryFilesDirectory(String temporaryFilesDirectory) {
            this.temporaryFilesDirectory = temporaryFilesDirectory;
        }

        @Override
        public final Builder temporaryFilesDirectory(String temporaryFilesDirectory) {
            this.temporaryFilesDirectory = temporaryFilesDirectory;
            return this;
        }

        @Override
        public CustomDirectoriesType build() {
            return new CustomDirectoriesType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
