/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the error message and type, for an error that occurs during the execution of the workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionError implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionError.Builder, ExecutionError> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ExecutionError::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ExecutionError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String message;

    private ExecutionError(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
    }

    /**
     * <p>
     * Specifies the error type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file with the
     * same name already exists in the target location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file returns
     * <code>BAD_REQUEST</code>, as only S3 files can be tagged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does not
     * exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to complete one or
     * more of the steps in the workflow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: occurs when the execution times out.
     * </p>
     * <note>
     * <p>
     * You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
     * minutes).
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExecutionErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the error type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file
     *         with the same name already exists in the target location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file
     *         returns <code>BAD_REQUEST</code>, as only S3 files can be tagged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does
     *         not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to
     *         complete one or more of the steps in the workflow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: occurs when the execution times out.
     *         </p>
     *         <note>
     *         <p>
     *         You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
     *         minutes).
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
     *         </p>
     *         </li>
     * @see ExecutionErrorType
     */
    public final ExecutionErrorType type() {
        return ExecutionErrorType.fromValue(type);
    }

    /**
     * <p>
     * Specifies the error type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file with the
     * same name already exists in the target location.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file returns
     * <code>BAD_REQUEST</code>, as only S3 files can be tagged.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does not
     * exist.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to complete one or
     * more of the steps in the workflow.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMEOUT</code>: occurs when the execution times out.
     * </p>
     * <note>
     * <p>
     * You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
     * minutes).
     * </p>
     * </note></li>
     * <li>
     * <p>
     * <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExecutionErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Specifies the error type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file
     *         with the same name already exists in the target location.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file
     *         returns <code>BAD_REQUEST</code>, as only S3 files can be tagged.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does
     *         not exist.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to
     *         complete one or more of the steps in the workflow.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMEOUT</code>: occurs when the execution times out.
     *         </p>
     *         <note>
     *         <p>
     *         You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
     *         minutes).
     *         </p>
     *         </note></li>
     *         <li>
     *         <p>
     *         <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
     *         </p>
     *         </li>
     * @see ExecutionErrorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Specifies the descriptive message that corresponds to the <code>ErrorType</code>.
     * </p>
     * 
     * @return Specifies the descriptive message that corresponds to the <code>ErrorType</code>.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionError)) {
            return false;
        }
        ExecutionError other = (ExecutionError) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionError").add("Type", typeAsString()).add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Type", TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionError, T> g) {
        return obj -> g.apply((ExecutionError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionError> {
        /**
         * <p>
         * Specifies the error type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file with
         * the same name already exists in the target location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file returns
         * <code>BAD_REQUEST</code>, as only S3 files can be tagged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does not
         * exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to complete
         * one or more of the steps in the workflow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: occurs when the execution times out.
         * </p>
         * <note>
         * <p>
         * You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
         * minutes).
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Specifies the error type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a
         *        file with the same name already exists in the target location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file
         *        returns <code>BAD_REQUEST</code>, as only S3 files can be tagged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates
         *        failure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step,
         *        does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to
         *        complete one or more of the steps in the workflow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: occurs when the execution times out.
         *        </p>
         *        <note>
         *        <p>
         *        You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds
         *        (30 minutes).
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
         *        </p>
         *        </li>
         * @see ExecutionErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionErrorType
         */
        Builder type(String type);

        /**
         * <p>
         * Specifies the error type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a file with
         * the same name already exists in the target location.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file returns
         * <code>BAD_REQUEST</code>, as only S3 files can be tagged.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates failure.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step, does not
         * exist.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to complete
         * one or more of the steps in the workflow.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMEOUT</code>: occurs when the execution times out.
         * </p>
         * <note>
         * <p>
         * You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds (30
         * minutes).
         * </p>
         * </note></li>
         * <li>
         * <p>
         * <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        Specifies the error type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALREADY_EXISTS</code>: occurs for a copy step, if the overwrite option is not selected and a
         *        file with the same name already exists in the target location.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>BAD_REQUEST</code>: a general bad request: for example, a step that attempts to tag an EFS file
         *        returns <code>BAD_REQUEST</code>, as only S3 files can be tagged.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CUSTOM_STEP_FAILED</code>: occurs when the custom step provided a callback that indicates
         *        failure.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERNAL_SERVER_ERROR</code>: a catch-all error that can occur for a variety of reasons.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_FOUND</code>: occurs when a requested entity, for example a source file for a copy step,
         *        does not exist.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PERMISSION_DENIED</code>: occurs if your policy does not contain the correct permissions to
         *        complete one or more of the steps in the workflow.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMEOUT</code>: occurs when the execution times out.
         *        </p>
         *        <note>
         *        <p>
         *        You can set the <code>TimeoutSeconds</code> for a custom step, anywhere from 1 second to 1800 seconds
         *        (30 minutes).
         *        </p>
         *        </note></li>
         *        <li>
         *        <p>
         *        <code>THROTTLED</code>: occurs if you exceed the new execution refill rate of one workflow per second.
         *        </p>
         *        </li>
         * @see ExecutionErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionErrorType
         */
        Builder type(ExecutionErrorType type);

        /**
         * <p>
         * Specifies the descriptive message that corresponds to the <code>ErrorType</code>.
         * </p>
         * 
         * @param message
         *        Specifies the descriptive message that corresponds to the <code>ErrorType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionError model) {
            type(model.type);
            message(model.message);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExecutionErrorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ExecutionError build() {
            return new ExecutionError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
