/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListConnectorsResponse extends TransferResponse implements
        ToCopyableBuilder<ListConnectorsResponse.Builder, ListConnectorsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListConnectorsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListedConnector>> CONNECTORS_FIELD = SdkField
            .<List<ListedConnector>> builder(MarshallingType.LIST)
            .memberName("Connectors")
            .getter(getter(ListConnectorsResponse::connectors))
            .setter(setter(Builder::connectors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Connectors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListedConnector> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListedConnector::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CONNECTORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListedConnector> connectors;

    private ListConnectorsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.connectors = builder.connectors;
    }

    /**
     * <p>
     * Returns a token that you can use to call <code>ListConnectors</code> again and receive additional results, if
     * there are any.
     * </p>
     * 
     * @return Returns a token that you can use to call <code>ListConnectors</code> again and receive additional
     *         results, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Connectors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConnectors() {
        return connectors != null && !(connectors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns an array, where each item contains the details of a connector.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConnectors} method.
     * </p>
     * 
     * @return Returns an array, where each item contains the details of a connector.
     */
    public final List<ListedConnector> connectors() {
        return connectors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasConnectors() ? connectors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConnectorsResponse)) {
            return false;
        }
        ListConnectorsResponse other = (ListConnectorsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasConnectors() == other.hasConnectors()
                && Objects.equals(connectors(), other.connectors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListConnectorsResponse").add("NextToken", nextToken())
                .add("Connectors", hasConnectors() ? connectors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Connectors":
            return Optional.ofNullable(clazz.cast(connectors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Connectors", CONNECTORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListConnectorsResponse, T> g) {
        return obj -> g.apply((ListConnectorsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListConnectorsResponse> {
        /**
         * <p>
         * Returns a token that you can use to call <code>ListConnectors</code> again and receive additional results, if
         * there are any.
         * </p>
         * 
         * @param nextToken
         *        Returns a token that you can use to call <code>ListConnectors</code> again and receive additional
         *        results, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns an array, where each item contains the details of a connector.
         * </p>
         * 
         * @param connectors
         *        Returns an array, where each item contains the details of a connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(Collection<ListedConnector> connectors);

        /**
         * <p>
         * Returns an array, where each item contains the details of a connector.
         * </p>
         * 
         * @param connectors
         *        Returns an array, where each item contains the details of a connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectors(ListedConnector... connectors);

        /**
         * <p>
         * Returns an array, where each item contains the details of a connector.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.transfer.model.ListedConnector.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.transfer.model.ListedConnector#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.transfer.model.ListedConnector.Builder#build()} is called immediately
         * and its result is passed to {@link #connectors(List<ListedConnector>)}.
         * 
         * @param connectors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.transfer.model.ListedConnector.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectors(java.util.Collection<ListedConnector>)
         */
        Builder connectors(Consumer<ListedConnector.Builder>... connectors);
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListedConnector> connectors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListConnectorsResponse model) {
            super(model);
            nextToken(model.nextToken);
            connectors(model.connectors);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListedConnector.Builder> getConnectors() {
            List<ListedConnector.Builder> result = ListedConnectorsCopier.copyToBuilder(this.connectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConnectors(Collection<ListedConnector.BuilderImpl> connectors) {
            this.connectors = ListedConnectorsCopier.copyFromBuilder(connectors);
        }

        @Override
        public final Builder connectors(Collection<ListedConnector> connectors) {
            this.connectors = ListedConnectorsCopier.copy(connectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(ListedConnector... connectors) {
            connectors(Arrays.asList(connectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder connectors(Consumer<ListedConnector.Builder>... connectors) {
            connectors(Stream.of(connectors).map(c -> ListedConnector.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListConnectorsResponse build() {
            return new ListConnectorsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
