/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns properties of the user that you specify.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedUser implements SdkPojo, Serializable, ToCopyableBuilder<ListedUser.Builder, ListedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectory").getter(getter(ListedUser::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomeDirectoryType").getter(getter(ListedUser::homeDirectoryTypeAsString))
            .setter(setter(Builder::homeDirectoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectoryType").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(ListedUser::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<Integer> SSH_PUBLIC_KEY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SshPublicKeyCount").getter(getter(ListedUser::sshPublicKeyCount))
            .setter(setter(Builder::sshPublicKeyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyCount").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(ListedUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            HOME_DIRECTORY_FIELD, HOME_DIRECTORY_TYPE_FIELD, ROLE_FIELD, SSH_PUBLIC_KEY_COUNT_FIELD, USER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String homeDirectory;

    private final String homeDirectoryType;

    private final String role;

    private final Integer sshPublicKeyCount;

    private final String userName;

    private ListedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.homeDirectoryType = builder.homeDirectoryType;
        this.role = builder.role;
        this.sshPublicKeyCount = builder.sshPublicKeyCount;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
     * </p>
     * 
     * @return Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The landing directory (folder) for a user when they log in to the server using the client.
     * </p>
     * <p>
     * A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
     * </p>
     * <note>
     * <p>
     * You can use the <code>HomeDirectory</code> parameter for <code>HomeDirectoryType</code> when it is set to either
     * <code>PATH</code> or <code>LOGICAL</code>.
     * </p>
     * </note>
     * 
     * @return The landing directory (folder) for a user when they log in to the server using the client.</p>
     *         <p>
     *         A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
     *         </p>
     *         <note>
     *         <p>
     *         You can use the <code>HomeDirectory</code> parameter for <code>HomeDirectoryType</code> when it is set to
     *         either <code>PATH</code> or <code>LOGICAL</code>.
     *         </p>
     */
    public final String homeDirectory() {
        return homeDirectory;
    }

    /**
     * <p>
     * The type of landing directory (folder) that you want your users' home directory to be when they log in to the
     * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon EFS path as
     * is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need to provide mappings
     * in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS paths visible to your
     * users.
     * </p>
     * <note>
     * <p>
     * If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
     * <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
     * <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot have
     * both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) that you want your users' home directory to be when they log in to
     *         the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon
     *         EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need
     *         to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
     *         Amazon EFS paths visible to your users.</p> <note>
     *         <p>
     *         If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
     *         <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
     *         <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You
     *         cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
     *         </p>
     * @see HomeDirectoryType
     */
    public final HomeDirectoryType homeDirectoryType() {
        return HomeDirectoryType.fromValue(homeDirectoryType);
    }

    /**
     * <p>
     * The type of landing directory (folder) that you want your users' home directory to be when they log in to the
     * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon EFS path as
     * is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need to provide mappings
     * in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS paths visible to your
     * users.
     * </p>
     * <note>
     * <p>
     * If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
     * <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
     * <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot have
     * both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
     * </p>
     * </note>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #homeDirectoryType}
     * will return {@link HomeDirectoryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #homeDirectoryTypeAsString}.
     * </p>
     * 
     * @return The type of landing directory (folder) that you want your users' home directory to be when they log in to
     *         the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon
     *         EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need
     *         to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or
     *         Amazon EFS paths visible to your users.</p> <note>
     *         <p>
     *         If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
     *         <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
     *         <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You
     *         cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
     *         </p>
     * @see HomeDirectoryType
     */
    public final String homeDirectoryTypeAsString() {
        return homeDirectoryType;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users' access
     * to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the level of
     * access that you want to provide your users when transferring files into and out of your Amazon S3 bucket or
     * Amazon EFS file system. The IAM role should also contain a trust relationship that allows the server to access
     * your resources when servicing your users' transfer requests.
     * </p>
     * <note>
     * <p>
     * The IAM role that controls your users' access to your Amazon S3 bucket for servers with <code>Domain=S3</code>,
     * or your EFS file system for servers with <code>Domain=EFS</code>.
     * </p>
     * <p>
     * The policies attached to this role determine the level of access you want to provide your users when transferring
     * files into and out of your S3 buckets or EFS file systems.
     * </p>
     * </note>
     * 
     * @return The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users'
     *         access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine
     *         the level of access that you want to provide your users when transferring files into and out of your
     *         Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that
     *         allows the server to access your resources when servicing your users' transfer requests.</p> <note>
     *         <p>
     *         The IAM role that controls your users' access to your Amazon S3 bucket for servers with
     *         <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>.
     *         </p>
     *         <p>
     *         The policies attached to this role determine the level of access you want to provide your users when
     *         transferring files into and out of your S3 buckets or EFS file systems.
     *         </p>
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * Specifies the number of SSH public keys stored for the user you specified.
     * </p>
     * 
     * @return Specifies the number of SSH public keys stored for the user you specified.
     */
    public final Integer sshPublicKeyCount() {
        return sshPublicKeyCount;
    }

    /**
     * <p>
     * Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.
     * </p>
     * 
     * @return Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.
     */
    public final String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectoryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyCount());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedUser)) {
            return false;
        }
        ListedUser other = (ListedUser) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(homeDirectory(), other.homeDirectory())
                && Objects.equals(homeDirectoryTypeAsString(), other.homeDirectoryTypeAsString())
                && Objects.equals(role(), other.role()) && Objects.equals(sshPublicKeyCount(), other.sshPublicKeyCount())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedUser").add("Arn", arn()).add("HomeDirectory", homeDirectory())
                .add("HomeDirectoryType", homeDirectoryTypeAsString()).add("Role", role())
                .add("SshPublicKeyCount", sshPublicKeyCount()).add("UserName", userName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "HomeDirectoryType":
            return Optional.ofNullable(clazz.cast(homeDirectoryTypeAsString()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SshPublicKeyCount":
            return Optional.ofNullable(clazz.cast(sshPublicKeyCount()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("HomeDirectory", HOME_DIRECTORY_FIELD);
        map.put("HomeDirectoryType", HOME_DIRECTORY_TYPE_FIELD);
        map.put("Role", ROLE_FIELD);
        map.put("SshPublicKeyCount", SSH_PUBLIC_KEY_COUNT_FIELD);
        map.put("UserName", USER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedUser, T> g) {
        return obj -> g.apply((ListedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedUser> {
        /**
         * <p>
         * Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
         * </p>
         * 
         * @param arn
         *        Provides the unique Amazon Resource Name (ARN) for the user that you want to learn about.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The landing directory (folder) for a user when they log in to the server using the client.
         * </p>
         * <p>
         * A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
         * </p>
         * <note>
         * <p>
         * You can use the <code>HomeDirectory</code> parameter for <code>HomeDirectoryType</code> when it is set to
         * either <code>PATH</code> or <code>LOGICAL</code>.
         * </p>
         * </note>
         * 
         * @param homeDirectory
         *        The landing directory (folder) for a user when they log in to the server using the client.</p>
         *        <p>
         *        A <code>HomeDirectory</code> example is <code>/bucket_name/home/mydirectory</code>.
         *        </p>
         *        <note>
         *        <p>
         *        You can use the <code>HomeDirectory</code> parameter for <code>HomeDirectoryType</code> when it is set
         *        to either <code>PATH</code> or <code>LOGICAL</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * The type of landing directory (folder) that you want your users' home directory to be when they log in to the
         * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon EFS
         * path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need to
         * provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS
         * paths visible to your users.
         * </p>
         * <note>
         * <p>
         * If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
         * <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
         * <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot
         * have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
         * </p>
         * </note>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) that you want your users' home directory to be when they log in
         *        to the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or
         *        Amazon EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>,
         *        you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
         *        S3 or Amazon EFS paths visible to your users.</p> <note>
         *        <p>
         *        If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
         *        <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
         *        <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You
         *        cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
         *        </p>
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(String homeDirectoryType);

        /**
         * <p>
         * The type of landing directory (folder) that you want your users' home directory to be when they log in to the
         * server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or Amazon EFS
         * path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>, you need to
         * provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon S3 or Amazon EFS
         * paths visible to your users.
         * </p>
         * <note>
         * <p>
         * If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
         * <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
         * <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You cannot
         * have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
         * </p>
         * </note>
         * 
         * @param homeDirectoryType
         *        The type of landing directory (folder) that you want your users' home directory to be when they log in
         *        to the server. If you set it to <code>PATH</code>, the user will see the absolute Amazon S3 bucket or
         *        Amazon EFS path as is in their file transfer protocol clients. If you set it to <code>LOGICAL</code>,
         *        you need to provide mappings in the <code>HomeDirectoryMappings</code> for how you want to make Amazon
         *        S3 or Amazon EFS paths visible to your users.</p> <note>
         *        <p>
         *        If <code>HomeDirectoryType</code> is <code>LOGICAL</code>, you must provide mappings, using the
         *        <code>HomeDirectoryMappings</code> parameter. If, on the other hand, <code>HomeDirectoryType</code> is
         *        <code>PATH</code>, you provide an absolute path using the <code>HomeDirectory</code> parameter. You
         *        cannot have both <code>HomeDirectory</code> and <code>HomeDirectoryMappings</code> in your template.
         *        </p>
         * @see HomeDirectoryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HomeDirectoryType
         */
        Builder homeDirectoryType(HomeDirectoryType homeDirectoryType);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your users'
         * access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role determine the
         * level of access that you want to provide your users when transferring files into and out of your Amazon S3
         * bucket or Amazon EFS file system. The IAM role should also contain a trust relationship that allows the
         * server to access your resources when servicing your users' transfer requests.
         * </p>
         * <note>
         * <p>
         * The IAM role that controls your users' access to your Amazon S3 bucket for servers with
         * <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>.
         * </p>
         * <p>
         * The policies attached to this role determine the level of access you want to provide your users when
         * transferring files into and out of your S3 buckets or EFS file systems.
         * </p>
         * </note>
         * 
         * @param role
         *        The Amazon Resource Name (ARN) of the Identity and Access Management (IAM) role that controls your
         *        users' access to your Amazon S3 bucket or Amazon EFS file system. The policies attached to this role
         *        determine the level of access that you want to provide your users when transferring files into and out
         *        of your Amazon S3 bucket or Amazon EFS file system. The IAM role should also contain a trust
         *        relationship that allows the server to access your resources when servicing your users' transfer
         *        requests.</p> <note>
         *        <p>
         *        The IAM role that controls your users' access to your Amazon S3 bucket for servers with
         *        <code>Domain=S3</code>, or your EFS file system for servers with <code>Domain=EFS</code>.
         *        </p>
         *        <p>
         *        The policies attached to this role determine the level of access you want to provide your users when
         *        transferring files into and out of your S3 buckets or EFS file systems.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * Specifies the number of SSH public keys stored for the user you specified.
         * </p>
         * 
         * @param sshPublicKeyCount
         *        Specifies the number of SSH public keys stored for the user you specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyCount(Integer sshPublicKeyCount);

        /**
         * <p>
         * Specifies the name of the user whose ARN was specified. User names are used for authentication purposes.
         * </p>
         * 
         * @param userName
         *        Specifies the name of the user whose ARN was specified. User names are used for authentication
         *        purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String homeDirectory;

        private String homeDirectoryType;

        private String role;

        private Integer sshPublicKeyCount;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedUser model) {
            arn(model.arn);
            homeDirectory(model.homeDirectory);
            homeDirectoryType(model.homeDirectoryType);
            role(model.role);
            sshPublicKeyCount(model.sshPublicKeyCount);
            userName(model.userName);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final String getHomeDirectoryType() {
            return homeDirectoryType;
        }

        public final void setHomeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
        }

        @Override
        public final Builder homeDirectoryType(String homeDirectoryType) {
            this.homeDirectoryType = homeDirectoryType;
            return this;
        }

        @Override
        public final Builder homeDirectoryType(HomeDirectoryType homeDirectoryType) {
            this.homeDirectoryType(homeDirectoryType == null ? null : homeDirectoryType.toString());
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final Integer getSshPublicKeyCount() {
            return sshPublicKeyCount;
        }

        public final void setSshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
        }

        @Override
        public final Builder sshPublicKeyCount(Integer sshPublicKeyCount) {
            this.sshPublicKeyCount = sshPublicKeyCount;
            return this;
        }

        public final String getUserName() {
            return userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        @Override
        public ListedUser build() {
            return new ListedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
