/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon S3 storage options that are configured for your server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3StorageOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<S3StorageOptions.Builder, S3StorageOptions> {
    private static final SdkField<String> DIRECTORY_LISTING_OPTIMIZATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DirectoryListingOptimization")
            .getter(getter(S3StorageOptions::directoryListingOptimizationAsString))
            .setter(setter(Builder::directoryListingOptimization))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryListingOptimization")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECTORY_LISTING_OPTIMIZATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String directoryListingOptimization;

    private S3StorageOptions(BuilderImpl builder) {
        this.directoryListingOptimization = builder.directoryListingOptimization;
    }

    /**
     * <p>
     * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
     * </p>
     * <p>
     * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable this
     * option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to
     * <code>FILE</code> if you want a mapping to have a file target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryListingOptimization} will return {@link DirectoryListingOptimization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #directoryListingOptimizationAsString}.
     * </p>
     * 
     * @return Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
     *         default.</p>
     *         <p>
     *         By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable
     *         this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code>
     *         <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
     * @see DirectoryListingOptimization
     */
    public final DirectoryListingOptimization directoryListingOptimization() {
        return DirectoryListingOptimization.fromValue(directoryListingOptimization);
    }

    /**
     * <p>
     * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by default.
     * </p>
     * <p>
     * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable this
     * option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to
     * <code>FILE</code> if you want a mapping to have a file target.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #directoryListingOptimization} will return {@link DirectoryListingOptimization#UNKNOWN_TO_SDK_VERSION}.
     * The raw value returned by the service is available from {@link #directoryListingOptimizationAsString}.
     * </p>
     * 
     * @return Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
     *         default.</p>
     *         <p>
     *         By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable
     *         this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code>
     *         <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
     * @see DirectoryListingOptimization
     */
    public final String directoryListingOptimizationAsString() {
        return directoryListingOptimization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryListingOptimizationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3StorageOptions)) {
            return false;
        }
        S3StorageOptions other = (S3StorageOptions) obj;
        return Objects.equals(directoryListingOptimizationAsString(), other.directoryListingOptimizationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3StorageOptions").add("DirectoryListingOptimization", directoryListingOptimizationAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryListingOptimization":
            return Optional.ofNullable(clazz.cast(directoryListingOptimizationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DirectoryListingOptimization", DIRECTORY_LISTING_OPTIMIZATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3StorageOptions, T> g) {
        return obj -> g.apply((S3StorageOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3StorageOptions> {
        /**
         * <p>
         * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
         * default.
         * </p>
         * <p>
         * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable this
         * option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to
         * <code>FILE</code> if you want a mapping to have a file target.
         * </p>
         * 
         * @param directoryListingOptimization
         *        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
         *        default.</p>
         *        <p>
         *        By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable
         *        this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code>
         *        <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
         * @see DirectoryListingOptimization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryListingOptimization
         */
        Builder directoryListingOptimization(String directoryListingOptimization);

        /**
         * <p>
         * Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
         * default.
         * </p>
         * <p>
         * By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable this
         * option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code> <code>Type</code> to
         * <code>FILE</code> if you want a mapping to have a file target.
         * </p>
         * 
         * @param directoryListingOptimization
         *        Specifies whether or not performance for your Amazon S3 directories is optimized. This is disabled by
         *        default.</p>
         *        <p>
         *        By default, home directory mappings have a <code>TYPE</code> of <code>DIRECTORY</code>. If you enable
         *        this option, you would then need to explicitly set the <code>HomeDirectoryMapEntry</code>
         *        <code>Type</code> to <code>FILE</code> if you want a mapping to have a file target.
         * @see DirectoryListingOptimization
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DirectoryListingOptimization
         */
        Builder directoryListingOptimization(DirectoryListingOptimization directoryListingOptimization);
    }

    static final class BuilderImpl implements Builder {
        private String directoryListingOptimization;

        private BuilderImpl() {
        }

        private BuilderImpl(S3StorageOptions model) {
            directoryListingOptimization(model.directoryListingOptimization);
        }

        public final String getDirectoryListingOptimization() {
            return directoryListingOptimization;
        }

        public final void setDirectoryListingOptimization(String directoryListingOptimization) {
            this.directoryListingOptimization = directoryListingOptimization;
        }

        @Override
        public final Builder directoryListingOptimization(String directoryListingOptimization) {
            this.directoryListingOptimization = directoryListingOptimization;
            return this;
        }

        @Override
        public final Builder directoryListingOptimization(DirectoryListingOptimization directoryListingOptimization) {
            this.directoryListingOptimization(directoryListingOptimization == null ? null : directoryListingOptimization
                    .toString());
            return this;
        }

        @Override
        public S3StorageOptions build() {
            return new S3StorageOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
