/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWebAppRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateWebAppRequest.Builder, UpdateWebAppRequest> {
    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppId").getter(getter(UpdateWebAppRequest::webAppId)).setter(setter(Builder::webAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()).build();

    private static final SdkField<UpdateWebAppIdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<UpdateWebAppIdentityProviderDetails> builder(MarshallingType.SDK_POJO).memberName("IdentityProviderDetails")
            .getter(getter(UpdateWebAppRequest::identityProviderDetails)).setter(setter(Builder::identityProviderDetails))
            .constructor(UpdateWebAppIdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build())
            .build();

    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessEndpoint").getter(getter(UpdateWebAppRequest::accessEndpoint))
            .setter(setter(Builder::accessEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()).build();

    private static final SdkField<WebAppUnits> WEB_APP_UNITS_FIELD = SdkField.<WebAppUnits> builder(MarshallingType.SDK_POJO)
            .memberName("WebAppUnits").getter(getter(UpdateWebAppRequest::webAppUnits)).setter(setter(Builder::webAppUnits))
            .constructor(WebAppUnits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppUnits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WEB_APP_ID_FIELD,
            IDENTITY_PROVIDER_DETAILS_FIELD, ACCESS_ENDPOINT_FIELD, WEB_APP_UNITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String webAppId;

    private final UpdateWebAppIdentityProviderDetails identityProviderDetails;

    private final String accessEndpoint;

    private final WebAppUnits webAppUnits;

    private UpdateWebAppRequest(BuilderImpl builder) {
        super(builder);
        this.webAppId = builder.webAppId;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppUnits = builder.webAppUnits;
    }

    /**
     * <p>
     * Provide the identifier of the web app that you are updating.
     * </p>
     * 
     * @return Provide the identifier of the web app that you are updating.
     */
    public final String webAppId() {
        return webAppId;
    }

    /**
     * <p>
     * Provide updated identity provider values in a <code>WebAppIdentityProviderDetails</code> object.
     * </p>
     * 
     * @return Provide updated identity provider values in a <code>WebAppIdentityProviderDetails</code> object.
     */
    public final UpdateWebAppIdentityProviderDetails identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer
     * Family web app. You can specify a custom URL or use the default value.
     * </p>
     * 
     * @return The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
     *         Transfer Family web app. You can specify a custom URL or use the default value.
     */
    public final String accessEndpoint() {
        return accessEndpoint;
    }

    /**
     * <p>
     * A union that contains the value for number of concurrent connections or the user sessions on your web app.
     * </p>
     * 
     * @return A union that contains the value for number of concurrent connections or the user sessions on your web
     *         app.
     */
    public final WebAppUnits webAppUnits() {
        return webAppUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(webAppUnits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWebAppRequest)) {
            return false;
        }
        UpdateWebAppRequest other = (UpdateWebAppRequest) obj;
        return Objects.equals(webAppId(), other.webAppId())
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(accessEndpoint(), other.accessEndpoint()) && Objects.equals(webAppUnits(), other.webAppUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWebAppRequest").add("WebAppId", webAppId())
                .add("IdentityProviderDetails", identityProviderDetails()).add("AccessEndpoint", accessEndpoint())
                .add("WebAppUnits", webAppUnits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WebAppId":
            return Optional.ofNullable(clazz.cast(webAppId()));
        case "IdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "AccessEndpoint":
            return Optional.ofNullable(clazz.cast(accessEndpoint()));
        case "WebAppUnits":
            return Optional.ofNullable(clazz.cast(webAppUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("IdentityProviderDetails", IDENTITY_PROVIDER_DETAILS_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppUnits", WEB_APP_UNITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWebAppRequest, T> g) {
        return obj -> g.apply((UpdateWebAppRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWebAppRequest> {
        /**
         * <p>
         * Provide the identifier of the web app that you are updating.
         * </p>
         * 
         * @param webAppId
         *        Provide the identifier of the web app that you are updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppId(String webAppId);

        /**
         * <p>
         * Provide updated identity provider values in a <code>WebAppIdentityProviderDetails</code> object.
         * </p>
         * 
         * @param identityProviderDetails
         *        Provide updated identity provider values in a <code>WebAppIdentityProviderDetails</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(UpdateWebAppIdentityProviderDetails identityProviderDetails);

        /**
         * <p>
         * Provide updated identity provider values in a <code>WebAppIdentityProviderDetails</code> object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link UpdateWebAppIdentityProviderDetails.Builder} avoiding the need to create one manually via
         * {@link UpdateWebAppIdentityProviderDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UpdateWebAppIdentityProviderDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #identityProviderDetails(UpdateWebAppIdentityProviderDetails)}.
         * 
         * @param identityProviderDetails
         *        a consumer that will call methods on {@link UpdateWebAppIdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderDetails(UpdateWebAppIdentityProviderDetails)
         */
        default Builder identityProviderDetails(Consumer<UpdateWebAppIdentityProviderDetails.Builder> identityProviderDetails) {
            return identityProviderDetails(UpdateWebAppIdentityProviderDetails.builder().applyMutation(identityProviderDetails)
                    .build());
        }

        /**
         * <p>
         * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
         * Transfer Family web app. You can specify a custom URL or use the default value.
         * </p>
         * 
         * @param accessEndpoint
         *        The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with
         *        the Transfer Family web app. You can specify a custom URL or use the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoint(String accessEndpoint);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * 
         * @param webAppUnits
         *        A union that contains the value for number of concurrent connections or the user sessions on your web
         *        app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppUnits(WebAppUnits webAppUnits);

        /**
         * <p>
         * A union that contains the value for number of concurrent connections or the user sessions on your web app.
         * </p>
         * This is a convenience method that creates an instance of the {@link WebAppUnits.Builder} avoiding the need to
         * create one manually via {@link WebAppUnits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WebAppUnits.Builder#build()} is called immediately and its result
         * is passed to {@link #webAppUnits(WebAppUnits)}.
         * 
         * @param webAppUnits
         *        a consumer that will call methods on {@link WebAppUnits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #webAppUnits(WebAppUnits)
         */
        default Builder webAppUnits(Consumer<WebAppUnits.Builder> webAppUnits) {
            return webAppUnits(WebAppUnits.builder().applyMutation(webAppUnits).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String webAppId;

        private UpdateWebAppIdentityProviderDetails identityProviderDetails;

        private String accessEndpoint;

        private WebAppUnits webAppUnits;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWebAppRequest model) {
            super(model);
            webAppId(model.webAppId);
            identityProviderDetails(model.identityProviderDetails);
            accessEndpoint(model.accessEndpoint);
            webAppUnits(model.webAppUnits);
        }

        public final String getWebAppId() {
            return webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final UpdateWebAppIdentityProviderDetails.Builder getIdentityProviderDetails() {
            return identityProviderDetails != null ? identityProviderDetails.toBuilder() : null;
        }

        public final void setIdentityProviderDetails(UpdateWebAppIdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        @Override
        public final Builder identityProviderDetails(UpdateWebAppIdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final String getAccessEndpoint() {
            return accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final WebAppUnits.Builder getWebAppUnits() {
            return webAppUnits != null ? webAppUnits.toBuilder() : null;
        }

        public final void setWebAppUnits(WebAppUnits.BuilderImpl webAppUnits) {
            this.webAppUnits = webAppUnits != null ? webAppUnits.build() : null;
        }

        @Override
        public final Builder webAppUnits(WebAppUnits webAppUnits) {
            this.webAppUnits = webAppUnits;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWebAppRequest build() {
            return new UpdateWebAppRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
