/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgreementResponse extends TransferResponse implements
        ToCopyableBuilder<DescribeAgreementResponse.Builder, DescribeAgreementResponse> {
    private static final SdkField<DescribedAgreement> AGREEMENT_FIELD = SdkField
            .<DescribedAgreement> builder(MarshallingType.SDK_POJO).memberName("Agreement")
            .getter(getter(DescribeAgreementResponse::agreement)).setter(setter(Builder::agreement))
            .constructor(DescribedAgreement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Agreement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DescribedAgreement agreement;

    private DescribeAgreementResponse(BuilderImpl builder) {
        super(builder);
        this.agreement = builder.agreement;
    }

    /**
     * <p>
     * The details for the specified agreement, returned as a <code>DescribedAgreement</code> object.
     * </p>
     * 
     * @return The details for the specified agreement, returned as a <code>DescribedAgreement</code> object.
     */
    public final DescribedAgreement agreement() {
        return agreement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agreement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgreementResponse)) {
            return false;
        }
        DescribeAgreementResponse other = (DescribeAgreementResponse) obj;
        return Objects.equals(agreement(), other.agreement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgreementResponse").add("Agreement", agreement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Agreement":
            return Optional.ofNullable(clazz.cast(agreement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Agreement", AGREEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgreementResponse, T> g) {
        return obj -> g.apply((DescribeAgreementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends TransferResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAgreementResponse> {
        /**
         * <p>
         * The details for the specified agreement, returned as a <code>DescribedAgreement</code> object.
         * </p>
         * 
         * @param agreement
         *        The details for the specified agreement, returned as a <code>DescribedAgreement</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreement(DescribedAgreement agreement);

        /**
         * <p>
         * The details for the specified agreement, returned as a <code>DescribedAgreement</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link DescribedAgreement.Builder} avoiding the
         * need to create one manually via {@link DescribedAgreement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DescribedAgreement.Builder#build()} is called immediately and its
         * result is passed to {@link #agreement(DescribedAgreement)}.
         * 
         * @param agreement
         *        a consumer that will call methods on {@link DescribedAgreement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agreement(DescribedAgreement)
         */
        default Builder agreement(Consumer<DescribedAgreement.Builder> agreement) {
            return agreement(DescribedAgreement.builder().applyMutation(agreement).build());
        }
    }

    static final class BuilderImpl extends TransferResponse.BuilderImpl implements Builder {
        private DescribedAgreement agreement;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgreementResponse model) {
            super(model);
            agreement(model.agreement);
        }

        public final DescribedAgreement.Builder getAgreement() {
            return agreement != null ? agreement.toBuilder() : null;
        }

        public final void setAgreement(DescribedAgreement.BuilderImpl agreement) {
            this.agreement = agreement != null ? agreement.build() : null;
        }

        @Override
        public final Builder agreement(DescribedAgreement agreement) {
            this.agreement = agreement;
            return this;
        }

        @Override
        public DescribeAgreementResponse build() {
            return new DescribeAgreementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
