/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * a structure that contains details for the web app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedWebApp implements SdkPojo, Serializable, ToCopyableBuilder<ListedWebApp.Builder, ListedWebApp> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ListedWebApp::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> WEB_APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppId").getter(getter(ListedWebApp::webAppId)).setter(setter(Builder::webAppId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppId").build()).build();

    private static final SdkField<String> ACCESS_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccessEndpoint").getter(getter(ListedWebApp::accessEndpoint)).setter(setter(Builder::accessEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoint").build()).build();

    private static final SdkField<String> WEB_APP_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebAppEndpoint").getter(getter(ListedWebApp::webAppEndpoint)).setter(setter(Builder::webAppEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebAppEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WEB_APP_ID_FIELD,
            ACCESS_ENDPOINT_FIELD, WEB_APP_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String webAppId;

    private final String accessEndpoint;

    private final String webAppEndpoint;

    private ListedWebApp(BuilderImpl builder) {
        this.arn = builder.arn;
        this.webAppId = builder.webAppId;
        this.accessEndpoint = builder.accessEndpoint;
        this.webAppEndpoint = builder.webAppEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the web app.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the web app.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier for the web app.
     * </p>
     * 
     * @return The unique identifier for the web app.
     */
    public final String webAppId() {
        return webAppId;
    }

    /**
     * <p>
     * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the Transfer
     * Family web app. You can specify a custom URL or use the default value.
     * </p>
     * 
     * @return The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
     *         Transfer Family web app. You can specify a custom URL or use the default value.
     */
    public final String accessEndpoint() {
        return accessEndpoint;
    }

    /**
     * <p>
     * The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value that you
     * use when you configure <b>Origins</b> on CloudFront.
     * </p>
     * 
     * @return The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value
     *         that you use when you configure <b>Origins</b> on CloudFront.
     */
    public final String webAppEndpoint() {
        return webAppEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(webAppId());
        hashCode = 31 * hashCode + Objects.hashCode(accessEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(webAppEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedWebApp)) {
            return false;
        }
        ListedWebApp other = (ListedWebApp) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(webAppId(), other.webAppId())
                && Objects.equals(accessEndpoint(), other.accessEndpoint())
                && Objects.equals(webAppEndpoint(), other.webAppEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListedWebApp").add("Arn", arn()).add("WebAppId", webAppId())
                .add("AccessEndpoint", accessEndpoint()).add("WebAppEndpoint", webAppEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "WebAppId":
            return Optional.ofNullable(clazz.cast(webAppId()));
        case "AccessEndpoint":
            return Optional.ofNullable(clazz.cast(accessEndpoint()));
        case "WebAppEndpoint":
            return Optional.ofNullable(clazz.cast(webAppEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("WebAppId", WEB_APP_ID_FIELD);
        map.put("AccessEndpoint", ACCESS_ENDPOINT_FIELD);
        map.put("WebAppEndpoint", WEB_APP_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListedWebApp, T> g) {
        return obj -> g.apply((ListedWebApp) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedWebApp> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the web app.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier for the web app.
         * </p>
         * 
         * @param webAppId
         *        The unique identifier for the web app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppId(String webAppId);

        /**
         * <p>
         * The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with the
         * Transfer Family web app. You can specify a custom URL or use the default value.
         * </p>
         * 
         * @param accessEndpoint
         *        The <code>AccessEndpoint</code> is the URL that you provide to your users for them to interact with
         *        the Transfer Family web app. You can specify a custom URL or use the default value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessEndpoint(String accessEndpoint);

        /**
         * <p>
         * The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value that
         * you use when you configure <b>Origins</b> on CloudFront.
         * </p>
         * 
         * @param webAppEndpoint
         *        The <code>WebAppEndpoint</code> is the unique URL for your Transfer Family web app. This is the value
         *        that you use when you configure <b>Origins</b> on CloudFront.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppEndpoint(String webAppEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String webAppId;

        private String accessEndpoint;

        private String webAppEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedWebApp model) {
            arn(model.arn);
            webAppId(model.webAppId);
            accessEndpoint(model.accessEndpoint);
            webAppEndpoint(model.webAppEndpoint);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWebAppId() {
            return webAppId;
        }

        public final void setWebAppId(String webAppId) {
            this.webAppId = webAppId;
        }

        @Override
        public final Builder webAppId(String webAppId) {
            this.webAppId = webAppId;
            return this;
        }

        public final String getAccessEndpoint() {
            return accessEndpoint;
        }

        public final void setAccessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
        }

        @Override
        public final Builder accessEndpoint(String accessEndpoint) {
            this.accessEndpoint = accessEndpoint;
            return this;
        }

        public final String getWebAppEndpoint() {
            return webAppEndpoint;
        }

        public final void setWebAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
        }

        @Override
        public final Builder webAppEndpoint(String webAppEndpoint) {
            this.webAppEndpoint = webAppEndpoint;
            return this;
        }

        @Override
        public ListedWebApp build() {
            return new ListedWebApp(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
