/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describe the properties of the server that was specified. Information returned includes: the server Amazon Resource
 * Name (ARN), the authentication configuration and type, the logging role, server Id and state, and assigned tags or
 * metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedServer implements SdkPojo, Serializable, ToCopyableBuilder<DescribedServer.Builder, DescribedServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField
            .<EndpointDetails> builder(MarshallingType.SDK_POJO).getter(getter(DescribedServer::endpointDetails))
            .setter(setter(Builder::endpointDetails)).constructor(EndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::endpointTypeAsString)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<IdentityProviderDetails> builder(MarshallingType.SDK_POJO).getter(getter(DescribedServer::identityProviderDetails))
            .setter(setter(Builder::identityProviderDetails)).constructor(IdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::identityProviderTypeAsString)).setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build())
            .build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedServer::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribedServer::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribedServer::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ENDPOINT_DETAILS_FIELD, ENDPOINT_TYPE_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_TYPE_FIELD,
            LOGGING_ROLE_FIELD, SERVER_ID_FIELD, STATE_FIELD, TAGS_FIELD, USER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final EndpointDetails endpointDetails;

    private final String endpointType;

    private final IdentityProviderDetails identityProviderDetails;

    private final String identityProviderType;

    private final String loggingRole;

    private final String serverId;

    private final String state;

    private final List<Tag> tags;

    private final Integer userCount;

    private DescribedServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderType = builder.identityProviderType;
        this.loggingRole = builder.loggingRole;
        this.serverId = builder.serverId;
        this.state = builder.state;
        this.tags = builder.tags;
        this.userCount = builder.userCount;
    }

    /**
     * <p>
     * Specifies the unique Amazon Resource Name (ARN) for the server to be described.
     * </p>
     * 
     * @return Specifies the unique Amazon Resource Name (ARN) for the server to be described.
     */
    public String arn() {
        return arn;
    }

    /**
     * Returns the value of the EndpointDetails property for this object.
     * 
     * @return The value of the EndpointDetails property for this object.
     */
    public EndpointDetails endpointDetails() {
        return endpointDetails;
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * Specifies information to call a customer-supplied authentication API. This field is not populated when the
     * <code>IdentityProviderType</code> of the server is <code>SERVICE_MANAGED</code>&gt;.
     * </p>
     * 
     * @return Specifies information to call a customer-supplied authentication API. This field is not populated when
     *         the <code>IdentityProviderType</code> of the server is <code>SERVICE_MANAGED</code>&gt;.
     */
    public IdentityProviderDetails identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * This property defines the mode of authentication method enabled for this service. A value of
     * <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user credentials
     * within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an API Gateway
     * endpoint that will be invoked for authenticating your user into the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return This property defines the mode of authentication method enabled for this service. A value of
     *         <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user
     *         credentials within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an
     *         API Gateway endpoint that will be invoked for authenticating your user into the service.
     * @see IdentityProviderType
     */
    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * This property defines the mode of authentication method enabled for this service. A value of
     * <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user credentials
     * within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an API Gateway
     * endpoint that will be invoked for authenticating your user into the service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return This property defines the mode of authentication method enabled for this service. A value of
     *         <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user
     *         credentials within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an
     *         API Gateway endpoint that will be invoked for authenticating your user into the service.
     * @see IdentityProviderType
     */
    public String identityProviderTypeAsString() {
        return identityProviderType;
    }

    /**
     * <p>
     * This property is an AWS Identity and Access Management (IAM) entity that allows the server to turn on Amazon
     * CloudWatch logging for Amazon S3 events. When set, user activity can be view in your CloudWatch logs.
     * </p>
     * 
     * @return This property is an AWS Identity and Access Management (IAM) entity that allows the server to turn on
     *         Amazon CloudWatch logging for Amazon S3 events. When set, user activity can be view in your CloudWatch
     *         logs.
     */
    public String loggingRole() {
        return loggingRole;
    }

    /**
     * <p>
     * This property is a unique system assigned identifier for the SFTP server that you instantiate.
     * </p>
     * 
     * @return This property is a unique system assigned identifier for the SFTP server that you instantiate.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code> indicates that
     * the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the
     * server cannot perform file transfer operations.
     * </p>
     * <p>
     * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
     * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
     * <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code>
     *         indicates that the server can accept jobs and transfer files. A <code>State</code> value of
     *         <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
     *         <p>
     *         The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
     *         intermediate state, either not fully able to respond, or not fully offline. The values of
     *         <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
     * @see State
     */
    public State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code> indicates that
     * the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means that the
     * server cannot perform file transfer operations.
     * </p>
     * <p>
     * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
     * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
     * <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code>
     *         indicates that the server can accept jobs and transfer files. A <code>State</code> value of
     *         <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
     *         <p>
     *         The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
     *         intermediate state, either not fully able to respond, or not fully offline. The values of
     *         <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
     * @see State
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * This property contains the key-value pairs that you can use to search for and group servers that were assigned to
     * the server that was described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This property contains the key-value pairs that you can use to search for and group servers that were
     *         assigned to the server that was described.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The number of users that are assigned to the SFTP server you specified with the <code>ServerId</code>.
     * </p>
     * 
     * @return The number of users that are assigned to the SFTP server you specified with the <code>ServerId</code>.
     */
    public Integer userCount() {
        return userCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedServer)) {
            return false;
        }
        DescribedServer other = (DescribedServer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(endpointDetails(), other.endpointDetails())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString())
                && Objects.equals(loggingRole(), other.loggingRole()) && Objects.equals(serverId(), other.serverId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(tags(), other.tags())
                && Objects.equals(userCount(), other.userCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribedServer").add("Arn", arn()).add("EndpointDetails", endpointDetails())
                .add("EndpointType", endpointTypeAsString()).add("IdentityProviderDetails", identityProviderDetails())
                .add("IdentityProviderType", identityProviderTypeAsString()).add("LoggingRole", loggingRole())
                .add("ServerId", serverId()).add("State", stateAsString()).add("Tags", tags()).add("UserCount", userCount())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "EndpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "IdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "IdentityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedServer, T> g) {
        return obj -> g.apply((DescribedServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedServer> {
        /**
         * <p>
         * Specifies the unique Amazon Resource Name (ARN) for the server to be described.
         * </p>
         * 
         * @param arn
         *        Specifies the unique Amazon Resource Name (ARN) for the server to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * @param endpointDetails
         *        The new value for the EndpointDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails endpointDetails);

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointDetails.Builder} avoiding the need to
         * create one manually via {@link EndpointDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointDetails(EndpointDetails)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on {@link EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(EndpointDetails)
         */
        default Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return endpointDetails(EndpointDetails.builder().applyMutation(endpointDetails).build());
        }

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * Specifies information to call a customer-supplied authentication API. This field is not populated when the
         * <code>IdentityProviderType</code> of the server is <code>SERVICE_MANAGED</code>&gt;.
         * </p>
         * 
         * @param identityProviderDetails
         *        Specifies information to call a customer-supplied authentication API. This field is not populated when
         *        the <code>IdentityProviderType</code> of the server is <code>SERVICE_MANAGED</code>&gt;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails);

        /**
         * <p>
         * Specifies information to call a customer-supplied authentication API. This field is not populated when the
         * <code>IdentityProviderType</code> of the server is <code>SERVICE_MANAGED</code>&gt;.
         * </p>
         * This is a convenience that creates an instance of the {@link IdentityProviderDetails.Builder} avoiding the
         * need to create one manually via {@link IdentityProviderDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityProviderDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #identityProviderDetails(IdentityProviderDetails)}.
         * 
         * @param identityProviderDetails
         *        a consumer that will call methods on {@link IdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderDetails(IdentityProviderDetails)
         */
        default Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return identityProviderDetails(IdentityProviderDetails.builder().applyMutation(identityProviderDetails).build());
        }

        /**
         * <p>
         * This property defines the mode of authentication method enabled for this service. A value of
         * <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user credentials
         * within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an API Gateway
         * endpoint that will be invoked for authenticating your user into the service.
         * </p>
         * 
         * @param identityProviderType
         *        This property defines the mode of authentication method enabled for this service. A value of
         *        <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user
         *        credentials within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated
         *        an API Gateway endpoint that will be invoked for authenticating your user into the service.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * This property defines the mode of authentication method enabled for this service. A value of
         * <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user credentials
         * within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated an API Gateway
         * endpoint that will be invoked for authenticating your user into the service.
         * </p>
         * 
         * @param identityProviderType
         *        This property defines the mode of authentication method enabled for this service. A value of
         *        <code>SERVICE_MANAGED</code>, means that you are using this Server to store and access SFTP user
         *        credentials within the service. A value of <code>API_GATEWAY</code> indicates that you have integrated
         *        an API Gateway endpoint that will be invoked for authenticating your user into the service.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        /**
         * <p>
         * This property is an AWS Identity and Access Management (IAM) entity that allows the server to turn on Amazon
         * CloudWatch logging for Amazon S3 events. When set, user activity can be view in your CloudWatch logs.
         * </p>
         * 
         * @param loggingRole
         *        This property is an AWS Identity and Access Management (IAM) entity that allows the server to turn on
         *        Amazon CloudWatch logging for Amazon S3 events. When set, user activity can be view in your CloudWatch
         *        logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * This property is a unique system assigned identifier for the SFTP server that you instantiate.
         * </p>
         * 
         * @param serverId
         *        This property is a unique system assigned identifier for the SFTP server that you instantiate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code> indicates
         * that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means
         * that the server cannot perform file transfer operations.
         * </p>
         * <p>
         * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
         * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
         * <code>STOP_FAILED</code> can indicate an error condition.
         * </p>
         * 
         * @param state
         *        The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code>
         *        indicates that the server can accept jobs and transfer files. A <code>State</code> value of
         *        <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
         *        <p>
         *        The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
         *        intermediate state, either not fully able to respond, or not fully offline. The values of
         *        <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code> indicates
         * that the server can accept jobs and transfer files. A <code>State</code> value of <code>OFFLINE</code> means
         * that the server cannot perform file transfer operations.
         * </p>
         * <p>
         * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
         * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
         * <code>STOP_FAILED</code> can indicate an error condition.
         * </p>
         * 
         * @param state
         *        The condition of the SFTP server for the server that was described. A value of <code>ONLINE</code>
         *        indicates that the server can accept jobs and transfer files. A <code>State</code> value of
         *        <code>OFFLINE</code> means that the server cannot perform file transfer operations.</p>
         *        <p>
         *        The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
         *        intermediate state, either not fully able to respond, or not fully offline. The values of
         *        <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * This property contains the key-value pairs that you can use to search for and group servers that were
         * assigned to the server that was described.
         * </p>
         * 
         * @param tags
         *        This property contains the key-value pairs that you can use to search for and group servers that were
         *        assigned to the server that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * This property contains the key-value pairs that you can use to search for and group servers that were
         * assigned to the server that was described.
         * </p>
         * 
         * @param tags
         *        This property contains the key-value pairs that you can use to search for and group servers that were
         *        assigned to the server that was described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * This property contains the key-value pairs that you can use to search for and group servers that were
         * assigned to the server that was described.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The number of users that are assigned to the SFTP server you specified with the <code>ServerId</code>.
         * </p>
         * 
         * @param userCount
         *        The number of users that are assigned to the SFTP server you specified with the <code>ServerId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private EndpointDetails endpointDetails;

        private String endpointType;

        private IdentityProviderDetails identityProviderDetails;

        private String identityProviderType;

        private String loggingRole;

        private String serverId;

        private String state;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private Integer userCount;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedServer model) {
            arn(model.arn);
            endpointDetails(model.endpointDetails);
            endpointType(model.endpointType);
            identityProviderDetails(model.identityProviderDetails);
            identityProviderType(model.identityProviderType);
            loggingRole(model.loggingRole);
            serverId(model.serverId);
            state(model.state);
            tags(model.tags);
            userCount(model.userCount);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return endpointDetails != null ? endpointDetails.toBuilder() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        public final String getEndpointTypeAsString() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return identityProviderDetails != null ? identityProviderDetails.toBuilder() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        public final String getIdentityProviderTypeAsString() {
            return identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final Integer getUserCount() {
            return userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public DescribedServer build() {
            return new DescribedServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
