/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateUserRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateUserRequest.Builder, UpdateUserRequest> {
    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateUserRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOME_DIRECTORY_FIELD,
            POLICY_FIELD, ROLE_FIELD, SERVER_ID_FIELD, USER_NAME_FIELD));

    private final String homeDirectory;

    private final String policy;

    private final String role;

    private final String serverId;

    private final String userName;

    private UpdateUserRequest(BuilderImpl builder) {
        super(builder);
        this.homeDirectory = builder.homeDirectory;
        this.policy = builder.policy;
        this.role = builder.role;
        this.serverId = builder.serverId;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * The HomeDirectory parameter specifies the landing directory (folder) for a user when they log in to the server
     * using their client. An example would be: <code>/home/<i>username</i> </code>.
     * </p>
     * 
     * @return The HomeDirectory parameter specifies the landing directory (folder) for a user when they log in to the
     *         server using their client. An example would be: <code>/home/<i>username</i> </code>.
     */
    public String homeDirectory() {
        return homeDirectory;
    }

    /**
     * <p>
     * Allows you to supply a scope-down policy for your user so you can use the same AWS Identity and Access Management
     * (IAM) role across multiple users. The policy scopes down users access to portions of your Amazon S3 bucket.
     * Variables you can use inside this policy include <code>${Transfer:UserName}</code>,
     * <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.
     * </p>
     * 
     * @return Allows you to supply a scope-down policy for your user so you can use the same AWS Identity and Access
     *         Management (IAM) role across multiple users. The policy scopes down users access to portions of your
     *         Amazon S3 bucket. Variables you can use inside this policy include <code>${Transfer:UserName}</code>,
     *         <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * The IAM role that controls your user's access to your Amazon S3 bucket. The policies attached to this role will
     * determine the level of access you want to provide your users when transferring files into and out of your Amazon
     * S3 bucket or buckets. The IAM role should also contain a trust relationship that allows the Secure File Transfer
     * Protocol (SFTP) server to access your resources when servicing your SFTP user's transfer requests.
     * </p>
     * 
     * @return The IAM role that controls your user's access to your Amazon S3 bucket. The policies attached to this
     *         role will determine the level of access you want to provide your users when transferring files into and
     *         out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship that
     *         allows the Secure File Transfer Protocol (SFTP) server to access your resources when servicing your SFTP
     *         user's transfer requests.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     * </p>
     * 
     * @return A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * A unique string that identifies a user and is associated with a server as specified by the ServerId. This is the
     * string that will be used by your user when they log in to your SFTP server.
     * </p>
     * 
     * @return A unique string that identifies a user and is associated with a server as specified by the ServerId. This
     *         is the string that will be used by your user when they log in to your SFTP server.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateUserRequest)) {
            return false;
        }
        UpdateUserRequest other = (UpdateUserRequest) obj;
        return Objects.equals(homeDirectory(), other.homeDirectory()) && Objects.equals(policy(), other.policy())
                && Objects.equals(role(), other.role()) && Objects.equals(serverId(), other.serverId())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateUserRequest").add("HomeDirectory", homeDirectory()).add("Policy", policy())
                .add("Role", role()).add("ServerId", serverId()).add("UserName", userName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateUserRequest, T> g) {
        return obj -> g.apply((UpdateUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateUserRequest> {
        /**
         * <p>
         * The HomeDirectory parameter specifies the landing directory (folder) for a user when they log in to the
         * server using their client. An example would be: <code>/home/<i>username</i> </code>.
         * </p>
         * 
         * @param homeDirectory
         *        The HomeDirectory parameter specifies the landing directory (folder) for a user when they log in to
         *        the server using their client. An example would be: <code>/home/<i>username</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * Allows you to supply a scope-down policy for your user so you can use the same AWS Identity and Access
         * Management (IAM) role across multiple users. The policy scopes down users access to portions of your Amazon
         * S3 bucket. Variables you can use inside this policy include <code>${Transfer:UserName}</code>,
         * <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.
         * </p>
         * 
         * @param policy
         *        Allows you to supply a scope-down policy for your user so you can use the same AWS Identity and Access
         *        Management (IAM) role across multiple users. The policy scopes down users access to portions of your
         *        Amazon S3 bucket. Variables you can use inside this policy include <code>${Transfer:UserName}</code>,
         *        <code>${Transfer:HomeDirectory}</code>, and <code>${Transfer:HomeBucket}</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * The IAM role that controls your user's access to your Amazon S3 bucket. The policies attached to this role
         * will determine the level of access you want to provide your users when transferring files into and out of
         * your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship that allows the
         * Secure File Transfer Protocol (SFTP) server to access your resources when servicing your SFTP user's transfer
         * requests.
         * </p>
         * 
         * @param role
         *        The IAM role that controls your user's access to your Amazon S3 bucket. The policies attached to this
         *        role will determine the level of access you want to provide your users when transferring files into
         *        and out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship
         *        that allows the Secure File Transfer Protocol (SFTP) server to access your resources when servicing
         *        your SFTP user's transfer requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * A unique string that identifies a user and is associated with a server as specified by the ServerId. This is
         * the string that will be used by your user when they log in to your SFTP server.
         * </p>
         * 
         * @param userName
         *        A unique string that identifies a user and is associated with a server as specified by the ServerId.
         *        This is the string that will be used by your user when they log in to your SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private String homeDirectory;

        private String policy;

        private String role;

        private String serverId;

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateUserRequest model) {
            super(model);
            homeDirectory(model.homeDirectory);
            policy(model.policy);
            role(model.role);
            serverId(model.serverId);
            userName(model.userName);
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateUserRequest build() {
            return new UpdateUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
