/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns properties of the server that was specified.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListedServer implements SdkPojo, Serializable, ToCopyableBuilder<ListedServer.Builder, ListedServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::identityProviderTypeAsString)).setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build())
            .build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::endpointTypeAsString)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListedServer::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<Integer> USER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ListedServer::userCount)).setter(setter(Builder::userCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ARN_FIELD, IDENTITY_PROVIDER_TYPE_FIELD, ENDPOINT_TYPE_FIELD, LOGGING_ROLE_FIELD, SERVER_ID_FIELD,
                    STATE_FIELD, USER_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String identityProviderType;

    private final String endpointType;

    private final String loggingRole;

    private final String serverId;

    private final String state;

    private final Integer userCount;

    private ListedServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.identityProviderType = builder.identityProviderType;
        this.endpointType = builder.endpointType;
        this.loggingRole = builder.loggingRole;
        this.serverId = builder.serverId;
        this.state = builder.state;
        this.userCount = builder.userCount;
    }

    /**
     * <p>
     * The unique Amazon Resource Name (ARN) for the server to be listed.
     * </p>
     * 
     * @return The unique Amazon Resource Name (ARN) for the server to be listed.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The authentication method used to validate a user for the server that was specified. listed. This can include
     * Secure Shell (SSH), user name and password combinations, or your own custom authentication method. Valid values
     * include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The authentication method used to validate a user for the server that was specified. listed. This can
     *         include Secure Shell (SSH), user name and password combinations, or your own custom authentication
     *         method. Valid values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
     * @see IdentityProviderType
     */
    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The authentication method used to validate a user for the server that was specified. listed. This can include
     * Secure Shell (SSH), user name and password combinations, or your own custom authentication method. Valid values
     * include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The authentication method used to validate a user for the server that was specified. listed. This can
     *         include Secure Shell (SSH), user name and password combinations, or your own custom authentication
     *         method. Valid values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
     * @see IdentityProviderType
     */
    public String identityProviderTypeAsString() {
        return identityProviderType;
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The AWS Identity and Access Management entity that allows the server to turn on Amazon CloudWatch logging.
     * </p>
     * 
     * @return The AWS Identity and Access Management entity that allows the server to turn on Amazon CloudWatch
     *         logging.
     */
    public String loggingRole() {
        return loggingRole;
    }

    /**
     * <p>
     * This value is the unique system assigned identifier for the SFTP servers that were listed.
     * </p>
     * 
     * @return This value is the unique system assigned identifier for the SFTP servers that were listed.
     */
    public String serverId() {
        return serverId;
    }

    /**
     * <p>
     * This property describes the condition of the SFTP server for the server that was described. A value of
     * <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A <code>State</code> value
     * of <code>OFFLINE</code> means that the server cannot perform file transfer operations.
     * </p>
     * <p>
     * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
     * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
     * <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This property describes the condition of the SFTP server for the server that was described. A value of
     *         <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A
     *         <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer
     *         operations.</p>
     *         <p>
     *         The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
     *         intermediate state, either not fully able to respond, or not fully offline. The values of
     *         <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
     * @see State
     */
    public State state() {
        return State.fromValue(state);
    }

    /**
     * <p>
     * This property describes the condition of the SFTP server for the server that was described. A value of
     * <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A <code>State</code> value
     * of <code>OFFLINE</code> means that the server cannot perform file transfer operations.
     * </p>
     * <p>
     * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
     * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
     * <code>STOP_FAILED</code> can indicate an error condition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link State#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This property describes the condition of the SFTP server for the server that was described. A value of
     *         <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A
     *         <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer
     *         operations.</p>
     *         <p>
     *         The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
     *         intermediate state, either not fully able to respond, or not fully offline. The values of
     *         <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
     * @see State
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * This property is a numeric value that indicates the number of users that are assigned to the SFTP server you
     * specified with the <code>ServerId</code>.
     * </p>
     * 
     * @return This property is a numeric value that indicates the number of users that are assigned to the SFTP server
     *         you specified with the <code>ServerId</code>.
     */
    public Integer userCount() {
        return userCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(userCount());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListedServer)) {
            return false;
        }
        ListedServer other = (ListedServer) obj;
        return Objects.equals(arn(), other.arn())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(loggingRole(), other.loggingRole()) && Objects.equals(serverId(), other.serverId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(userCount(), other.userCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListedServer").add("Arn", arn()).add("IdentityProviderType", identityProviderTypeAsString())
                .add("EndpointType", endpointTypeAsString()).add("LoggingRole", loggingRole()).add("ServerId", serverId())
                .add("State", stateAsString()).add("UserCount", userCount()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "IdentityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "UserCount":
            return Optional.ofNullable(clazz.cast(userCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListedServer, T> g) {
        return obj -> g.apply((ListedServer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListedServer> {
        /**
         * <p>
         * The unique Amazon Resource Name (ARN) for the server to be listed.
         * </p>
         * 
         * @param arn
         *        The unique Amazon Resource Name (ARN) for the server to be listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The authentication method used to validate a user for the server that was specified. listed. This can include
         * Secure Shell (SSH), user name and password combinations, or your own custom authentication method. Valid
         * values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
         * </p>
         * 
         * @param identityProviderType
         *        The authentication method used to validate a user for the server that was specified. listed. This can
         *        include Secure Shell (SSH), user name and password combinations, or your own custom authentication
         *        method. Valid values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The authentication method used to validate a user for the server that was specified. listed. This can include
         * Secure Shell (SSH), user name and password combinations, or your own custom authentication method. Valid
         * values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
         * </p>
         * 
         * @param identityProviderType
         *        The authentication method used to validate a user for the server that was specified. listed. This can
         *        include Secure Shell (SSH), user name and password combinations, or your own custom authentication
         *        method. Valid values include <code>SERVICE_MANAGED</code> or <code>API_GATEWAY</code>.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * The AWS Identity and Access Management entity that allows the server to turn on Amazon CloudWatch logging.
         * </p>
         * 
         * @param loggingRole
         *        The AWS Identity and Access Management entity that allows the server to turn on Amazon CloudWatch
         *        logging.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * This value is the unique system assigned identifier for the SFTP servers that were listed.
         * </p>
         * 
         * @param serverId
         *        This value is the unique system assigned identifier for the SFTP servers that were listed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        /**
         * <p>
         * This property describes the condition of the SFTP server for the server that was described. A value of
         * <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A <code>State</code>
         * value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.
         * </p>
         * <p>
         * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
         * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
         * <code>STOP_FAILED</code> can indicate an error condition.
         * </p>
         * 
         * @param state
         *        This property describes the condition of the SFTP server for the server that was described. A value of
         *        <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A
         *        <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer
         *        operations.</p>
         *        <p>
         *        The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
         *        intermediate state, either not fully able to respond, or not fully offline. The values of
         *        <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(String state);

        /**
         * <p>
         * This property describes the condition of the SFTP server for the server that was described. A value of
         * <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A <code>State</code>
         * value of <code>OFFLINE</code> means that the server cannot perform file transfer operations.
         * </p>
         * <p>
         * The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an intermediate
         * state, either not fully able to respond, or not fully offline. The values of <code>START_FAILED</code> or
         * <code>STOP_FAILED</code> can indicate an error condition.
         * </p>
         * 
         * @param state
         *        This property describes the condition of the SFTP server for the server that was described. A value of
         *        <code>ONLINE</code>&gt; indicates that the server can accept jobs and transfer files. A
         *        <code>State</code> value of <code>OFFLINE</code> means that the server cannot perform file transfer
         *        operations.</p>
         *        <p>
         *        The states of <code>STARTING</code> and <code>STOPPING</code> indicated that the server is in an
         *        intermediate state, either not fully able to respond, or not fully offline. The values of
         *        <code>START_FAILED</code> or <code>STOP_FAILED</code> can indicate an error condition.
         * @see State
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see State
         */
        Builder state(State state);

        /**
         * <p>
         * This property is a numeric value that indicates the number of users that are assigned to the SFTP server you
         * specified with the <code>ServerId</code>.
         * </p>
         * 
         * @param userCount
         *        This property is a numeric value that indicates the number of users that are assigned to the SFTP
         *        server you specified with the <code>ServerId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userCount(Integer userCount);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String identityProviderType;

        private String endpointType;

        private String loggingRole;

        private String serverId;

        private String state;

        private Integer userCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ListedServer model) {
            arn(model.arn);
            identityProviderType(model.identityProviderType);
            endpointType(model.endpointType);
            loggingRole(model.loggingRole);
            serverId(model.serverId);
            state(model.state);
            userCount(model.userCount);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getIdentityProviderTypeAsString() {
            return identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getEndpointTypeAsString() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(State state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Integer getUserCount() {
            return userCount;
        }

        @Override
        public final Builder userCount(Integer userCount) {
            this.userCount = userCount;
            return this;
        }

        public final void setUserCount(Integer userCount) {
            this.userCount = userCount;
        }

        @Override
        public ListedServer build() {
            return new ListedServer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
