/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServerRequest extends TransferRequest implements
        ToCopyableBuilder<UpdateServerRequest.Builder, UpdateServerRequest> {
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField
            .<EndpointDetails> builder(MarshallingType.SDK_POJO).getter(getter(UpdateServerRequest::endpointDetails))
            .setter(setter(Builder::endpointDetails)).constructor(EndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateServerRequest::endpointTypeAsString)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<IdentityProviderDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateServerRequest::identityProviderDetails)).setter(setter(Builder::identityProviderDetails))
            .constructor(IdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build())
            .build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateServerRequest::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<String> SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateServerRequest::serverId)).setter(setter(Builder::serverId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_DETAILS_FIELD,
            ENDPOINT_TYPE_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, LOGGING_ROLE_FIELD, SERVER_ID_FIELD));

    private final EndpointDetails endpointDetails;

    private final String endpointType;

    private final IdentityProviderDetails identityProviderDetails;

    private final String loggingRole;

    private final String serverId;

    private UpdateServerRequest(BuilderImpl builder) {
        super(builder);
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.loggingRole = builder.loggingRole;
        this.serverId = builder.serverId;
    }

    /**
     * Returns the value of the EndpointDetails property for this object.
     * 
     * @return The value of the EndpointDetails property for this object.
     */
    public EndpointDetails endpointDetails() {
        return endpointDetails;
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * Returns the value of the EndpointType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The value of the EndpointType property for this object.
     * @see EndpointType
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * This response parameter is an array containing all of the information required to call a customer's
     * authentication API method.
     * </p>
     * 
     * @return This response parameter is an array containing all of the information required to call a customer's
     *         authentication API method.
     */
    public IdentityProviderDetails identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * Changes the AWS Identity and Access Management (IAM) role that allows Amazon S3 events to be logged in Amazon
     * CloudWatch, turning logging on or off.
     * </p>
     * 
     * @return Changes the AWS Identity and Access Management (IAM) role that allows Amazon S3 events to be logged in
     *         Amazon CloudWatch, turning logging on or off.
     */
    public String loggingRole() {
        return loggingRole;
    }

    /**
     * <p>
     * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     * </p>
     * 
     * @return A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
     */
    public String serverId() {
        return serverId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(serverId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServerRequest)) {
            return false;
        }
        UpdateServerRequest other = (UpdateServerRequest) obj;
        return Objects.equals(endpointDetails(), other.endpointDetails())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(loggingRole(), other.loggingRole()) && Objects.equals(serverId(), other.serverId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateServerRequest").add("EndpointDetails", endpointDetails())
                .add("EndpointType", endpointTypeAsString()).add("IdentityProviderDetails", identityProviderDetails())
                .add("LoggingRole", loggingRole()).add("ServerId", serverId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "IdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "ServerId":
            return Optional.ofNullable(clazz.cast(serverId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServerRequest, T> g) {
        return obj -> g.apply((UpdateServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateServerRequest> {
        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * @param endpointDetails
         *        The new value for the EndpointDetails property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails endpointDetails);

        /**
         * Sets the value of the EndpointDetails property for this object.
         *
         * This is a convenience that creates an instance of the {@link EndpointDetails.Builder} avoiding the need to
         * create one manually via {@link EndpointDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointDetails(EndpointDetails)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on {@link EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(EndpointDetails)
         */
        default Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return endpointDetails(EndpointDetails.builder().applyMutation(endpointDetails).build());
        }

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * Sets the value of the EndpointType property for this object.
         *
         * @param endpointType
         *        The new value for the EndpointType property for this object.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * This response parameter is an array containing all of the information required to call a customer's
         * authentication API method.
         * </p>
         * 
         * @param identityProviderDetails
         *        This response parameter is an array containing all of the information required to call a customer's
         *        authentication API method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails);

        /**
         * <p>
         * This response parameter is an array containing all of the information required to call a customer's
         * authentication API method.
         * </p>
         * This is a convenience that creates an instance of the {@link IdentityProviderDetails.Builder} avoiding the
         * need to create one manually via {@link IdentityProviderDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityProviderDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #identityProviderDetails(IdentityProviderDetails)}.
         * 
         * @param identityProviderDetails
         *        a consumer that will call methods on {@link IdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderDetails(IdentityProviderDetails)
         */
        default Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return identityProviderDetails(IdentityProviderDetails.builder().applyMutation(identityProviderDetails).build());
        }

        /**
         * <p>
         * Changes the AWS Identity and Access Management (IAM) role that allows Amazon S3 events to be logged in Amazon
         * CloudWatch, turning logging on or off.
         * </p>
         * 
         * @param loggingRole
         *        Changes the AWS Identity and Access Management (IAM) role that allows Amazon S3 events to be logged in
         *        Amazon CloudWatch, turning logging on or off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * </p>
         * 
         * @param serverId
         *        A system-assigned unique identifier for an SFTP server instance that the user account is assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverId(String serverId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private EndpointDetails endpointDetails;

        private String endpointType;

        private IdentityProviderDetails identityProviderDetails;

        private String loggingRole;

        private String serverId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServerRequest model) {
            super(model);
            endpointDetails(model.endpointDetails);
            endpointType(model.endpointType);
            identityProviderDetails(model.identityProviderDetails);
            loggingRole(model.loggingRole);
            serverId(model.serverId);
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return endpointDetails != null ? endpointDetails.toBuilder() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        public final String getEndpointTypeAsString() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return identityProviderDetails != null ? identityProviderDetails.toBuilder() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final String getServerId() {
            return serverId;
        }

        @Override
        public final Builder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        public final void setServerId(String serverId) {
            this.serverId = serverId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateServerRequest build() {
            return new UpdateServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
