/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns properties of the user that you wish to describe.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribedUser implements SdkPojo, Serializable, ToCopyableBuilder<DescribedUser.Builder, DescribedUser> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedUser::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> HOME_DIRECTORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedUser::homeDirectory)).setter(setter(Builder::homeDirectory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeDirectory").build()).build();

    private static final SdkField<String> POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedUser::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedUser::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<List<SshPublicKey>> SSH_PUBLIC_KEYS_FIELD = SdkField
            .<List<SshPublicKey>> builder(MarshallingType.LIST)
            .getter(getter(DescribedUser::sshPublicKeys))
            .setter(setter(Builder::sshPublicKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SshPublicKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(SshPublicKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(DescribedUser::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribedUser::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            HOME_DIRECTORY_FIELD, POLICY_FIELD, ROLE_FIELD, SSH_PUBLIC_KEYS_FIELD, TAGS_FIELD, USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String homeDirectory;

    private final String policy;

    private final String role;

    private final List<SshPublicKey> sshPublicKeys;

    private final List<Tag> tags;

    private final String userName;

    private DescribedUser(BuilderImpl builder) {
        this.arn = builder.arn;
        this.homeDirectory = builder.homeDirectory;
        this.policy = builder.policy;
        this.role = builder.role;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.tags = builder.tags;
        this.userName = builder.userName;
    }

    /**
     * <p>
     * This property contains the unique Amazon Resource Name (ARN) for the user that was requested to be described.
     * </p>
     * 
     * @return This property contains the unique Amazon Resource Name (ARN) for the user that was requested to be
     *         described.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * This property specifies the landing directory (or folder) which is the location that files are written to or read
     * from in an Amazon S3 bucket for the described user. An example would be:
     * <code>/<i>bucket_name</i>/home/<i>username</i> </code>.
     * </p>
     * 
     * @return This property specifies the landing directory (or folder) which is the location that files are written to
     *         or read from in an Amazon S3 bucket for the described user. An example would be:
     *         <code>/<i>bucket_name</i>/home/<i>username</i> </code>.
     */
    public String homeDirectory() {
        return homeDirectory;
    }

    /**
     * <p>
     * Specifies the name of the policy in use for the described user.
     * </p>
     * 
     * @return Specifies the name of the policy in use for the described user.
     */
    public String policy() {
        return policy;
    }

    /**
     * <p>
     * This property specifies the IAM role that controls your user's access to your Amazon S3 bucket. The policies
     * attached to this role will determine the level of access you want to provide your users when transferring files
     * into and out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship that
     * allows the SFTP server to access your resources when servicing your SFTP user's transfer requests.
     * </p>
     * 
     * @return This property specifies the IAM role that controls your user's access to your Amazon S3 bucket. The
     *         policies attached to this role will determine the level of access you want to provide your users when
     *         transferring files into and out of your Amazon S3 bucket or buckets. The IAM role should also contain a
     *         trust relationship that allows the SFTP server to access your resources when servicing your SFTP user's
     *         transfer requests.
     */
    public String role() {
        return role;
    }

    /**
     * <p>
     * This property contains the public key portion of the Secure Shell (SSH) keys stored for the described user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This property contains the public key portion of the Secure Shell (SSH) keys stored for the described
     *         user.
     */
    public List<SshPublicKey> sshPublicKeys() {
        return sshPublicKeys;
    }

    /**
     * <p>
     * This property contains the key-value pairs for the user requested. Tag can be used to search for and group users
     * for a variety of purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return This property contains the key-value pairs for the user requested. Tag can be used to search for and
     *         group users for a variety of purposes.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * This property is the name of the user that was requested to be described. User names are used for authentication
     * purposes. This is the string that will be used by your user when they log in to your SFTP server.
     * </p>
     * 
     * @return This property is the name of the user that was requested to be described. User names are used for
     *         authentication purposes. This is the string that will be used by your user when they log in to your SFTP
     *         server.
     */
    public String userName() {
        return userName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(homeDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribedUser)) {
            return false;
        }
        DescribedUser other = (DescribedUser) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(homeDirectory(), other.homeDirectory())
                && Objects.equals(policy(), other.policy()) && Objects.equals(role(), other.role())
                && Objects.equals(sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(tags(), other.tags())
                && Objects.equals(userName(), other.userName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribedUser").add("Arn", arn()).add("HomeDirectory", homeDirectory()).add("Policy", policy())
                .add("Role", role()).add("SshPublicKeys", sshPublicKeys()).add("Tags", tags()).add("UserName", userName())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "HomeDirectory":
            return Optional.ofNullable(clazz.cast(homeDirectory()));
        case "Policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SshPublicKeys":
            return Optional.ofNullable(clazz.cast(sshPublicKeys()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribedUser, T> g) {
        return obj -> g.apply((DescribedUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DescribedUser> {
        /**
         * <p>
         * This property contains the unique Amazon Resource Name (ARN) for the user that was requested to be described.
         * </p>
         * 
         * @param arn
         *        This property contains the unique Amazon Resource Name (ARN) for the user that was requested to be
         *        described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * This property specifies the landing directory (or folder) which is the location that files are written to or
         * read from in an Amazon S3 bucket for the described user. An example would be:
         * <code>/<i>bucket_name</i>/home/<i>username</i> </code>.
         * </p>
         * 
         * @param homeDirectory
         *        This property specifies the landing directory (or folder) which is the location that files are written
         *        to or read from in an Amazon S3 bucket for the described user. An example would be:
         *        <code>/<i>bucket_name</i>/home/<i>username</i> </code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homeDirectory(String homeDirectory);

        /**
         * <p>
         * Specifies the name of the policy in use for the described user.
         * </p>
         * 
         * @param policy
         *        Specifies the name of the policy in use for the described user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(String policy);

        /**
         * <p>
         * This property specifies the IAM role that controls your user's access to your Amazon S3 bucket. The policies
         * attached to this role will determine the level of access you want to provide your users when transferring
         * files into and out of your Amazon S3 bucket or buckets. The IAM role should also contain a trust relationship
         * that allows the SFTP server to access your resources when servicing your SFTP user's transfer requests.
         * </p>
         * 
         * @param role
         *        This property specifies the IAM role that controls your user's access to your Amazon S3 bucket. The
         *        policies attached to this role will determine the level of access you want to provide your users when
         *        transferring files into and out of your Amazon S3 bucket or buckets. The IAM role should also contain
         *        a trust relationship that allows the SFTP server to access your resources when servicing your SFTP
         *        user's transfer requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * This property contains the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * 
         * @param sshPublicKeys
         *        This property contains the public key portion of the Secure Shell (SSH) keys stored for the described
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(Collection<SshPublicKey> sshPublicKeys);

        /**
         * <p>
         * This property contains the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * 
         * @param sshPublicKeys
         *        This property contains the public key portion of the Secure Shell (SSH) keys stored for the described
         *        user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeys(SshPublicKey... sshPublicKeys);

        /**
         * <p>
         * This property contains the public key portion of the Secure Shell (SSH) keys stored for the described user.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SshPublicKey>.Builder} avoiding the need to
         * create one manually via {@link List<SshPublicKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SshPublicKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #sshPublicKeys(List<SshPublicKey>)}.
         * 
         * @param sshPublicKeys
         *        a consumer that will call methods on {@link List<SshPublicKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sshPublicKeys(List<SshPublicKey>)
         */
        Builder sshPublicKeys(Consumer<SshPublicKey.Builder>... sshPublicKeys);

        /**
         * <p>
         * This property contains the key-value pairs for the user requested. Tag can be used to search for and group
         * users for a variety of purposes.
         * </p>
         * 
         * @param tags
         *        This property contains the key-value pairs for the user requested. Tag can be used to search for and
         *        group users for a variety of purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * This property contains the key-value pairs for the user requested. Tag can be used to search for and group
         * users for a variety of purposes.
         * </p>
         * 
         * @param tags
         *        This property contains the key-value pairs for the user requested. Tag can be used to search for and
         *        group users for a variety of purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * This property contains the key-value pairs for the user requested. Tag can be used to search for and group
         * users for a variety of purposes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * This property is the name of the user that was requested to be described. User names are used for
         * authentication purposes. This is the string that will be used by your user when they log in to your SFTP
         * server.
         * </p>
         * 
         * @param userName
         *        This property is the name of the user that was requested to be described. User names are used for
         *        authentication purposes. This is the string that will be used by your user when they log in to your
         *        SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String homeDirectory;

        private String policy;

        private String role;

        private List<SshPublicKey> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String userName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribedUser model) {
            arn(model.arn);
            homeDirectory(model.homeDirectory);
            policy(model.policy);
            role(model.role);
            sshPublicKeys(model.sshPublicKeys);
            tags(model.tags);
            userName(model.userName);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getHomeDirectory() {
            return homeDirectory;
        }

        @Override
        public final Builder homeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
            return this;
        }

        public final void setHomeDirectory(String homeDirectory) {
            this.homeDirectory = homeDirectory;
        }

        public final String getPolicy() {
            return policy;
        }

        @Override
        public final Builder policy(String policy) {
            this.policy = policy;
            return this;
        }

        public final void setPolicy(String policy) {
            this.policy = policy;
        }

        public final String getRole() {
            return role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        public final Collection<SshPublicKey.Builder> getSshPublicKeys() {
            return sshPublicKeys != null ? sshPublicKeys.stream().map(SshPublicKey::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SshPublicKey> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SshPublicKey... sshPublicKeys) {
            sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(Consumer<SshPublicKey.Builder>... sshPublicKeys) {
            sshPublicKeys(Stream.of(sshPublicKeys).map(c -> SshPublicKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSshPublicKeys(Collection<SshPublicKey.BuilderImpl> sshPublicKeys) {
            this.sshPublicKeys = SshPublicKeysCopier.copyFromBuilder(sshPublicKeys);
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        public DescribedUser build() {
            return new DescribedUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
