/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateServerRequest extends TransferRequest implements
        ToCopyableBuilder<CreateServerRequest.Builder, CreateServerRequest> {
    private static final SdkField<EndpointDetails> ENDPOINT_DETAILS_FIELD = SdkField
            .<EndpointDetails> builder(MarshallingType.SDK_POJO).getter(getter(CreateServerRequest::endpointDetails))
            .setter(setter(Builder::endpointDetails)).constructor(EndpointDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointDetails").build()).build();

    private static final SdkField<String> ENDPOINT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::endpointTypeAsString)).setter(setter(Builder::endpointType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointType").build()).build();

    private static final SdkField<String> HOST_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::hostKey)).setter(setter(Builder::hostKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostKey").build()).build();

    private static final SdkField<IdentityProviderDetails> IDENTITY_PROVIDER_DETAILS_FIELD = SdkField
            .<IdentityProviderDetails> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateServerRequest::identityProviderDetails)).setter(setter(Builder::identityProviderDetails))
            .constructor(IdentityProviderDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderDetails").build())
            .build();

    private static final SdkField<String> IDENTITY_PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::identityProviderTypeAsString)).setter(setter(Builder::identityProviderType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityProviderType").build())
            .build();

    private static final SdkField<String> LOGGING_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateServerRequest::loggingRole)).setter(setter(Builder::loggingRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingRole").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .getter(getter(CreateServerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_DETAILS_FIELD,
            ENDPOINT_TYPE_FIELD, HOST_KEY_FIELD, IDENTITY_PROVIDER_DETAILS_FIELD, IDENTITY_PROVIDER_TYPE_FIELD,
            LOGGING_ROLE_FIELD, TAGS_FIELD));

    private final EndpointDetails endpointDetails;

    private final String endpointType;

    private final String hostKey;

    private final IdentityProviderDetails identityProviderDetails;

    private final String identityProviderType;

    private final String loggingRole;

    private final List<Tag> tags;

    private CreateServerRequest(BuilderImpl builder) {
        super(builder);
        this.endpointDetails = builder.endpointDetails;
        this.endpointType = builder.endpointType;
        this.hostKey = builder.hostKey;
        this.identityProviderDetails = builder.identityProviderDetails;
        this.identityProviderType = builder.identityProviderType;
        this.loggingRole = builder.loggingRole;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server.
     * </p>
     * 
     * @return The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server.
     */
    public EndpointDetails endpointDetails() {
        return endpointDetails;
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint, your SFTP
     * server isn't accessible over the public internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint,
     *         your SFTP server isn't accessible over the public internet.
     * @see EndpointType
     */
    public EndpointType endpointType() {
        return EndpointType.fromValue(endpointType);
    }

    /**
     * <p>
     * The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint, your SFTP
     * server isn't accessible over the public internet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointType} will
     * return {@link EndpointType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #endpointTypeAsString}.
     * </p>
     * 
     * @return The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint,
     *         your SFTP server isn't accessible over the public internet.
     * @see EndpointType
     */
    public String endpointTypeAsString() {
        return endpointType;
    }

    /**
     * <p>
     * The RSA private key as generated by <code>ssh-keygen -N "" -f my-new-server-key</code> command.
     * </p>
     * <important>
     * <p>
     * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
     * update the host key. Accidentally changing a server's host key can be disruptive. For more information, see
     * <a>change-host-key</a> in the <i>AWS SFTP User Guide.</i>
     * </p>
     * </important>
     * 
     * @return The RSA private key as generated by <code>ssh-keygen -N "" -f my-new-server-key</code> command.</p>
     *         <important>
     *         <p>
     *         If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server,
     *         don't update the host key. Accidentally changing a server's host key can be disruptive. For more
     *         information, see <a>change-host-key</a> in the <i>AWS SFTP User Guide.</i>
     *         </p>
     */
    public String hostKey() {
        return hostKey;
    }

    /**
     * <p>
     * An array containing all of the information required to call a customer-supplied authentication API. This
     * parameter is not required when the <code>IdentityProviderType</code> value of server that is created uses the
     * <code>SERVICE_MANAGED</code> authentication method.
     * </p>
     * 
     * @return An array containing all of the information required to call a customer-supplied authentication API. This
     *         parameter is not required when the <code>IdentityProviderType</code> value of server that is created uses
     *         the <code>SERVICE_MANAGED</code> authentication method.
     */
    public IdentityProviderDetails identityProviderDetails() {
        return identityProviderDetails;
    }

    /**
     * <p>
     * The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>, which
     * allows you to store and access SFTP user credentials within the service. An <code>IdentityProviderType</code>
     * value of <code>API_GATEWAY</code> indicates that user authentication requires a call to an API Gateway endpoint
     * URL provided by you to integrate an identity provider of your choice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>,
     *         which allows you to store and access SFTP user credentials within the service. An
     *         <code>IdentityProviderType</code> value of <code>API_GATEWAY</code> indicates that user authentication
     *         requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your
     *         choice.
     * @see IdentityProviderType
     */
    public IdentityProviderType identityProviderType() {
        return IdentityProviderType.fromValue(identityProviderType);
    }

    /**
     * <p>
     * The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>, which
     * allows you to store and access SFTP user credentials within the service. An <code>IdentityProviderType</code>
     * value of <code>API_GATEWAY</code> indicates that user authentication requires a call to an API Gateway endpoint
     * URL provided by you to integrate an identity provider of your choice.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #identityProviderType} will return {@link IdentityProviderType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #identityProviderTypeAsString}.
     * </p>
     * 
     * @return The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>,
     *         which allows you to store and access SFTP user credentials within the service. An
     *         <code>IdentityProviderType</code> value of <code>API_GATEWAY</code> indicates that user authentication
     *         requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of your
     *         choice.
     * @see IdentityProviderType
     */
    public String identityProviderTypeAsString() {
        return identityProviderType;
    }

    /**
     * <p>
     * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for monitoring
     * and auditing purposes.
     * </p>
     * 
     * @return A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
     *         monitoring and auditing purposes.
     */
    public String loggingRole() {
        return loggingRole;
    }

    /**
     * <p>
     * Key-value pairs that can be used to group and search for servers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Key-value pairs that can be used to group and search for servers.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointDetails());
        hashCode = 31 * hashCode + Objects.hashCode(endpointTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostKey());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderDetails());
        hashCode = 31 * hashCode + Objects.hashCode(identityProviderTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(loggingRole());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateServerRequest)) {
            return false;
        }
        CreateServerRequest other = (CreateServerRequest) obj;
        return Objects.equals(endpointDetails(), other.endpointDetails())
                && Objects.equals(endpointTypeAsString(), other.endpointTypeAsString())
                && Objects.equals(hostKey(), other.hostKey())
                && Objects.equals(identityProviderDetails(), other.identityProviderDetails())
                && Objects.equals(identityProviderTypeAsString(), other.identityProviderTypeAsString())
                && Objects.equals(loggingRole(), other.loggingRole()) && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateServerRequest").add("EndpointDetails", endpointDetails())
                .add("EndpointType", endpointTypeAsString()).add("HostKey", hostKey())
                .add("IdentityProviderDetails", identityProviderDetails())
                .add("IdentityProviderType", identityProviderTypeAsString()).add("LoggingRole", loggingRole())
                .add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointDetails":
            return Optional.ofNullable(clazz.cast(endpointDetails()));
        case "EndpointType":
            return Optional.ofNullable(clazz.cast(endpointTypeAsString()));
        case "HostKey":
            return Optional.ofNullable(clazz.cast(hostKey()));
        case "IdentityProviderDetails":
            return Optional.ofNullable(clazz.cast(identityProviderDetails()));
        case "IdentityProviderType":
            return Optional.ofNullable(clazz.cast(identityProviderTypeAsString()));
        case "LoggingRole":
            return Optional.ofNullable(clazz.cast(loggingRole()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateServerRequest, T> g) {
        return obj -> g.apply((CreateServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TransferRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateServerRequest> {
        /**
         * <p>
         * The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server.
         * </p>
         * 
         * @param endpointDetails
         *        The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointDetails(EndpointDetails endpointDetails);

        /**
         * <p>
         * The virtual private cloud (VPC) endpoint settings that you want to configure for your SFTP server.
         * </p>
         * This is a convenience that creates an instance of the {@link EndpointDetails.Builder} avoiding the need to
         * create one manually via {@link EndpointDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link EndpointDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointDetails(EndpointDetails)}.
         * 
         * @param endpointDetails
         *        a consumer that will call methods on {@link EndpointDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointDetails(EndpointDetails)
         */
        default Builder endpointDetails(Consumer<EndpointDetails.Builder> endpointDetails) {
            return endpointDetails(EndpointDetails.builder().applyMutation(endpointDetails).build());
        }

        /**
         * <p>
         * The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint, your
         * SFTP server isn't accessible over the public internet.
         * </p>
         * 
         * @param endpointType
         *        The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint,
         *        your SFTP server isn't accessible over the public internet.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(String endpointType);

        /**
         * <p>
         * The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint, your
         * SFTP server isn't accessible over the public internet.
         * </p>
         * 
         * @param endpointType
         *        The type of VPC endpoint that you want your SFTP server connect to. If you connect to a VPC endpoint,
         *        your SFTP server isn't accessible over the public internet.
         * @see EndpointType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointType
         */
        Builder endpointType(EndpointType endpointType);

        /**
         * <p>
         * The RSA private key as generated by <code>ssh-keygen -N "" -f my-new-server-key</code> command.
         * </p>
         * <important>
         * <p>
         * If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP server, don't
         * update the host key. Accidentally changing a server's host key can be disruptive. For more information, see
         * <a>change-host-key</a> in the <i>AWS SFTP User Guide.</i>
         * </p>
         * </important>
         * 
         * @param hostKey
         *        The RSA private key as generated by <code>ssh-keygen -N "" -f my-new-server-key</code> command.</p>
         *        <important>
         *        <p>
         *        If you aren't planning to migrate existing users from an existing SFTP server to a new AWS SFTP
         *        server, don't update the host key. Accidentally changing a server's host key can be disruptive. For
         *        more information, see <a>change-host-key</a> in the <i>AWS SFTP User Guide.</i>
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostKey(String hostKey);

        /**
         * <p>
         * An array containing all of the information required to call a customer-supplied authentication API. This
         * parameter is not required when the <code>IdentityProviderType</code> value of server that is created uses the
         * <code>SERVICE_MANAGED</code> authentication method.
         * </p>
         * 
         * @param identityProviderDetails
         *        An array containing all of the information required to call a customer-supplied authentication API.
         *        This parameter is not required when the <code>IdentityProviderType</code> value of server that is
         *        created uses the <code>SERVICE_MANAGED</code> authentication method.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails);

        /**
         * <p>
         * An array containing all of the information required to call a customer-supplied authentication API. This
         * parameter is not required when the <code>IdentityProviderType</code> value of server that is created uses the
         * <code>SERVICE_MANAGED</code> authentication method.
         * </p>
         * This is a convenience that creates an instance of the {@link IdentityProviderDetails.Builder} avoiding the
         * need to create one manually via {@link IdentityProviderDetails#builder()}.
         *
         * When the {@link Consumer} completes, {@link IdentityProviderDetails.Builder#build()} is called immediately
         * and its result is passed to {@link #identityProviderDetails(IdentityProviderDetails)}.
         * 
         * @param identityProviderDetails
         *        a consumer that will call methods on {@link IdentityProviderDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityProviderDetails(IdentityProviderDetails)
         */
        default Builder identityProviderDetails(Consumer<IdentityProviderDetails.Builder> identityProviderDetails) {
            return identityProviderDetails(IdentityProviderDetails.builder().applyMutation(identityProviderDetails).build());
        }

        /**
         * <p>
         * The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>, which
         * allows you to store and access SFTP user credentials within the service. An <code>IdentityProviderType</code>
         * value of <code>API_GATEWAY</code> indicates that user authentication requires a call to an API Gateway
         * endpoint URL provided by you to integrate an identity provider of your choice.
         * </p>
         * 
         * @param identityProviderType
         *        The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>
         *        , which allows you to store and access SFTP user credentials within the service. An
         *        <code>IdentityProviderType</code> value of <code>API_GATEWAY</code> indicates that user authentication
         *        requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of
         *        your choice.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(String identityProviderType);

        /**
         * <p>
         * The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>, which
         * allows you to store and access SFTP user credentials within the service. An <code>IdentityProviderType</code>
         * value of <code>API_GATEWAY</code> indicates that user authentication requires a call to an API Gateway
         * endpoint URL provided by you to integrate an identity provider of your choice.
         * </p>
         * 
         * @param identityProviderType
         *        The mode of authentication enabled for this service. The default value is <code>SERVICE_MANAGED</code>
         *        , which allows you to store and access SFTP user credentials within the service. An
         *        <code>IdentityProviderType</code> value of <code>API_GATEWAY</code> indicates that user authentication
         *        requires a call to an API Gateway endpoint URL provided by you to integrate an identity provider of
         *        your choice.
         * @see IdentityProviderType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityProviderType
         */
        Builder identityProviderType(IdentityProviderType identityProviderType);

        /**
         * <p>
         * A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
         * monitoring and auditing purposes.
         * </p>
         * 
         * @param loggingRole
         *        A value that allows the service to write your SFTP users' activity to your Amazon CloudWatch logs for
         *        monitoring and auditing purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingRole(String loggingRole);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for servers.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for servers.
         * </p>
         * 
         * @param tags
         *        Key-value pairs that can be used to group and search for servers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Key-value pairs that can be used to group and search for servers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TransferRequest.BuilderImpl implements Builder {
        private EndpointDetails endpointDetails;

        private String endpointType;

        private String hostKey;

        private IdentityProviderDetails identityProviderDetails;

        private String identityProviderType;

        private String loggingRole;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateServerRequest model) {
            super(model);
            endpointDetails(model.endpointDetails);
            endpointType(model.endpointType);
            hostKey(model.hostKey);
            identityProviderDetails(model.identityProviderDetails);
            identityProviderType(model.identityProviderType);
            loggingRole(model.loggingRole);
            tags(model.tags);
        }

        public final EndpointDetails.Builder getEndpointDetails() {
            return endpointDetails != null ? endpointDetails.toBuilder() : null;
        }

        @Override
        public final Builder endpointDetails(EndpointDetails endpointDetails) {
            this.endpointDetails = endpointDetails;
            return this;
        }

        public final void setEndpointDetails(EndpointDetails.BuilderImpl endpointDetails) {
            this.endpointDetails = endpointDetails != null ? endpointDetails.build() : null;
        }

        public final String getEndpointTypeAsString() {
            return endpointType;
        }

        @Override
        public final Builder endpointType(String endpointType) {
            this.endpointType = endpointType;
            return this;
        }

        @Override
        public final Builder endpointType(EndpointType endpointType) {
            this.endpointType(endpointType.toString());
            return this;
        }

        public final void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public final String getHostKey() {
            return hostKey;
        }

        @Override
        public final Builder hostKey(String hostKey) {
            this.hostKey = hostKey;
            return this;
        }

        public final void setHostKey(String hostKey) {
            this.hostKey = hostKey;
        }

        public final IdentityProviderDetails.Builder getIdentityProviderDetails() {
            return identityProviderDetails != null ? identityProviderDetails.toBuilder() : null;
        }

        @Override
        public final Builder identityProviderDetails(IdentityProviderDetails identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails;
            return this;
        }

        public final void setIdentityProviderDetails(IdentityProviderDetails.BuilderImpl identityProviderDetails) {
            this.identityProviderDetails = identityProviderDetails != null ? identityProviderDetails.build() : null;
        }

        public final String getIdentityProviderTypeAsString() {
            return identityProviderType;
        }

        @Override
        public final Builder identityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
            return this;
        }

        @Override
        public final Builder identityProviderType(IdentityProviderType identityProviderType) {
            this.identityProviderType(identityProviderType.toString());
            return this;
        }

        public final void setIdentityProviderType(String identityProviderType) {
            this.identityProviderType = identityProviderType;
        }

        public final String getLoggingRole() {
            return loggingRole;
        }

        @Override
        public final Builder loggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
            return this;
        }

        public final void setLoggingRole(String loggingRole) {
            this.loggingRole = loggingRole;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateServerRequest build() {
            return new CreateServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
