/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.transfer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the public Secure Shell (SSH) key that is associated with a user account for a specific
 * server (as identified by <code>ServerId</code>). The information returned includes the date the key was imported, the
 * public key contents, and the public key ID. A user can store more than one SSH public key associated with their user
 * name on a specific SFTP server.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SshPublicKey implements SdkPojo, Serializable, ToCopyableBuilder<SshPublicKey.Builder, SshPublicKey> {
    private static final SdkField<Instant> DATE_IMPORTED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(SshPublicKey::dateImported)).setter(setter(Builder::dateImported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateImported").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SshPublicKey::sshPublicKeyBody)).setter(setter(Builder::sshPublicKeyBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyBody").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SshPublicKey::sshPublicKeyId)).setter(setter(Builder::sshPublicKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKeyId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_IMPORTED_FIELD,
            SSH_PUBLIC_KEY_BODY_FIELD, SSH_PUBLIC_KEY_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant dateImported;

    private final String sshPublicKeyBody;

    private final String sshPublicKeyId;

    private SshPublicKey(BuilderImpl builder) {
        this.dateImported = builder.dateImported;
        this.sshPublicKeyBody = builder.sshPublicKeyBody;
        this.sshPublicKeyId = builder.sshPublicKeyId;
    }

    /**
     * <p>
     * The date that the public key was added to the user account.
     * </p>
     * 
     * @return The date that the public key was added to the user account.
     */
    public Instant dateImported() {
        return dateImported;
    }

    /**
     * <p>
     * The content of the SSH public key as specified by the <code>PublicKeyId</code>.
     * </p>
     * 
     * @return The content of the SSH public key as specified by the <code>PublicKeyId</code>.
     */
    public String sshPublicKeyBody() {
        return sshPublicKeyBody;
    }

    /**
     * <p>
     * The <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
     * </p>
     * 
     * @return The <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
     */
    public String sshPublicKeyId() {
        return sshPublicKeyId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dateImported());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyBody());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKeyId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SshPublicKey)) {
            return false;
        }
        SshPublicKey other = (SshPublicKey) obj;
        return Objects.equals(dateImported(), other.dateImported())
                && Objects.equals(sshPublicKeyBody(), other.sshPublicKeyBody())
                && Objects.equals(sshPublicKeyId(), other.sshPublicKeyId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SshPublicKey").add("DateImported", dateImported()).add("SshPublicKeyBody", sshPublicKeyBody())
                .add("SshPublicKeyId", sshPublicKeyId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DateImported":
            return Optional.ofNullable(clazz.cast(dateImported()));
        case "SshPublicKeyBody":
            return Optional.ofNullable(clazz.cast(sshPublicKeyBody()));
        case "SshPublicKeyId":
            return Optional.ofNullable(clazz.cast(sshPublicKeyId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SshPublicKey, T> g) {
        return obj -> g.apply((SshPublicKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SshPublicKey> {
        /**
         * <p>
         * The date that the public key was added to the user account.
         * </p>
         * 
         * @param dateImported
         *        The date that the public key was added to the user account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateImported(Instant dateImported);

        /**
         * <p>
         * The content of the SSH public key as specified by the <code>PublicKeyId</code>.
         * </p>
         * 
         * @param sshPublicKeyBody
         *        The content of the SSH public key as specified by the <code>PublicKeyId</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyBody(String sshPublicKeyBody);

        /**
         * <p>
         * The <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
         * </p>
         * 
         * @param sshPublicKeyId
         *        The <code>SshPublicKeyId</code> parameter contains the identifier of the public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKeyId(String sshPublicKeyId);
    }

    static final class BuilderImpl implements Builder {
        private Instant dateImported;

        private String sshPublicKeyBody;

        private String sshPublicKeyId;

        private BuilderImpl() {
        }

        private BuilderImpl(SshPublicKey model) {
            dateImported(model.dateImported);
            sshPublicKeyBody(model.sshPublicKeyBody);
            sshPublicKeyId(model.sshPublicKeyId);
        }

        public final Instant getDateImported() {
            return dateImported;
        }

        @Override
        public final Builder dateImported(Instant dateImported) {
            this.dateImported = dateImported;
            return this;
        }

        public final void setDateImported(Instant dateImported) {
            this.dateImported = dateImported;
        }

        public final String getSshPublicKeyBody() {
            return sshPublicKeyBody;
        }

        @Override
        public final Builder sshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
            return this;
        }

        public final void setSshPublicKeyBody(String sshPublicKeyBody) {
            this.sshPublicKeyBody = sshPublicKeyBody;
        }

        public final String getSshPublicKeyId() {
            return sshPublicKeyId;
        }

        @Override
        public final Builder sshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
            return this;
        }

        public final void setSshPublicKeyId(String sshPublicKeyId) {
            this.sshPublicKeyId = sshPublicKeyId;
        }

        @Override
        public SshPublicKey build() {
            return new SshPublicKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
