/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslateTextRequest extends TranslateRequest implements
        ToCopyableBuilder<TranslateTextRequest.Builder, TranslateTextRequest> {
    private final String text;

    private final String sourceLanguageCode;

    private final String targetLanguageCode;

    private TranslateTextRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    /**
     * <p>
     * The text to translate.
     * </p>
     * 
     * @return The text to translate.
     */
    public String text() {
        return text;
    }

    /**
     * <p>
     * One of the supported language codes for the source text. If the <code>TargetLanguageCode</code> is not "en", the
     * <code>SourceLanguageCode</code> must be "en".
     * </p>
     * 
     * @return One of the supported language codes for the source text. If the <code>TargetLanguageCode</code> is not
     *         "en", the <code>SourceLanguageCode</code> must be "en".
     */
    public String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * <p>
     * One of the supported language codes for the target text. If the <code>SourceLanguageCode</code> is not "en", the
     * <code>TargetLanguageCode</code> must be "en".
     * </p>
     * 
     * @return One of the supported language codes for the target text. If the <code>SourceLanguageCode</code> is not
     *         "en", the <code>TargetLanguageCode</code> must be "en".
     */
    public String targetLanguageCode() {
        return targetLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextRequest)) {
            return false;
        }
        TranslateTextRequest other = (TranslateTextRequest) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCode(), other.targetLanguageCode());
    }

    @Override
    public String toString() {
        return ToString.builder("TranslateTextRequest").add("Text", text()).add("SourceLanguageCode", sourceLanguageCode())
                .add("TargetLanguageCode", targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Text":
            return Optional.ofNullable(clazz.cast(text()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCode":
            return Optional.ofNullable(clazz.cast(targetLanguageCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends TranslateRequest.Builder, CopyableBuilder<Builder, TranslateTextRequest> {
        /**
         * <p>
         * The text to translate.
         * </p>
         * 
         * @param text
         *        The text to translate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * One of the supported language codes for the source text. If the <code>TargetLanguageCode</code> is not "en",
         * the <code>SourceLanguageCode</code> must be "en".
         * </p>
         * 
         * @param sourceLanguageCode
         *        One of the supported language codes for the source text. If the <code>TargetLanguageCode</code> is not
         *        "en", the <code>SourceLanguageCode</code> must be "en".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * One of the supported language codes for the target text. If the <code>SourceLanguageCode</code> is not "en",
         * the <code>TargetLanguageCode</code> must be "en".
         * </p>
         * 
         * @param targetLanguageCode
         *        One of the supported language codes for the target text. If the <code>SourceLanguageCode</code> is not
         *        "en", the <code>TargetLanguageCode</code> must be "en".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCode(String targetLanguageCode);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String text;

        private String sourceLanguageCode;

        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextRequest model) {
            super(model);
            text(model.text);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCode(model.targetLanguageCode);
        }

        public final String getText() {
            return text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TranslateTextRequest build() {
            return new TranslateTextRequest(this);
        }
    }
}
