/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence level is
 * acceptable for your application, you can use the language in the exception to call Amazon Translate again. For more
 * information, see the <a
 * href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a>
 * operation in the <i>Amazon Comprehend Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedLanguageLowConfidenceException extends TranslateException implements
        ToCopyableBuilder<DetectedLanguageLowConfidenceException.Builder, DetectedLanguageLowConfidenceException> {
    private final String detectedLanguageCode;

    private DetectedLanguageLowConfidenceException(BuilderImpl builder) {
        super(builder);
        this.detectedLanguageCode = builder.detectedLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * Auto detected language code from Comprehend.
     * </p>
     * 
     * @return Auto detected language code from Comprehend.
     */
    public String detectedLanguageCode() {
        return detectedLanguageCode;
    }

    public interface Builder extends CopyableBuilder<Builder, DetectedLanguageLowConfidenceException>, TranslateException.Builder {
        /**
         * <p>
         * Auto detected language code from Comprehend.
         * </p>
         * 
         * @param detectedLanguageCode
         *        Auto detected language code from Comprehend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedLanguageCode(String detectedLanguageCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends TranslateException.BuilderImpl implements Builder {
        private String detectedLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedLanguageLowConfidenceException model) {
            super(model);
            detectedLanguageCode(model.detectedLanguageCode);
        }

        public final String getDetectedLanguageCode() {
            return detectedLanguageCode;
        }

        @Override
        public final Builder detectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
            return this;
        }

        @JsonProperty("DetectedLanguageCode")
        public final void setDetectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DetectedLanguageLowConfidenceException build() {
            return new DetectedLanguageLowConfidenceException(this);
        }
    }
}
