/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslateTextResponse extends TranslateResponse implements
        ToCopyableBuilder<TranslateTextResponse.Builder, TranslateTextResponse> {
    private final String translatedText;

    private final String sourceLanguageCode;

    private final String targetLanguageCode;

    private TranslateTextResponse(BuilderImpl builder) {
        super(builder);
        this.translatedText = builder.translatedText;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    /**
     * <p>
     * The text translated into the target language.
     * </p>
     * 
     * @return The text translated into the target language.
     */
    public String translatedText() {
        return translatedText;
    }

    /**
     * <p>
     * The language code for the language of the input text.
     * </p>
     * 
     * @return The language code for the language of the input text.
     */
    public String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * <p>
     * The language code for the language of the translated text.
     * </p>
     * 
     * @return The language code for the language of the translated text.
     */
    public String targetLanguageCode() {
        return targetLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translatedText());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResponse)) {
            return false;
        }
        TranslateTextResponse other = (TranslateTextResponse) obj;
        return Objects.equals(translatedText(), other.translatedText())
                && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCode(), other.targetLanguageCode());
    }

    @Override
    public String toString() {
        return ToString.builder("TranslateTextResponse").add("TranslatedText", translatedText())
                .add("SourceLanguageCode", sourceLanguageCode()).add("TargetLanguageCode", targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TranslatedText":
            return Optional.ofNullable(clazz.cast(translatedText()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCode":
            return Optional.ofNullable(clazz.cast(targetLanguageCode()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends TranslateResponse.Builder, CopyableBuilder<Builder, TranslateTextResponse> {
        /**
         * <p>
         * The text translated into the target language.
         * </p>
         * 
         * @param translatedText
         *        The text translated into the target language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translatedText(String translatedText);

        /**
         * <p>
         * The language code for the language of the input text.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code for the language of the input text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The language code for the language of the translated text.
         * </p>
         * 
         * @param targetLanguageCode
         *        The language code for the language of the translated text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCode(String targetLanguageCode);
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private String translatedText;

        private String sourceLanguageCode;

        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextResponse model) {
            super(model);
            translatedText(model.translatedText);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCode(model.targetLanguageCode);
        }

        public final String getTranslatedText() {
            return translatedText;
        }

        @Override
        public final Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            return this;
        }

        public final void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public TranslateTextResponse build() {
            return new TranslateTextResponse(this);
        }
    }
}
