/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TranslateTextResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, TranslateTextResponse> {
    private final String translatedText;
    private final String sourceLanguageCode;
    private final String targetLanguageCode;

    private TranslateTextResponse(BuilderImpl builder) {
        super(builder);
        this.translatedText = builder.translatedText;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    public String translatedText() {
        return this.translatedText;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public String targetLanguageCode() {
        return this.targetLanguageCode;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translatedText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLanguageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextResponse)) {
            return false;
        }
        TranslateTextResponse other = (TranslateTextResponse)((Object)obj);
        return Objects.equals(this.translatedText(), other.translatedText()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && Objects.equals(this.targetLanguageCode(), other.targetLanguageCode());
    }

    public String toString() {
        return ToString.builder((String)"TranslateTextResponse").add("TranslatedText", (Object)this.translatedText()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCode", (Object)this.targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TranslatedText": {
                return Optional.ofNullable(clazz.cast(this.translatedText()));
            }
            case "SourceLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCode": {
                return Optional.ofNullable(clazz.cast(this.targetLanguageCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private String translatedText;
        private String sourceLanguageCode;
        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextResponse model) {
            super(model);
            this.translatedText(model.translatedText);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCode(model.targetLanguageCode);
        }

        public final String getTranslatedText() {
            return this.translatedText;
        }

        @Override
        public final Builder translatedText(String translatedText) {
            this.translatedText = translatedText;
            return this;
        }

        public final void setTranslatedText(String translatedText) {
            this.translatedText = translatedText;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public TranslateTextResponse build() {
            return new TranslateTextResponse(this);
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    CopyableBuilder<Builder, TranslateTextResponse> {
        public Builder translatedText(String var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCode(String var1);
    }
}

