/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.translate.model.TranslateRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TranslateTextRequest
extends TranslateRequest
implements ToCopyableBuilder<Builder, TranslateTextRequest> {
    private final String text;
    private final String sourceLanguageCode;
    private final String targetLanguageCode;

    private TranslateTextRequest(BuilderImpl builder) {
        super(builder);
        this.text = builder.text;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCode = builder.targetLanguageCode;
    }

    public String text() {
        return this.text;
    }

    public String sourceLanguageCode() {
        return this.sourceLanguageCode;
    }

    public String targetLanguageCode() {
        return this.targetLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLanguageCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslateTextRequest)) {
            return false;
        }
        TranslateTextRequest other = (TranslateTextRequest)((Object)obj);
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.sourceLanguageCode(), other.sourceLanguageCode()) && Objects.equals(this.targetLanguageCode(), other.targetLanguageCode());
    }

    public String toString() {
        return ToString.builder((String)"TranslateTextRequest").add("Text", (Object)this.text()).add("SourceLanguageCode", (Object)this.sourceLanguageCode()).add("TargetLanguageCode", (Object)this.targetLanguageCode()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Text": {
                return Optional.of(clazz.cast(this.text()));
            }
            case "SourceLanguageCode": {
                return Optional.of(clazz.cast(this.sourceLanguageCode()));
            }
            case "TargetLanguageCode": {
                return Optional.of(clazz.cast(this.targetLanguageCode()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends TranslateRequest.BuilderImpl
    implements Builder {
        private String text;
        private String sourceLanguageCode;
        private String targetLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslateTextRequest model) {
            this.text(model.text);
            this.sourceLanguageCode(model.sourceLanguageCode);
            this.targetLanguageCode(model.targetLanguageCode);
        }

        public final String getText() {
            return this.text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final void setText(String text) {
            this.text = text;
        }

        public final String getSourceLanguageCode() {
            return this.sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final String getTargetLanguageCode() {
            return this.targetLanguageCode;
        }

        @Override
        public final Builder targetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
            return this;
        }

        public final void setTargetLanguageCode(String targetLanguageCode) {
            this.targetLanguageCode = targetLanguageCode;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public TranslateTextRequest build() {
            return new TranslateTextRequest(this);
        }
    }

    public static interface Builder
    extends TranslateRequest.Builder,
    CopyableBuilder<Builder, TranslateTextRequest> {
        public Builder text(String var1);

        public Builder sourceLanguageCode(String var1);

        public Builder targetLanguageCode(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

