/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties of the custom terminology.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminologyProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<TerminologyProperties.Builder, TerminologyProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TerminologyProperties::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TerminologyProperties::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TerminologyProperties::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TerminologyProperties::sourceLanguageCode)).setter(setter(Builder::sourceLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build())
            .build();

    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(TerminologyProperties::targetLanguageCodes))
            .setter(setter(Builder::targetLanguageCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EncryptionKey> ENCRYPTION_KEY_FIELD = SdkField
            .<EncryptionKey> builder(MarshallingType.SDK_POJO).getter(getter(TerminologyProperties::encryptionKey))
            .setter(setter(Builder::encryptionKey)).constructor(EncryptionKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<Integer> SIZE_BYTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TerminologyProperties::sizeBytes)).setter(setter(Builder::sizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeBytes").build()).build();

    private static final SdkField<Integer> TERM_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(TerminologyProperties::termCount)).setter(setter(Builder::termCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TermCount").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TerminologyProperties::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(TerminologyProperties::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            ARN_FIELD, SOURCE_LANGUAGE_CODE_FIELD, TARGET_LANGUAGE_CODES_FIELD, ENCRYPTION_KEY_FIELD, SIZE_BYTES_FIELD,
            TERM_COUNT_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String arn;

    private final String sourceLanguageCode;

    private final List<String> targetLanguageCodes;

    private final EncryptionKey encryptionKey;

    private final Integer sizeBytes;

    private final Integer termCount;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private TerminologyProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.arn = builder.arn;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.encryptionKey = builder.encryptionKey;
        this.sizeBytes = builder.sizeBytes;
        this.termCount = builder.termCount;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    /**
     * <p>
     * The name of the custom terminology.
     * </p>
     * 
     * @return The name of the custom terminology.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the custom terminology properties.
     * </p>
     * 
     * @return The description of the custom terminology properties.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the custom terminology.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the custom terminology.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The language code for the source text of the translation request for which the custom terminology is being used.
     * </p>
     * 
     * @return The language code for the source text of the translation request for which the custom terminology is
     *         being used.
     */
    public String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * Returns true if the TargetLanguageCodes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetLanguageCodes() {
        return targetLanguageCodes != null && !(targetLanguageCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The language codes for the target languages available with the custom terminology file. All possible target
     * languages are returned in array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetLanguageCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The language codes for the target languages available with the custom terminology file. All possible
     *         target languages are returned in array.
     */
    public List<String> targetLanguageCodes() {
        return targetLanguageCodes;
    }

    /**
     * <p>
     * The encryption key for the custom terminology.
     * </p>
     * 
     * @return The encryption key for the custom terminology.
     */
    public EncryptionKey encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * The size of the file used when importing a custom terminology.
     * </p>
     * 
     * @return The size of the file used when importing a custom terminology.
     */
    public Integer sizeBytes() {
        return sizeBytes;
    }

    /**
     * <p>
     * The number of terms included in the custom terminology.
     * </p>
     * 
     * @return The number of terms included in the custom terminology.
     */
    public Integer termCount() {
        return termCount;
    }

    /**
     * <p>
     * The time at which the custom terminology was created, based on the timestamp.
     * </p>
     * 
     * @return The time at which the custom terminology was created, based on the timestamp.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The time at which the custom terminology was last update, based on the timestamp.
     * </p>
     * 
     * @return The time at which the custom terminology was last update, based on the timestamp.
     */
    public Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCodes());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(sizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(termCount());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyProperties)) {
            return false;
        }
        TerminologyProperties other = (TerminologyProperties) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(arn(), other.arn()) && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCodes(), other.targetLanguageCodes())
                && Objects.equals(encryptionKey(), other.encryptionKey()) && Objects.equals(sizeBytes(), other.sizeBytes())
                && Objects.equals(termCount(), other.termCount()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminologyProperties").add("Name", name()).add("Description", description()).add("Arn", arn())
                .add("SourceLanguageCode", sourceLanguageCode()).add("TargetLanguageCodes", targetLanguageCodes())
                .add("EncryptionKey", encryptionKey()).add("SizeBytes", sizeBytes()).add("TermCount", termCount())
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCodes":
            return Optional.ofNullable(clazz.cast(targetLanguageCodes()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "SizeBytes":
            return Optional.ofNullable(clazz.cast(sizeBytes()));
        case "TermCount":
            return Optional.ofNullable(clazz.cast(termCount()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminologyProperties, T> g) {
        return obj -> g.apply((TerminologyProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerminologyProperties> {
        /**
         * <p>
         * The name of the custom terminology.
         * </p>
         * 
         * @param name
         *        The name of the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the custom terminology properties.
         * </p>
         * 
         * @param description
         *        The description of the custom terminology properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the custom terminology.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The language code for the source text of the translation request for which the custom terminology is being
         * used.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code for the source text of the translation request for which the custom terminology is
         *        being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The language codes for the target languages available with the custom terminology file. All possible target
         * languages are returned in array.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The language codes for the target languages available with the custom terminology file. All possible
         *        target languages are returned in array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(Collection<String> targetLanguageCodes);

        /**
         * <p>
         * The language codes for the target languages available with the custom terminology file. All possible target
         * languages are returned in array.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The language codes for the target languages available with the custom terminology file. All possible
         *        target languages are returned in array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(String... targetLanguageCodes);

        /**
         * <p>
         * The encryption key for the custom terminology.
         * </p>
         * 
         * @param encryptionKey
         *        The encryption key for the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(EncryptionKey encryptionKey);

        /**
         * <p>
         * The encryption key for the custom terminology.
         * </p>
         * This is a convenience that creates an instance of the {@link EncryptionKey.Builder} avoiding the need to
         * create one manually via {@link EncryptionKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link EncryptionKey.Builder#build()} is called immediately and its
         * result is passed to {@link #encryptionKey(EncryptionKey)}.
         * 
         * @param encryptionKey
         *        a consumer that will call methods on {@link EncryptionKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionKey(EncryptionKey)
         */
        default Builder encryptionKey(Consumer<EncryptionKey.Builder> encryptionKey) {
            return encryptionKey(EncryptionKey.builder().applyMutation(encryptionKey).build());
        }

        /**
         * <p>
         * The size of the file used when importing a custom terminology.
         * </p>
         * 
         * @param sizeBytes
         *        The size of the file used when importing a custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sizeBytes(Integer sizeBytes);

        /**
         * <p>
         * The number of terms included in the custom terminology.
         * </p>
         * 
         * @param termCount
         *        The number of terms included in the custom terminology.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder termCount(Integer termCount);

        /**
         * <p>
         * The time at which the custom terminology was created, based on the timestamp.
         * </p>
         * 
         * @param createdAt
         *        The time at which the custom terminology was created, based on the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The time at which the custom terminology was last update, based on the timestamp.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The time at which the custom terminology was last update, based on the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String arn;

        private String sourceLanguageCode;

        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private EncryptionKey encryptionKey;

        private Integer sizeBytes;

        private Integer termCount;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminologyProperties model) {
            name(model.name);
            description(model.description);
            arn(model.arn);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCodes(model.targetLanguageCodes);
            encryptionKey(model.encryptionKey);
            sizeBytes(model.sizeBytes);
            termCount(model.termCount);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final Collection<String> getTargetLanguageCodes() {
            return targetLanguageCodes;
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String... targetLanguageCodes) {
            targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = LanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        public final EncryptionKey.Builder getEncryptionKey() {
            return encryptionKey != null ? encryptionKey.toBuilder() : null;
        }

        @Override
        public final Builder encryptionKey(EncryptionKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(EncryptionKey.BuilderImpl encryptionKey) {
            this.encryptionKey = encryptionKey != null ? encryptionKey.build() : null;
        }

        public final Integer getSizeBytes() {
            return sizeBytes;
        }

        @Override
        public final Builder sizeBytes(Integer sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        public final void setSizeBytes(Integer sizeBytes) {
            this.sizeBytes = sizeBytes;
        }

        public final Integer getTermCount() {
            return termCount;
        }

        @Override
        public final Builder termCount(Integer termCount) {
            this.termCount = termCount;
            return this;
        }

        public final void setTermCount(Integer termCount) {
            this.termCount = termCount;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public TerminologyProperties build() {
            return new TerminologyProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
