/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartTextTranslationJobRequest extends TranslateRequest implements
        ToCopyableBuilder<StartTextTranslationJobRequest.Builder, StartTextTranslationJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTextTranslationJobRequest::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()).build();

    private static final SdkField<InputDataConfig> INPUT_DATA_CONFIG_FIELD = SdkField
            .<InputDataConfig> builder(MarshallingType.SDK_POJO).getter(getter(StartTextTranslationJobRequest::inputDataConfig))
            .setter(setter(Builder::inputDataConfig)).constructor(InputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build()).build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(StartTextTranslationJobRequest::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()).build();

    private static final SdkField<String> DATA_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTextTranslationJobRequest::dataAccessRoleArn)).setter(setter(Builder::dataAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataAccessRoleArn").build()).build();

    private static final SdkField<String> SOURCE_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartTextTranslationJobRequest::sourceLanguageCode)).setter(setter(Builder::sourceLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLanguageCode").build())
            .build();

    private static final SdkField<List<String>> TARGET_LANGUAGE_CODES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartTextTranslationJobRequest::targetLanguageCodes))
            .setter(setter(Builder::targetLanguageCodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLanguageCodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TERMINOLOGY_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(StartTextTranslationJobRequest::terminologyNames))
            .setter(setter(Builder::terminologyNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(StartTextTranslationJobRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD,
            INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, DATA_ACCESS_ROLE_ARN_FIELD, SOURCE_LANGUAGE_CODE_FIELD,
            TARGET_LANGUAGE_CODES_FIELD, TERMINOLOGY_NAMES_FIELD, CLIENT_TOKEN_FIELD));

    private final String jobName;

    private final InputDataConfig inputDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final String dataAccessRoleArn;

    private final String sourceLanguageCode;

    private final List<String> targetLanguageCodes;

    private final List<String> terminologyNames;

    private final String clientToken;

    private StartTextTranslationJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.dataAccessRoleArn = builder.dataAccessRoleArn;
        this.sourceLanguageCode = builder.sourceLanguageCode;
        this.targetLanguageCodes = builder.targetLanguageCodes;
        this.terminologyNames = builder.terminologyNames;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the batch translation job to be performed.
     * </p>
     * 
     * @return The name of the batch translation job to be performed.
     */
    public String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Specifies the format and S3 location of the input documents for the translation job.
     * </p>
     * 
     * @return Specifies the format and S3 location of the input documents for the translation job.
     */
    public InputDataConfig inputDataConfig() {
        return inputDataConfig;
    }

    /**
     * <p>
     * Specifies the S3 folder to which your job output will be saved.
     * </p>
     * 
     * @return Specifies the S3 folder to which your job output will be saved.
     */
    public OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon Translate
     * read access to your input data. For more nformation, see <a>identity-and-access-management</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
     *         Translate read access to your input data. For more nformation, see <a>identity-and-access-management</a>.
     */
    public String dataAccessRoleArn() {
        return dataAccessRoleArn;
    }

    /**
     * <p>
     * The language code of the input language. For a list of language codes, see <a>what-is-languages</a>.
     * </p>
     * <p>
     * Amazon Translate does not automatically detect a source language during batch translation jobs.
     * </p>
     * 
     * @return The language code of the input language. For a list of language codes, see <a>what-is-languages</a>.</p>
     *         <p>
     *         Amazon Translate does not automatically detect a source language during batch translation jobs.
     */
    public String sourceLanguageCode() {
        return sourceLanguageCode;
    }

    /**
     * Returns true if the TargetLanguageCodes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTargetLanguageCodes() {
        return targetLanguageCodes != null && !(targetLanguageCodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The language code of the output language.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetLanguageCodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The language code of the output language.
     */
    public List<String> targetLanguageCodes() {
        return targetLanguageCodes;
    }

    /**
     * Returns true if the TerminologyNames property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasTerminologyNames() {
        return terminologyNames != null && !(terminologyNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The name of the terminology to use in the batch translation job. For a list of available terminologies, use the
     * <a>ListTerminologies</a> operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTerminologyNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The name of the terminology to use in the batch translation job. For a list of available terminologies,
     *         use the <a>ListTerminologies</a> operation.
     */
    public List<String> terminologyNames() {
        return terminologyNames;
    }

    /**
     * <p>
     * The client token of the EC2 instance calling the request. This token is auto-generated when using the Amazon
     * Translate SDK. Otherwise, use the <a
     * href="docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> EC2
     * operation to retreive an instance's client token. For more information, see <a
     * href="docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html#client-tokens">Client
     * Tokens</a> in the EC2 User Guide.
     * </p>
     * 
     * @return The client token of the EC2 instance calling the request. This token is auto-generated when using the
     *         Amazon Translate SDK. Otherwise, use the <a
     *         href="docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a>
     *         EC2 operation to retreive an instance's client token. For more information, see <a
     *         href="docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html#client-tokens">Client
     *         Tokens</a> in the EC2 User Guide.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(dataAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLanguageCode());
        hashCode = 31 * hashCode + Objects.hashCode(targetLanguageCodes());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyNames());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTextTranslationJobRequest)) {
            return false;
        }
        StartTextTranslationJobRequest other = (StartTextTranslationJobRequest) obj;
        return Objects.equals(jobName(), other.jobName()) && Objects.equals(inputDataConfig(), other.inputDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(dataAccessRoleArn(), other.dataAccessRoleArn())
                && Objects.equals(sourceLanguageCode(), other.sourceLanguageCode())
                && Objects.equals(targetLanguageCodes(), other.targetLanguageCodes())
                && Objects.equals(terminologyNames(), other.terminologyNames())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartTextTranslationJobRequest").add("JobName", jobName())
                .add("InputDataConfig", inputDataConfig()).add("OutputDataConfig", outputDataConfig())
                .add("DataAccessRoleArn", dataAccessRoleArn()).add("SourceLanguageCode", sourceLanguageCode())
                .add("TargetLanguageCodes", targetLanguageCodes()).add("TerminologyNames", terminologyNames())
                .add("ClientToken", clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "InputDataConfig":
            return Optional.ofNullable(clazz.cast(inputDataConfig()));
        case "OutputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "DataAccessRoleArn":
            return Optional.ofNullable(clazz.cast(dataAccessRoleArn()));
        case "SourceLanguageCode":
            return Optional.ofNullable(clazz.cast(sourceLanguageCode()));
        case "TargetLanguageCodes":
            return Optional.ofNullable(clazz.cast(targetLanguageCodes()));
        case "TerminologyNames":
            return Optional.ofNullable(clazz.cast(terminologyNames()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartTextTranslationJobRequest, T> g) {
        return obj -> g.apply((StartTextTranslationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartTextTranslationJobRequest> {
        /**
         * <p>
         * The name of the batch translation job to be performed.
         * </p>
         * 
         * @param jobName
         *        The name of the batch translation job to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Specifies the format and S3 location of the input documents for the translation job.
         * </p>
         * 
         * @param inputDataConfig
         *        Specifies the format and S3 location of the input documents for the translation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputDataConfig(InputDataConfig inputDataConfig);

        /**
         * <p>
         * Specifies the format and S3 location of the input documents for the translation job.
         * </p>
         * This is a convenience that creates an instance of the {@link InputDataConfig.Builder} avoiding the need to
         * create one manually via {@link InputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link InputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #inputDataConfig(InputDataConfig)}.
         * 
         * @param inputDataConfig
         *        a consumer that will call methods on {@link InputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputDataConfig(InputDataConfig)
         */
        default Builder inputDataConfig(Consumer<InputDataConfig.Builder> inputDataConfig) {
            return inputDataConfig(InputDataConfig.builder().applyMutation(inputDataConfig).build());
        }

        /**
         * <p>
         * Specifies the S3 folder to which your job output will be saved.
         * </p>
         * 
         * @param outputDataConfig
         *        Specifies the S3 folder to which your job output will be saved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Specifies the S3 folder to which your job output will be saved.
         * </p>
         * This is a convenience that creates an instance of the {@link OutputDataConfig.Builder} avoiding the need to
         * create one manually via {@link OutputDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
         * Translate read access to your input data. For more nformation, see <a>identity-and-access-management</a>.
         * </p>
         * 
         * @param dataAccessRoleArn
         *        The Amazon Resource Name (ARN) of an AWS Identity Access and Management (IAM) role that grants Amazon
         *        Translate read access to your input data. For more nformation, see
         *        <a>identity-and-access-management</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataAccessRoleArn(String dataAccessRoleArn);

        /**
         * <p>
         * The language code of the input language. For a list of language codes, see <a>what-is-languages</a>.
         * </p>
         * <p>
         * Amazon Translate does not automatically detect a source language during batch translation jobs.
         * </p>
         * 
         * @param sourceLanguageCode
         *        The language code of the input language. For a list of language codes, see
         *        <a>what-is-languages</a>.</p>
         *        <p>
         *        Amazon Translate does not automatically detect a source language during batch translation jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLanguageCode(String sourceLanguageCode);

        /**
         * <p>
         * The language code of the output language.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The language code of the output language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(Collection<String> targetLanguageCodes);

        /**
         * <p>
         * The language code of the output language.
         * </p>
         * 
         * @param targetLanguageCodes
         *        The language code of the output language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLanguageCodes(String... targetLanguageCodes);

        /**
         * <p>
         * The name of the terminology to use in the batch translation job. For a list of available terminologies, use
         * the <a>ListTerminologies</a> operation.
         * </p>
         * 
         * @param terminologyNames
         *        The name of the terminology to use in the batch translation job. For a list of available
         *        terminologies, use the <a>ListTerminologies</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyNames(Collection<String> terminologyNames);

        /**
         * <p>
         * The name of the terminology to use in the batch translation job. For a list of available terminologies, use
         * the <a>ListTerminologies</a> operation.
         * </p>
         * 
         * @param terminologyNames
         *        The name of the terminology to use in the batch translation job. For a list of available
         *        terminologies, use the <a>ListTerminologies</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyNames(String... terminologyNames);

        /**
         * <p>
         * The client token of the EC2 instance calling the request. This token is auto-generated when using the Amazon
         * Translate SDK. Otherwise, use the <a
         * href="docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a> EC2
         * operation to retreive an instance's client token. For more information, see <a
         * href="docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html#client-tokens">Client
         * Tokens</a> in the EC2 User Guide.
         * </p>
         * 
         * @param clientToken
         *        The client token of the EC2 instance calling the request. This token is auto-generated when using the
         *        Amazon Translate SDK. Otherwise, use the <a
         *        href="docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeInstances.html">DescribeInstances</a>
         *        EC2 operation to retreive an instance's client token. For more information, see <a
         *        href="docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html#client-tokens"
         *        >Client Tokens</a> in the EC2 User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String jobName;

        private InputDataConfig inputDataConfig;

        private OutputDataConfig outputDataConfig;

        private String dataAccessRoleArn;

        private String sourceLanguageCode;

        private List<String> targetLanguageCodes = DefaultSdkAutoConstructList.getInstance();

        private List<String> terminologyNames = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(StartTextTranslationJobRequest model) {
            super(model);
            jobName(model.jobName);
            inputDataConfig(model.inputDataConfig);
            outputDataConfig(model.outputDataConfig);
            dataAccessRoleArn(model.dataAccessRoleArn);
            sourceLanguageCode(model.sourceLanguageCode);
            targetLanguageCodes(model.targetLanguageCodes);
            terminologyNames(model.terminologyNames);
            clientToken(model.clientToken);
        }

        public final String getJobName() {
            return jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        public final InputDataConfig.Builder getInputDataConfig() {
            return inputDataConfig != null ? inputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputDataConfig(InputDataConfig inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public final void setInputDataConfig(InputDataConfig.BuilderImpl inputDataConfig) {
            this.inputDataConfig = inputDataConfig != null ? inputDataConfig.build() : null;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final String getDataAccessRoleArn() {
            return dataAccessRoleArn;
        }

        @Override
        public final Builder dataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
            return this;
        }

        public final void setDataAccessRoleArn(String dataAccessRoleArn) {
            this.dataAccessRoleArn = dataAccessRoleArn;
        }

        public final String getSourceLanguageCode() {
            return sourceLanguageCode;
        }

        @Override
        public final Builder sourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
            return this;
        }

        public final void setSourceLanguageCode(String sourceLanguageCode) {
            this.sourceLanguageCode = sourceLanguageCode;
        }

        public final Collection<String> getTargetLanguageCodes() {
            return targetLanguageCodes;
        }

        @Override
        public final Builder targetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLanguageCodes(String... targetLanguageCodes) {
            targetLanguageCodes(Arrays.asList(targetLanguageCodes));
            return this;
        }

        public final void setTargetLanguageCodes(Collection<String> targetLanguageCodes) {
            this.targetLanguageCodes = TargetLanguageCodeStringListCopier.copy(targetLanguageCodes);
        }

        public final Collection<String> getTerminologyNames() {
            return terminologyNames;
        }

        @Override
        public final Builder terminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder terminologyNames(String... terminologyNames) {
            terminologyNames(Arrays.asList(terminologyNames));
            return this;
        }

        public final void setTerminologyNames(Collection<String> terminologyNames) {
            this.terminologyNames = ResourceNameListCopier.copy(terminologyNames);
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartTextTranslationJobRequest build() {
            return new StartTextTranslationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
