/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input configuration properties for requesting a batch translation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputDataConfig implements SdkPojo, Serializable, ToCopyableBuilder<InputDataConfig.Builder, InputDataConfig> {
    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Uri").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InputDataConfig::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContentType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_URI_FIELD,
            CONTENT_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3Uri;

    private final String contentType;

    private InputDataConfig(BuilderImpl builder) {
        this.s3Uri = builder.s3Uri;
        this.contentType = builder.contentType;
    }

    /**
     * <p>
     * The URI of the AWS S3 folder that contains the input file. The folder must be in the same Region as the API
     * endpoint you are calling.
     * </p>
     * 
     * @return The URI of the AWS S3 folder that contains the input file. The folder must be in the same Region as the
     *         API endpoint you are calling.
     */
    public String s3Uri() {
        return s3Uri;
    }

    /**
     * <p>
     * The multipurpose internet mail extension (MIME) type of the input files. Valid values are <code>text/plain</code>
     * for plaintext files and <code>text/html</code> for HTML files.
     * </p>
     * 
     * @return The multipurpose internet mail extension (MIME) type of the input files. Valid values are
     *         <code>text/plain</code> for plaintext files and <code>text/html</code> for HTML files.
     */
    public String contentType() {
        return contentType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputDataConfig)) {
            return false;
        }
        InputDataConfig other = (InputDataConfig) obj;
        return Objects.equals(s3Uri(), other.s3Uri()) && Objects.equals(contentType(), other.contentType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InputDataConfig").add("S3Uri", s3Uri()).add("ContentType", contentType()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        case "ContentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InputDataConfig, T> g) {
        return obj -> g.apply((InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputDataConfig> {
        /**
         * <p>
         * The URI of the AWS S3 folder that contains the input file. The folder must be in the same Region as the API
         * endpoint you are calling.
         * </p>
         * 
         * @param s3Uri
         *        The URI of the AWS S3 folder that contains the input file. The folder must be in the same Region as
         *        the API endpoint you are calling.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);

        /**
         * <p>
         * The multipurpose internet mail extension (MIME) type of the input files. Valid values are
         * <code>text/plain</code> for plaintext files and <code>text/html</code> for HTML files.
         * </p>
         * 
         * @param contentType
         *        The multipurpose internet mail extension (MIME) type of the input files. Valid values are
         *        <code>text/plain</code> for plaintext files and <code>text/html</code> for HTML files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);
    }

    static final class BuilderImpl implements Builder {
        private String s3Uri;

        private String contentType;

        private BuilderImpl() {
        }

        private BuilderImpl(InputDataConfig model) {
            s3Uri(model.s3Uri);
            contentType(model.contentType);
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public InputDataConfig build() {
            return new InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
