/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data associated with the custom terminology.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminologyData implements SdkPojo, Serializable, ToCopyableBuilder<TerminologyData.Builder, TerminologyData> {
    private static final SdkField<SdkBytes> FILE_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(TerminologyData::file)).setter(setter(Builder::file))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("File").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TerminologyData::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_FIELD, FORMAT_FIELD));

    private static final long serialVersionUID = 1L;

    private final SdkBytes file;

    private final String format;

    private TerminologyData(BuilderImpl builder) {
        this.file = builder.file;
        this.format = builder.format;
    }

    /**
     * <p>
     * The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on this
     * field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding
     * themselves.
     * </p>
     * 
     * @return The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding
     *         on this field before sending a request to the AWS service. Users of the SDK should not perform
     *         Base64-encoding themselves.
     */
    public SdkBytes file() {
        return file;
    }

    /**
     * <p>
     * The data format of the custom terminology. Either CSV or TMX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TerminologyDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The data format of the custom terminology. Either CSV or TMX.
     * @see TerminologyDataFormat
     */
    public TerminologyDataFormat format() {
        return TerminologyDataFormat.fromValue(format);
    }

    /**
     * <p>
     * The data format of the custom terminology. Either CSV or TMX.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link TerminologyDataFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #formatAsString}.
     * </p>
     * 
     * @return The data format of the custom terminology. Either CSV or TMX.
     * @see TerminologyDataFormat
     */
    public String formatAsString() {
        return format;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(file());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyData)) {
            return false;
        }
        TerminologyData other = (TerminologyData) obj;
        return Objects.equals(file(), other.file()) && Objects.equals(formatAsString(), other.formatAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("TerminologyData").add("File", file() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Format", formatAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "File":
            return Optional.ofNullable(clazz.cast(file()));
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminologyData, T> g) {
        return obj -> g.apply((TerminologyData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerminologyData> {
        /**
         * <p>
         * The file containing the custom terminology data. Your version of the AWS SDK performs a Base64-encoding on
         * this field before sending a request to the AWS service. Users of the SDK should not perform Base64-encoding
         * themselves.
         * </p>
         * 
         * @param file
         *        The file containing the custom terminology data. Your version of the AWS SDK performs a
         *        Base64-encoding on this field before sending a request to the AWS service. Users of the SDK should not
         *        perform Base64-encoding themselves.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(SdkBytes file);

        /**
         * <p>
         * The data format of the custom terminology. Either CSV or TMX.
         * </p>
         * 
         * @param format
         *        The data format of the custom terminology. Either CSV or TMX.
         * @see TerminologyDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminologyDataFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The data format of the custom terminology. Either CSV or TMX.
         * </p>
         * 
         * @param format
         *        The data format of the custom terminology. Either CSV or TMX.
         * @see TerminologyDataFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TerminologyDataFormat
         */
        Builder format(TerminologyDataFormat format);
    }

    static final class BuilderImpl implements Builder {
        private SdkBytes file;

        private String format;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminologyData model) {
            file(model.file);
            format(model.format);
        }

        public final ByteBuffer getFile() {
            return file == null ? null : file.asByteBuffer();
        }

        @Override
        public final Builder file(SdkBytes file) {
            this.file = StandardMemberCopier.copy(file);
            return this;
        }

        public final void setFile(ByteBuffer file) {
            file(file == null ? null : SdkBytes.fromByteBuffer(file));
        }

        public final String getFormatAsString() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(TerminologyDataFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public TerminologyData build() {
            return new TerminologyData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
