/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The location of the custom terminology data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TerminologyDataLocation implements SdkPojo, Serializable,
        ToCopyableBuilder<TerminologyDataLocation.Builder, TerminologyDataLocation> {
    private static final SdkField<String> REPOSITORY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RepositoryType").getter(getter(TerminologyDataLocation::repositoryType))
            .setter(setter(Builder::repositoryType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RepositoryType").build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Location").getter(getter(TerminologyDataLocation::location)).setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_TYPE_FIELD,
            LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String repositoryType;

    private final String location;

    private TerminologyDataLocation(BuilderImpl builder) {
        this.repositoryType = builder.repositoryType;
        this.location = builder.location;
    }

    /**
     * <p>
     * The repository type for the custom terminology data.
     * </p>
     * 
     * @return The repository type for the custom terminology data.
     */
    public final String repositoryType() {
        return repositoryType;
    }

    /**
     * <p>
     * The location of the custom terminology data.
     * </p>
     * 
     * @return The location of the custom terminology data.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(repositoryType());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TerminologyDataLocation)) {
            return false;
        }
        TerminologyDataLocation other = (TerminologyDataLocation) obj;
        return Objects.equals(repositoryType(), other.repositoryType()) && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TerminologyDataLocation").add("RepositoryType", repositoryType()).add("Location", location())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RepositoryType":
            return Optional.ofNullable(clazz.cast(repositoryType()));
        case "Location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TerminologyDataLocation, T> g) {
        return obj -> g.apply((TerminologyDataLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TerminologyDataLocation> {
        /**
         * <p>
         * The repository type for the custom terminology data.
         * </p>
         * 
         * @param repositoryType
         *        The repository type for the custom terminology data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryType(String repositoryType);

        /**
         * <p>
         * The location of the custom terminology data.
         * </p>
         * 
         * @param location
         *        The location of the custom terminology data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private String repositoryType;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(TerminologyDataLocation model) {
            repositoryType(model.repositoryType);
            location(model.location);
        }

        public final String getRepositoryType() {
            return repositoryType;
        }

        @Override
        public final Builder repositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
            return this;
        }

        public final void setRepositoryType(String repositoryType) {
            this.repositoryType = repositoryType;
        }

        public final String getLocation() {
            return location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public TerminologyDataLocation build() {
            return new TerminologyDataLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
