/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParallelDataRequest extends TranslateRequest implements
        ToCopyableBuilder<UpdateParallelDataRequest.Builder, UpdateParallelDataRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateParallelDataRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(UpdateParallelDataRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<ParallelDataConfig> PARALLEL_DATA_CONFIG_FIELD = SdkField
            .<ParallelDataConfig> builder(MarshallingType.SDK_POJO).memberName("ParallelDataConfig")
            .getter(getter(UpdateParallelDataRequest::parallelDataConfig)).setter(setter(Builder::parallelDataConfig))
            .constructor(ParallelDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataConfig").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(UpdateParallelDataRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            PARALLEL_DATA_CONFIG_FIELD, CLIENT_TOKEN_FIELD));

    private final String name;

    private final String description;

    private final ParallelDataConfig parallelDataConfig;

    private final String clientToken;

    private UpdateParallelDataRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.parallelDataConfig = builder.parallelDataConfig;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the parallel data resource being updated.
     * </p>
     * 
     * @return The name of the parallel data resource being updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A custom description for the parallel data resource in Amazon Translate.
     * </p>
     * 
     * @return A custom description for the parallel data resource in Amazon Translate.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies the format and S3 location of the parallel data input file.
     * </p>
     * 
     * @return Specifies the format and S3 location of the parallel data input file.
     */
    public final ParallelDataConfig parallelDataConfig() {
        return parallelDataConfig;
    }

    /**
     * <p>
     * A unique identifier for the request. This token is automatically generated when you use Amazon Translate through
     * an AWS SDK.
     * </p>
     * 
     * @return A unique identifier for the request. This token is automatically generated when you use Amazon Translate
     *         through an AWS SDK.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parallelDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParallelDataRequest)) {
            return false;
        }
        UpdateParallelDataRequest other = (UpdateParallelDataRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(parallelDataConfig(), other.parallelDataConfig())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateParallelDataRequest").add("Name", name()).add("Description", description())
                .add("ParallelDataConfig", parallelDataConfig()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ParallelDataConfig":
            return Optional.ofNullable(clazz.cast(parallelDataConfig()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParallelDataRequest, T> g) {
        return obj -> g.apply((UpdateParallelDataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateParallelDataRequest> {
        /**
         * <p>
         * The name of the parallel data resource being updated.
         * </p>
         * 
         * @param name
         *        The name of the parallel data resource being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A custom description for the parallel data resource in Amazon Translate.
         * </p>
         * 
         * @param description
         *        A custom description for the parallel data resource in Amazon Translate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the format and S3 location of the parallel data input file.
         * </p>
         * 
         * @param parallelDataConfig
         *        Specifies the format and S3 location of the parallel data input file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataConfig(ParallelDataConfig parallelDataConfig);

        /**
         * <p>
         * Specifies the format and S3 location of the parallel data input file.
         * </p>
         * This is a convenience that creates an instance of the {@link ParallelDataConfig.Builder} avoiding the need to
         * create one manually via {@link ParallelDataConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ParallelDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #parallelDataConfig(ParallelDataConfig)}.
         * 
         * @param parallelDataConfig
         *        a consumer that will call methods on {@link ParallelDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelDataConfig(ParallelDataConfig)
         */
        default Builder parallelDataConfig(Consumer<ParallelDataConfig.Builder> parallelDataConfig) {
            return parallelDataConfig(ParallelDataConfig.builder().applyMutation(parallelDataConfig).build());
        }

        /**
         * <p>
         * A unique identifier for the request. This token is automatically generated when you use Amazon Translate
         * through an AWS SDK.
         * </p>
         * 
         * @param clientToken
         *        A unique identifier for the request. This token is automatically generated when you use Amazon
         *        Translate through an AWS SDK.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends TranslateRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private ParallelDataConfig parallelDataConfig;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParallelDataRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            parallelDataConfig(model.parallelDataConfig);
            clientToken(model.clientToken);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ParallelDataConfig.Builder getParallelDataConfig() {
            return parallelDataConfig != null ? parallelDataConfig.toBuilder() : null;
        }

        public final void setParallelDataConfig(ParallelDataConfig.BuilderImpl parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig != null ? parallelDataConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder parallelDataConfig(ParallelDataConfig parallelDataConfig) {
            this.parallelDataConfig = parallelDataConfig;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        @Transient
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateParallelDataRequest build() {
            return new UpdateParallelDataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
