/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that configure the translation output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TranslationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<TranslationSettings.Builder, TranslationSettings> {
    private static final SdkField<String> PROFANITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Profanity").getter(getter(TranslationSettings::profanityAsString)).setter(setter(Builder::profanity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Profanity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFANITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String profanity;

    private TranslationSettings(BuilderImpl builder) {
        this.profanity = builder.profanity;
    }

    /**
     * <p>
     * Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your translation
     * output.
     * </p>
     * <p>
     * To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
     * 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.
     * </p>
     * <p>
     * Amazon Translate does not detect profanity in all of its supported languages. For languages that support
     * profanity detection, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages and
     * Language Codes in the Amazon Translate Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profanity} will
     * return {@link Profanity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profanityAsString}.
     * </p>
     * 
     * @return Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
     *         translation output.</p>
     *         <p>
     *         To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
     *         5-character sequence is used for each profane word or phrase, regardless of the length or number of
     *         words.
     *         </p>
     *         <p>
     *         Amazon Translate does not detect profanity in all of its supported languages. For languages that support
     *         profanity detection, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages
     *         and Language Codes in the Amazon Translate Developer Guide</a>.
     * @see Profanity
     */
    public final Profanity profanity() {
        return Profanity.fromValue(profanity);
    }

    /**
     * <p>
     * Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your translation
     * output.
     * </p>
     * <p>
     * To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
     * 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.
     * </p>
     * <p>
     * Amazon Translate does not detect profanity in all of its supported languages. For languages that support
     * profanity detection, see <a
     * href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages and
     * Language Codes in the Amazon Translate Developer Guide</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #profanity} will
     * return {@link Profanity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #profanityAsString}.
     * </p>
     * 
     * @return Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
     *         translation output.</p>
     *         <p>
     *         To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
     *         5-character sequence is used for each profane word or phrase, regardless of the length or number of
     *         words.
     *         </p>
     *         <p>
     *         Amazon Translate does not detect profanity in all of its supported languages. For languages that support
     *         profanity detection, see <a
     *         href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages
     *         and Language Codes in the Amazon Translate Developer Guide</a>.
     * @see Profanity
     */
    public final String profanityAsString() {
        return profanity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profanityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TranslationSettings)) {
            return false;
        }
        TranslationSettings other = (TranslationSettings) obj;
        return Objects.equals(profanityAsString(), other.profanityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TranslationSettings").add("Profanity", profanityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Profanity":
            return Optional.ofNullable(clazz.cast(profanityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TranslationSettings, T> g) {
        return obj -> g.apply((TranslationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TranslationSettings> {
        /**
         * <p>
         * Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
         * translation output.
         * </p>
         * <p>
         * To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
         * 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.
         * </p>
         * <p>
         * Amazon Translate does not detect profanity in all of its supported languages. For languages that support
         * profanity detection, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages and
         * Language Codes in the Amazon Translate Developer Guide</a>.
         * </p>
         * 
         * @param profanity
         *        Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
         *        translation output.</p>
         *        <p>
         *        To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“.
         *        This 5-character sequence is used for each profane word or phrase, regardless of the length or number
         *        of words.
         *        </p>
         *        <p>
         *        Amazon Translate does not detect profanity in all of its supported languages. For languages that
         *        support profanity detection, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
         *        Languages and Language Codes in the Amazon Translate Developer Guide</a>.
         * @see Profanity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profanity
         */
        Builder profanity(String profanity);

        /**
         * <p>
         * Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
         * translation output.
         * </p>
         * <p>
         * To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“. This
         * 5-character sequence is used for each profane word or phrase, regardless of the length or number of words.
         * </p>
         * <p>
         * Amazon Translate does not detect profanity in all of its supported languages. For languages that support
         * profanity detection, see <a
         * href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported Languages and
         * Language Codes in the Amazon Translate Developer Guide</a>.
         * </p>
         * 
         * @param profanity
         *        Enable the profanity setting if you want Amazon Translate to mask profane words and phrases in your
         *        translation output.</p>
         *        <p>
         *        To mask profane words and phrases, Amazon Translate replaces them with the grawlix string “?$#@$“.
         *        This 5-character sequence is used for each profane word or phrase, regardless of the length or number
         *        of words.
         *        </p>
         *        <p>
         *        Amazon Translate does not detect profanity in all of its supported languages. For languages that
         *        support profanity detection, see <a
         *        href="https://docs.aws.amazon.com/translate/latest/dg/what-is.html#what-is-languages">Supported
         *        Languages and Language Codes in the Amazon Translate Developer Guide</a>.
         * @see Profanity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Profanity
         */
        Builder profanity(Profanity profanity);
    }

    static final class BuilderImpl implements Builder {
        private String profanity;

        private BuilderImpl() {
        }

        private BuilderImpl(TranslationSettings model) {
            profanity(model.profanity);
        }

        public final String getProfanity() {
            return profanity;
        }

        public final void setProfanity(String profanity) {
            this.profanity = profanity;
        }

        @Override
        @Transient
        public final Builder profanity(String profanity) {
            this.profanity = profanity;
            return this;
        }

        @Override
        @Transient
        public final Builder profanity(Profanity profanity) {
            this.profanity(profanity == null ? null : profanity.toString());
            return this;
        }

        @Override
        public TranslationSettings build() {
            return new TranslationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
