/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTerminologyResponse extends TranslateResponse implements
        ToCopyableBuilder<GetTerminologyResponse.Builder, GetTerminologyResponse> {
    private static final SdkField<TerminologyProperties> TERMINOLOGY_PROPERTIES_FIELD = SdkField
            .<TerminologyProperties> builder(MarshallingType.SDK_POJO).memberName("TerminologyProperties")
            .getter(getter(GetTerminologyResponse::terminologyProperties)).setter(setter(Builder::terminologyProperties))
            .constructor(TerminologyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyProperties").build())
            .build();

    private static final SdkField<TerminologyDataLocation> TERMINOLOGY_DATA_LOCATION_FIELD = SdkField
            .<TerminologyDataLocation> builder(MarshallingType.SDK_POJO).memberName("TerminologyDataLocation")
            .getter(getter(GetTerminologyResponse::terminologyDataLocation)).setter(setter(Builder::terminologyDataLocation))
            .constructor(TerminologyDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TerminologyDataLocation").build())
            .build();

    private static final SdkField<TerminologyDataLocation> AUXILIARY_DATA_LOCATION_FIELD = SdkField
            .<TerminologyDataLocation> builder(MarshallingType.SDK_POJO).memberName("AuxiliaryDataLocation")
            .getter(getter(GetTerminologyResponse::auxiliaryDataLocation)).setter(setter(Builder::auxiliaryDataLocation))
            .constructor(TerminologyDataLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuxiliaryDataLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TERMINOLOGY_PROPERTIES_FIELD,
            TERMINOLOGY_DATA_LOCATION_FIELD, AUXILIARY_DATA_LOCATION_FIELD));

    private final TerminologyProperties terminologyProperties;

    private final TerminologyDataLocation terminologyDataLocation;

    private final TerminologyDataLocation auxiliaryDataLocation;

    private GetTerminologyResponse(BuilderImpl builder) {
        super(builder);
        this.terminologyProperties = builder.terminologyProperties;
        this.terminologyDataLocation = builder.terminologyDataLocation;
        this.auxiliaryDataLocation = builder.auxiliaryDataLocation;
    }

    /**
     * <p>
     * The properties of the custom terminology being retrieved.
     * </p>
     * 
     * @return The properties of the custom terminology being retrieved.
     */
    public final TerminologyProperties terminologyProperties() {
        return terminologyProperties;
    }

    /**
     * <p>
     * The Amazon S3 location of the most recent custom terminology input file that was successfully imported into
     * Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.
     * </p>
     * <important>
     * <p>
     * Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.
     * </p>
     * <p>
     * CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record
     * begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the
     * program might interpret the record as a formula and run the code within it.
     * </p>
     * <p>
     * Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.
     * </p>
     * </important>
     * 
     * @return The Amazon S3 location of the most recent custom terminology input file that was successfully imported
     *         into Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.</p>
     *         <important>
     *         <p>
     *         Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.
     *         </p>
     *         <p>
     *         CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The
     *         record begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet
     *         program, the program might interpret the record as a formula and run the code within it.
     *         </p>
     *         <p>
     *         Before you download an input file from Amazon S3, ensure that you recognize the file and trust its
     *         creator.
     *         </p>
     */
    public final TerminologyDataLocation terminologyDataLocation() {
        return terminologyDataLocation;
    }

    /**
     * <p>
     * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file. This
     * file was created when Amazon Translate attempted to create a terminology resource. The location is returned as a
     * presigned URL to that has a 30 minute expiration.
     * </p>
     * 
     * @return The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
     *         file. This file was created when Amazon Translate attempted to create a terminology resource. The
     *         location is returned as a presigned URL to that has a 30 minute expiration.
     */
    public final TerminologyDataLocation auxiliaryDataLocation() {
        return auxiliaryDataLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(terminologyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(terminologyDataLocation());
        hashCode = 31 * hashCode + Objects.hashCode(auxiliaryDataLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTerminologyResponse)) {
            return false;
        }
        GetTerminologyResponse other = (GetTerminologyResponse) obj;
        return Objects.equals(terminologyProperties(), other.terminologyProperties())
                && Objects.equals(terminologyDataLocation(), other.terminologyDataLocation())
                && Objects.equals(auxiliaryDataLocation(), other.auxiliaryDataLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTerminologyResponse").add("TerminologyProperties", terminologyProperties())
                .add("TerminologyDataLocation", terminologyDataLocation()).add("AuxiliaryDataLocation", auxiliaryDataLocation())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TerminologyProperties":
            return Optional.ofNullable(clazz.cast(terminologyProperties()));
        case "TerminologyDataLocation":
            return Optional.ofNullable(clazz.cast(terminologyDataLocation()));
        case "AuxiliaryDataLocation":
            return Optional.ofNullable(clazz.cast(auxiliaryDataLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTerminologyResponse, T> g) {
        return obj -> g.apply((GetTerminologyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTerminologyResponse> {
        /**
         * <p>
         * The properties of the custom terminology being retrieved.
         * </p>
         * 
         * @param terminologyProperties
         *        The properties of the custom terminology being retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyProperties(TerminologyProperties terminologyProperties);

        /**
         * <p>
         * The properties of the custom terminology being retrieved.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminologyProperties.Builder} avoiding the need
         * to create one manually via {@link TerminologyProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyProperties.Builder#build()} is called immediately and
         * its result is passed to {@link #terminologyProperties(TerminologyProperties)}.
         * 
         * @param terminologyProperties
         *        a consumer that will call methods on {@link TerminologyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyProperties(TerminologyProperties)
         */
        default Builder terminologyProperties(Consumer<TerminologyProperties.Builder> terminologyProperties) {
            return terminologyProperties(TerminologyProperties.builder().applyMutation(terminologyProperties).build());
        }

        /**
         * <p>
         * The Amazon S3 location of the most recent custom terminology input file that was successfully imported into
         * Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.
         * </p>
         * <important>
         * <p>
         * Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.
         * </p>
         * <p>
         * CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record
         * begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the
         * program might interpret the record as a formula and run the code within it.
         * </p>
         * <p>
         * Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.
         * </p>
         * </important>
         * 
         * @param terminologyDataLocation
         *        The Amazon S3 location of the most recent custom terminology input file that was successfully imported
         *        into Amazon Translate. The location is returned as a presigned URL that has a 30 minute
         *        expiration.</p> <important>
         *        <p>
         *        Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.
         *        </p>
         *        <p>
         *        CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The
         *        record begins with a special character, such as =, +, -, or @. When the file is opened in a
         *        spreadsheet program, the program might interpret the record as a formula and run the code within it.
         *        </p>
         *        <p>
         *        Before you download an input file from Amazon S3, ensure that you recognize the file and trust its
         *        creator.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminologyDataLocation(TerminologyDataLocation terminologyDataLocation);

        /**
         * <p>
         * The Amazon S3 location of the most recent custom terminology input file that was successfully imported into
         * Amazon Translate. The location is returned as a presigned URL that has a 30 minute expiration.
         * </p>
         * <important>
         * <p>
         * Amazon Translate doesn't scan all input files for the risk of CSV injection attacks.
         * </p>
         * <p>
         * CSV injection occurs when a .csv or .tsv file is altered so that a record contains malicious code. The record
         * begins with a special character, such as =, +, -, or @. When the file is opened in a spreadsheet program, the
         * program might interpret the record as a formula and run the code within it.
         * </p>
         * <p>
         * Before you download an input file from Amazon S3, ensure that you recognize the file and trust its creator.
         * </p>
         * </important> This is a convenience that creates an instance of the {@link TerminologyDataLocation.Builder}
         * avoiding the need to create one manually via {@link TerminologyDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #terminologyDataLocation(TerminologyDataLocation)}.
         * 
         * @param terminologyDataLocation
         *        a consumer that will call methods on {@link TerminologyDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #terminologyDataLocation(TerminologyDataLocation)
         */
        default Builder terminologyDataLocation(Consumer<TerminologyDataLocation.Builder> terminologyDataLocation) {
            return terminologyDataLocation(TerminologyDataLocation.builder().applyMutation(terminologyDataLocation).build());
        }

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a terminology resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * 
         * @param auxiliaryDataLocation
         *        The Amazon S3 location of a file that provides any errors or warnings that were produced by your input
         *        file. This file was created when Amazon Translate attempted to create a terminology resource. The
         *        location is returned as a presigned URL to that has a 30 minute expiration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder auxiliaryDataLocation(TerminologyDataLocation auxiliaryDataLocation);

        /**
         * <p>
         * The Amazon S3 location of a file that provides any errors or warnings that were produced by your input file.
         * This file was created when Amazon Translate attempted to create a terminology resource. The location is
         * returned as a presigned URL to that has a 30 minute expiration.
         * </p>
         * This is a convenience that creates an instance of the {@link TerminologyDataLocation.Builder} avoiding the
         * need to create one manually via {@link TerminologyDataLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link TerminologyDataLocation.Builder#build()} is called immediately
         * and its result is passed to {@link #auxiliaryDataLocation(TerminologyDataLocation)}.
         * 
         * @param auxiliaryDataLocation
         *        a consumer that will call methods on {@link TerminologyDataLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #auxiliaryDataLocation(TerminologyDataLocation)
         */
        default Builder auxiliaryDataLocation(Consumer<TerminologyDataLocation.Builder> auxiliaryDataLocation) {
            return auxiliaryDataLocation(TerminologyDataLocation.builder().applyMutation(auxiliaryDataLocation).build());
        }
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private TerminologyProperties terminologyProperties;

        private TerminologyDataLocation terminologyDataLocation;

        private TerminologyDataLocation auxiliaryDataLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTerminologyResponse model) {
            super(model);
            terminologyProperties(model.terminologyProperties);
            terminologyDataLocation(model.terminologyDataLocation);
            auxiliaryDataLocation(model.auxiliaryDataLocation);
        }

        public final TerminologyProperties.Builder getTerminologyProperties() {
            return terminologyProperties != null ? terminologyProperties.toBuilder() : null;
        }

        public final void setTerminologyProperties(TerminologyProperties.BuilderImpl terminologyProperties) {
            this.terminologyProperties = terminologyProperties != null ? terminologyProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder terminologyProperties(TerminologyProperties terminologyProperties) {
            this.terminologyProperties = terminologyProperties;
            return this;
        }

        public final TerminologyDataLocation.Builder getTerminologyDataLocation() {
            return terminologyDataLocation != null ? terminologyDataLocation.toBuilder() : null;
        }

        public final void setTerminologyDataLocation(TerminologyDataLocation.BuilderImpl terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation != null ? terminologyDataLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder terminologyDataLocation(TerminologyDataLocation terminologyDataLocation) {
            this.terminologyDataLocation = terminologyDataLocation;
            return this;
        }

        public final TerminologyDataLocation.Builder getAuxiliaryDataLocation() {
            return auxiliaryDataLocation != null ? auxiliaryDataLocation.toBuilder() : null;
        }

        public final void setAuxiliaryDataLocation(TerminologyDataLocation.BuilderImpl auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation != null ? auxiliaryDataLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder auxiliaryDataLocation(TerminologyDataLocation auxiliaryDataLocation) {
            this.auxiliaryDataLocation = auxiliaryDataLocation;
            return this;
        }

        @Override
        public GetTerminologyResponse build() {
            return new GetTerminologyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
