/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateParallelDataResponse extends TranslateResponse implements
        ToCopyableBuilder<UpdateParallelDataResponse.Builder, UpdateParallelDataResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateParallelDataResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(UpdateParallelDataResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> LATEST_UPDATE_ATTEMPT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestUpdateAttemptStatus")
            .getter(getter(UpdateParallelDataResponse::latestUpdateAttemptStatusAsString))
            .setter(setter(Builder::latestUpdateAttemptStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptStatus").build())
            .build();

    private static final SdkField<Instant> LATEST_UPDATE_ATTEMPT_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestUpdateAttemptAt").getter(getter(UpdateParallelDataResponse::latestUpdateAttemptAt))
            .setter(setter(Builder::latestUpdateAttemptAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestUpdateAttemptAt").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            LATEST_UPDATE_ATTEMPT_STATUS_FIELD, LATEST_UPDATE_ATTEMPT_AT_FIELD));

    private final String name;

    private final String status;

    private final String latestUpdateAttemptStatus;

    private final Instant latestUpdateAttemptAt;

    private UpdateParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.status = builder.status;
        this.latestUpdateAttemptStatus = builder.latestUpdateAttemptStatus;
        this.latestUpdateAttemptAt = builder.latestUpdateAttemptAt;
    }

    /**
     * <p>
     * The name of the parallel data resource being updated.
     * </p>
     * 
     * @return The name of the parallel data resource being updated.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of the parallel data resource that you are attempting to update. Your update request is accepted only
     * if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ParallelDataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the parallel data resource that you are attempting to update. Your update request is
     *         accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
     * @see ParallelDataStatus
     */
    public final ParallelDataStatus status() {
        return ParallelDataStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the parallel data resource that you are attempting to update. Your update request is accepted only
     * if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ParallelDataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the parallel data resource that you are attempting to update. Your update request is
     *         accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
     * @see ParallelDataStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use,
     * the status is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestUpdateAttemptStatus} will return {@link ParallelDataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestUpdateAttemptStatusAsString}.
     * </p>
     * 
     * @return The status of the parallel data update attempt. When the updated parallel data resource is ready for you
     *         to use, the status is <code>ACTIVE</code>.
     * @see ParallelDataStatus
     */
    public final ParallelDataStatus latestUpdateAttemptStatus() {
        return ParallelDataStatus.fromValue(latestUpdateAttemptStatus);
    }

    /**
     * <p>
     * The status of the parallel data update attempt. When the updated parallel data resource is ready for you to use,
     * the status is <code>ACTIVE</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestUpdateAttemptStatus} will return {@link ParallelDataStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #latestUpdateAttemptStatusAsString}.
     * </p>
     * 
     * @return The status of the parallel data update attempt. When the updated parallel data resource is ready for you
     *         to use, the status is <code>ACTIVE</code>.
     * @see ParallelDataStatus
     */
    public final String latestUpdateAttemptStatusAsString() {
        return latestUpdateAttemptStatus;
    }

    /**
     * <p>
     * The time that the most recent update was attempted.
     * </p>
     * 
     * @return The time that the most recent update was attempted.
     */
    public final Instant latestUpdateAttemptAt() {
        return latestUpdateAttemptAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestUpdateAttemptStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestUpdateAttemptAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateParallelDataResponse)) {
            return false;
        }
        UpdateParallelDataResponse other = (UpdateParallelDataResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(latestUpdateAttemptStatusAsString(), other.latestUpdateAttemptStatusAsString())
                && Objects.equals(latestUpdateAttemptAt(), other.latestUpdateAttemptAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateParallelDataResponse").add("Name", name()).add("Status", statusAsString())
                .add("LatestUpdateAttemptStatus", latestUpdateAttemptStatusAsString())
                .add("LatestUpdateAttemptAt", latestUpdateAttemptAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "LatestUpdateAttemptStatus":
            return Optional.ofNullable(clazz.cast(latestUpdateAttemptStatusAsString()));
        case "LatestUpdateAttemptAt":
            return Optional.ofNullable(clazz.cast(latestUpdateAttemptAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateParallelDataResponse, T> g) {
        return obj -> g.apply((UpdateParallelDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateParallelDataResponse> {
        /**
         * <p>
         * The name of the parallel data resource being updated.
         * </p>
         * 
         * @param name
         *        The name of the parallel data resource being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of the parallel data resource that you are attempting to update. Your update request is accepted
         * only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the parallel data resource that you are attempting to update. Your update request is
         *        accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
         * @see ParallelDataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the parallel data resource that you are attempting to update. Your update request is accepted
         * only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
         * </p>
         * 
         * @param status
         *        The status of the parallel data resource that you are attempting to update. Your update request is
         *        accepted only if this status is either <code>ACTIVE</code> or <code>FAILED</code>.
         * @see ParallelDataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataStatus
         */
        Builder status(ParallelDataStatus status);

        /**
         * <p>
         * The status of the parallel data update attempt. When the updated parallel data resource is ready for you to
         * use, the status is <code>ACTIVE</code>.
         * </p>
         * 
         * @param latestUpdateAttemptStatus
         *        The status of the parallel data update attempt. When the updated parallel data resource is ready for
         *        you to use, the status is <code>ACTIVE</code>.
         * @see ParallelDataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataStatus
         */
        Builder latestUpdateAttemptStatus(String latestUpdateAttemptStatus);

        /**
         * <p>
         * The status of the parallel data update attempt. When the updated parallel data resource is ready for you to
         * use, the status is <code>ACTIVE</code>.
         * </p>
         * 
         * @param latestUpdateAttemptStatus
         *        The status of the parallel data update attempt. When the updated parallel data resource is ready for
         *        you to use, the status is <code>ACTIVE</code>.
         * @see ParallelDataStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParallelDataStatus
         */
        Builder latestUpdateAttemptStatus(ParallelDataStatus latestUpdateAttemptStatus);

        /**
         * <p>
         * The time that the most recent update was attempted.
         * </p>
         * 
         * @param latestUpdateAttemptAt
         *        The time that the most recent update was attempted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestUpdateAttemptAt(Instant latestUpdateAttemptAt);
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private String name;

        private String status;

        private String latestUpdateAttemptStatus;

        private Instant latestUpdateAttemptAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateParallelDataResponse model) {
            super(model);
            name(model.name);
            status(model.status);
            latestUpdateAttemptStatus(model.latestUpdateAttemptStatus);
            latestUpdateAttemptAt(model.latestUpdateAttemptAt);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(ParallelDataStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getLatestUpdateAttemptStatus() {
            return latestUpdateAttemptStatus;
        }

        public final void setLatestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
        }

        @Override
        @Transient
        public final Builder latestUpdateAttemptStatus(String latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus = latestUpdateAttemptStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder latestUpdateAttemptStatus(ParallelDataStatus latestUpdateAttemptStatus) {
            this.latestUpdateAttemptStatus(latestUpdateAttemptStatus == null ? null : latestUpdateAttemptStatus.toString());
            return this;
        }

        public final Instant getLatestUpdateAttemptAt() {
            return latestUpdateAttemptAt;
        }

        public final void setLatestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
        }

        @Override
        @Transient
        public final Builder latestUpdateAttemptAt(Instant latestUpdateAttemptAt) {
            this.latestUpdateAttemptAt = latestUpdateAttemptAt;
            return this;
        }

        @Override
        public UpdateParallelDataResponse build() {
            return new UpdateParallelDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
