/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListParallelDataResponse extends TranslateResponse implements
        ToCopyableBuilder<ListParallelDataResponse.Builder, ListParallelDataResponse> {
    private static final SdkField<List<ParallelDataProperties>> PARALLEL_DATA_PROPERTIES_LIST_FIELD = SdkField
            .<List<ParallelDataProperties>> builder(MarshallingType.LIST)
            .memberName("ParallelDataPropertiesList")
            .getter(getter(ListParallelDataResponse::parallelDataPropertiesList))
            .setter(setter(Builder::parallelDataPropertiesList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataPropertiesList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ParallelDataProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParallelDataProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListParallelDataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PARALLEL_DATA_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ParallelDataProperties> parallelDataPropertiesList;

    private final String nextToken;

    private ListParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.parallelDataPropertiesList = builder.parallelDataPropertiesList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParallelDataPropertiesList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasParallelDataPropertiesList() {
        return parallelDataPropertiesList != null && !(parallelDataPropertiesList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The properties of the parallel data resources returned by this request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParallelDataPropertiesList} method.
     * </p>
     * 
     * @return The properties of the parallel data resources returned by this request.
     */
    public final List<ParallelDataProperties> parallelDataPropertiesList() {
        return parallelDataPropertiesList;
    }

    /**
     * <p>
     * The string to use in a subsequent request to get the next page of results in a paginated response. This value is
     * null if there are no additional pages.
     * </p>
     * 
     * @return The string to use in a subsequent request to get the next page of results in a paginated response. This
     *         value is null if there are no additional pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasParallelDataPropertiesList() ? parallelDataPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParallelDataResponse)) {
            return false;
        }
        ListParallelDataResponse other = (ListParallelDataResponse) obj;
        return hasParallelDataPropertiesList() == other.hasParallelDataPropertiesList()
                && Objects.equals(parallelDataPropertiesList(), other.parallelDataPropertiesList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListParallelDataResponse")
                .add("ParallelDataPropertiesList", hasParallelDataPropertiesList() ? parallelDataPropertiesList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParallelDataPropertiesList":
            return Optional.ofNullable(clazz.cast(parallelDataPropertiesList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListParallelDataResponse, T> g) {
        return obj -> g.apply((ListParallelDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListParallelDataResponse> {
        /**
         * <p>
         * The properties of the parallel data resources returned by this request.
         * </p>
         * 
         * @param parallelDataPropertiesList
         *        The properties of the parallel data resources returned by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataPropertiesList(Collection<ParallelDataProperties> parallelDataPropertiesList);

        /**
         * <p>
         * The properties of the parallel data resources returned by this request.
         * </p>
         * 
         * @param parallelDataPropertiesList
         *        The properties of the parallel data resources returned by this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelDataPropertiesList(ParallelDataProperties... parallelDataPropertiesList);

        /**
         * <p>
         * The properties of the parallel data resources returned by this request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ParallelDataProperties>.Builder}
         * avoiding the need to create one manually via {@link List<ParallelDataProperties>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ParallelDataProperties>.Builder#build()} is called
         * immediately and its result is passed to {@link #parallelDataPropertiesList(List<ParallelDataProperties>)}.
         * 
         * @param parallelDataPropertiesList
         *        a consumer that will call methods on {@link List<ParallelDataProperties>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelDataPropertiesList(List<ParallelDataProperties>)
         */
        Builder parallelDataPropertiesList(Consumer<ParallelDataProperties.Builder>... parallelDataPropertiesList);

        /**
         * <p>
         * The string to use in a subsequent request to get the next page of results in a paginated response. This value
         * is null if there are no additional pages.
         * </p>
         * 
         * @param nextToken
         *        The string to use in a subsequent request to get the next page of results in a paginated response.
         *        This value is null if there are no additional pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private List<ParallelDataProperties> parallelDataPropertiesList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParallelDataResponse model) {
            super(model);
            parallelDataPropertiesList(model.parallelDataPropertiesList);
            nextToken(model.nextToken);
        }

        public final List<ParallelDataProperties.Builder> getParallelDataPropertiesList() {
            List<ParallelDataProperties.Builder> result = ParallelDataPropertiesListCopier
                    .copyToBuilder(this.parallelDataPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParallelDataPropertiesList(Collection<ParallelDataProperties.BuilderImpl> parallelDataPropertiesList) {
            this.parallelDataPropertiesList = ParallelDataPropertiesListCopier.copyFromBuilder(parallelDataPropertiesList);
        }

        @Override
        @Transient
        public final Builder parallelDataPropertiesList(Collection<ParallelDataProperties> parallelDataPropertiesList) {
            this.parallelDataPropertiesList = ParallelDataPropertiesListCopier.copy(parallelDataPropertiesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parallelDataPropertiesList(ParallelDataProperties... parallelDataPropertiesList) {
            parallelDataPropertiesList(Arrays.asList(parallelDataPropertiesList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parallelDataPropertiesList(Consumer<ParallelDataProperties.Builder>... parallelDataPropertiesList) {
            parallelDataPropertiesList(Stream.of(parallelDataPropertiesList)
                    .map(c -> ParallelDataProperties.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListParallelDataResponse build() {
            return new ListParallelDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
