/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLanguagesResponse extends TranslateResponse implements
        ToCopyableBuilder<ListLanguagesResponse.Builder, ListLanguagesResponse> {
    private static final SdkField<List<Language>> LANGUAGES_FIELD = SdkField
            .<List<Language>> builder(MarshallingType.LIST)
            .memberName("Languages")
            .getter(getter(ListLanguagesResponse::languages))
            .setter(setter(Builder::languages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Languages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Language> builder(MarshallingType.SDK_POJO)
                                            .constructor(Language::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DISPLAY_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayLanguageCode").getter(getter(ListLanguagesResponse::displayLanguageCodeAsString))
            .setter(setter(Builder::displayLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayLanguageCode").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLanguagesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGES_FIELD,
            DISPLAY_LANGUAGE_CODE_FIELD, NEXT_TOKEN_FIELD));

    private final List<Language> languages;

    private final String displayLanguageCode;

    private final String nextToken;

    private ListLanguagesResponse(BuilderImpl builder) {
        super(builder);
        this.languages = builder.languages;
        this.displayLanguageCode = builder.displayLanguageCode;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Languages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLanguages() {
        return languages != null && !(languages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of supported languages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLanguages} method.
     * </p>
     * 
     * @return The list of supported languages.
     */
    public final List<Language> languages() {
        return languages;
    }

    /**
     * <p>
     * The language code passed in with the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayLanguageCode} will return {@link DisplayLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #displayLanguageCodeAsString}.
     * </p>
     * 
     * @return The language code passed in with the request.
     * @see DisplayLanguageCode
     */
    public final DisplayLanguageCode displayLanguageCode() {
        return DisplayLanguageCode.fromValue(displayLanguageCode);
    }

    /**
     * <p>
     * The language code passed in with the request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #displayLanguageCode} will return {@link DisplayLanguageCode#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #displayLanguageCodeAsString}.
     * </p>
     * 
     * @return The language code passed in with the request.
     * @see DisplayLanguageCode
     */
    public final String displayLanguageCodeAsString() {
        return displayLanguageCode;
    }

    /**
     * <p>
     * If the response does not include all remaining results, use the NextToken in the next request to fetch the next
     * group of supported languages.
     * </p>
     * 
     * @return If the response does not include all remaining results, use the NextToken in the next request to fetch
     *         the next group of supported languages.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLanguages() ? languages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(displayLanguageCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLanguagesResponse)) {
            return false;
        }
        ListLanguagesResponse other = (ListLanguagesResponse) obj;
        return hasLanguages() == other.hasLanguages() && Objects.equals(languages(), other.languages())
                && Objects.equals(displayLanguageCodeAsString(), other.displayLanguageCodeAsString())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLanguagesResponse").add("Languages", hasLanguages() ? languages() : null)
                .add("DisplayLanguageCode", displayLanguageCodeAsString()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Languages":
            return Optional.ofNullable(clazz.cast(languages()));
        case "DisplayLanguageCode":
            return Optional.ofNullable(clazz.cast(displayLanguageCodeAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLanguagesResponse, T> g) {
        return obj -> g.apply((ListLanguagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends TranslateResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListLanguagesResponse> {
        /**
         * <p>
         * The list of supported languages.
         * </p>
         * 
         * @param languages
         *        The list of supported languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Collection<Language> languages);

        /**
         * <p>
         * The list of supported languages.
         * </p>
         * 
         * @param languages
         *        The list of supported languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder languages(Language... languages);

        /**
         * <p>
         * The list of supported languages.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Language>.Builder} avoiding the need
         * to create one manually via {@link List<Language>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Language>.Builder#build()} is called immediately and its
         * result is passed to {@link #languages(List<Language>)}.
         * 
         * @param languages
         *        a consumer that will call methods on {@link List<Language>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #languages(List<Language>)
         */
        Builder languages(Consumer<Language.Builder>... languages);

        /**
         * <p>
         * The language code passed in with the request.
         * </p>
         * 
         * @param displayLanguageCode
         *        The language code passed in with the request.
         * @see DisplayLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayLanguageCode
         */
        Builder displayLanguageCode(String displayLanguageCode);

        /**
         * <p>
         * The language code passed in with the request.
         * </p>
         * 
         * @param displayLanguageCode
         *        The language code passed in with the request.
         * @see DisplayLanguageCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DisplayLanguageCode
         */
        Builder displayLanguageCode(DisplayLanguageCode displayLanguageCode);

        /**
         * <p>
         * If the response does not include all remaining results, use the NextToken in the next request to fetch the
         * next group of supported languages.
         * </p>
         * 
         * @param nextToken
         *        If the response does not include all remaining results, use the NextToken in the next request to fetch
         *        the next group of supported languages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends TranslateResponse.BuilderImpl implements Builder {
        private List<Language> languages = DefaultSdkAutoConstructList.getInstance();

        private String displayLanguageCode;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLanguagesResponse model) {
            super(model);
            languages(model.languages);
            displayLanguageCode(model.displayLanguageCode);
            nextToken(model.nextToken);
        }

        public final List<Language.Builder> getLanguages() {
            List<Language.Builder> result = LanguagesListCopier.copyToBuilder(this.languages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLanguages(Collection<Language.BuilderImpl> languages) {
            this.languages = LanguagesListCopier.copyFromBuilder(languages);
        }

        @Override
        public final Builder languages(Collection<Language> languages) {
            this.languages = LanguagesListCopier.copy(languages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Language... languages) {
            languages(Arrays.asList(languages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder languages(Consumer<Language.Builder>... languages) {
            languages(Stream.of(languages).map(c -> Language.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDisplayLanguageCode() {
            return displayLanguageCode;
        }

        public final void setDisplayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
        }

        @Override
        public final Builder displayLanguageCode(String displayLanguageCode) {
            this.displayLanguageCode = displayLanguageCode;
            return this;
        }

        @Override
        public final Builder displayLanguageCode(DisplayLanguageCode displayLanguageCode) {
            this.displayLanguageCode(displayLanguageCode == null ? null : displayLanguageCode.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLanguagesResponse build() {
            return new ListLanguagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
