/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.translate.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The confidence that Amazon Comprehend accurately detected the source language is low. If a low confidence level is
 * acceptable for your application, you can use the language in the exception to call Amazon Translate again. For more
 * information, see the <a
 * href="https://docs.aws.amazon.com/comprehend/latest/dg/API_DetectDominantLanguage.html">DetectDominantLanguage</a>
 * operation in the <i>Amazon Comprehend Developer Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectedLanguageLowConfidenceException extends TranslateException implements
        ToCopyableBuilder<DetectedLanguageLowConfidenceException.Builder, DetectedLanguageLowConfidenceException> {
    private static final SdkField<String> DETECTED_LANGUAGE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetectedLanguageCode").getter(getter(DetectedLanguageLowConfidenceException::detectedLanguageCode))
            .setter(setter(Builder::detectedLanguageCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetectedLanguageCode").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETECTED_LANGUAGE_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String detectedLanguageCode;

    private DetectedLanguageLowConfidenceException(BuilderImpl builder) {
        super(builder);
        this.detectedLanguageCode = builder.detectedLanguageCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The language code of the auto-detected language from Amazon Comprehend.
     * </p>
     * 
     * @return The language code of the auto-detected language from Amazon Comprehend.
     */
    public String detectedLanguageCode() {
        return detectedLanguageCode;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectedLanguageLowConfidenceException, T> g) {
        return obj -> g.apply((DetectedLanguageLowConfidenceException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DetectedLanguageLowConfidenceException>,
            TranslateException.Builder {
        /**
         * <p>
         * The language code of the auto-detected language from Amazon Comprehend.
         * </p>
         * 
         * @param detectedLanguageCode
         *        The language code of the auto-detected language from Amazon Comprehend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detectedLanguageCode(String detectedLanguageCode);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends TranslateException.BuilderImpl implements Builder {
        private String detectedLanguageCode;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectedLanguageLowConfidenceException model) {
            super(model);
            detectedLanguageCode(model.detectedLanguageCode);
        }

        public final String getDetectedLanguageCode() {
            return detectedLanguageCode;
        }

        public final void setDetectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
        }

        @Override
        public final Builder detectedLanguageCode(String detectedLanguageCode) {
            this.detectedLanguageCode = detectedLanguageCode;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DetectedLanguageLowConfidenceException build() {
            return new DetectedLanguageLowConfidenceException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
