/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.translate.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.translate.model.ParallelDataProperties;
import software.amazon.awssdk.services.translate.model.ParallelDataPropertiesListCopier;
import software.amazon.awssdk.services.translate.model.TranslateResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListParallelDataResponse
extends TranslateResponse
implements ToCopyableBuilder<Builder, ListParallelDataResponse> {
    private static final SdkField<List<ParallelDataProperties>> PARALLEL_DATA_PROPERTIES_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ParallelDataPropertiesList").getter(ListParallelDataResponse.getter(ListParallelDataResponse::parallelDataPropertiesList)).setter(ListParallelDataResponse.setter(Builder::parallelDataPropertiesList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParallelDataPropertiesList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ParallelDataProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListParallelDataResponse.getter(ListParallelDataResponse::nextToken)).setter(ListParallelDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARALLEL_DATA_PROPERTIES_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ParallelDataProperties> parallelDataPropertiesList;
    private final String nextToken;

    private ListParallelDataResponse(BuilderImpl builder) {
        super(builder);
        this.parallelDataPropertiesList = builder.parallelDataPropertiesList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasParallelDataPropertiesList() {
        return this.parallelDataPropertiesList != null && !(this.parallelDataPropertiesList instanceof SdkAutoConstructList);
    }

    public final List<ParallelDataProperties> parallelDataPropertiesList() {
        return this.parallelDataPropertiesList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParallelDataPropertiesList() ? this.parallelDataPropertiesList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListParallelDataResponse)) {
            return false;
        }
        ListParallelDataResponse other = (ListParallelDataResponse)((Object)obj);
        return this.hasParallelDataPropertiesList() == other.hasParallelDataPropertiesList() && Objects.equals(this.parallelDataPropertiesList(), other.parallelDataPropertiesList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListParallelDataResponse").add("ParallelDataPropertiesList", this.hasParallelDataPropertiesList() ? this.parallelDataPropertiesList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParallelDataPropertiesList": {
                return Optional.ofNullable(clazz.cast(this.parallelDataPropertiesList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListParallelDataResponse, T> g) {
        return obj -> g.apply((ListParallelDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TranslateResponse.BuilderImpl
    implements Builder {
        private List<ParallelDataProperties> parallelDataPropertiesList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListParallelDataResponse model) {
            super(model);
            this.parallelDataPropertiesList(model.parallelDataPropertiesList);
            this.nextToken(model.nextToken);
        }

        public final List<ParallelDataProperties.Builder> getParallelDataPropertiesList() {
            List<ParallelDataProperties.Builder> result = ParallelDataPropertiesListCopier.copyToBuilder(this.parallelDataPropertiesList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setParallelDataPropertiesList(Collection<ParallelDataProperties.BuilderImpl> parallelDataPropertiesList) {
            this.parallelDataPropertiesList = ParallelDataPropertiesListCopier.copyFromBuilder(parallelDataPropertiesList);
        }

        @Override
        @Transient
        public final Builder parallelDataPropertiesList(Collection<ParallelDataProperties> parallelDataPropertiesList) {
            this.parallelDataPropertiesList = ParallelDataPropertiesListCopier.copy(parallelDataPropertiesList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parallelDataPropertiesList(ParallelDataProperties ... parallelDataPropertiesList) {
            this.parallelDataPropertiesList(Arrays.asList(parallelDataPropertiesList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder parallelDataPropertiesList(Consumer<ParallelDataProperties.Builder> ... parallelDataPropertiesList) {
            this.parallelDataPropertiesList(Stream.of(parallelDataPropertiesList).map(c -> (ParallelDataProperties)((ParallelDataProperties.Builder)ParallelDataProperties.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListParallelDataResponse build() {
            return new ListParallelDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends TranslateResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListParallelDataResponse> {
        public Builder parallelDataPropertiesList(Collection<ParallelDataProperties> var1);

        public Builder parallelDataPropertiesList(ParallelDataProperties ... var1);

        public Builder parallelDataPropertiesList(Consumer<ParallelDataProperties.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

